/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.diff;

import org.w3c.dom.Node;
import wiremock.org.xmlunit.diff.AbstractDifferenceEngine;
import wiremock.org.xmlunit.diff.ComparisonFormatter;
import wiremock.org.xmlunit.diff.ComparisonType;
import wiremock.org.xmlunit.diff.DefaultComparisonFormatter;
import wiremock.org.xmlunit.diff.XPathContext;

public class Comparison {
    private final Detail control;
    private final Detail test;
    private final ComparisonType type;

    public Comparison(ComparisonType t, Node controlTarget, String controlXPath, Object controlValue, String controlParentXPath, Node testTarget, String testXPath, Object testValue, String testParentXPath) {
        this.type = t;
        this.control = new Detail(controlTarget, controlXPath, controlValue, controlParentXPath);
        this.test = new Detail(testTarget, testXPath, testValue, testParentXPath);
    }

    public Comparison(ComparisonType t, XPathContext controlContext, Node controlTarget, Object controlValue, XPathContext testContext, Node testTarget, Object testValue) {
        this(t, controlTarget, AbstractDifferenceEngine.getXPath(controlContext), controlValue, AbstractDifferenceEngine.getParentXPath(controlContext), testTarget, AbstractDifferenceEngine.getXPath(testContext), testValue, AbstractDifferenceEngine.getParentXPath(testContext));
    }

    public ComparisonType getType() {
        return this.type;
    }

    public Detail getControlDetails() {
        return this.control;
    }

    public Detail getTestDetails() {
        return this.test;
    }

    public String toString(ComparisonFormatter formatter) {
        return formatter.getDescription(this);
    }

    public String toString() {
        return this.toString(new DefaultComparisonFormatter());
    }

    public static class Detail {
        private final Node target;
        private final String xpath;
        private final Object value;
        private final String parentXPath;

        private Detail(Node n, String x, Object v, String parentX) {
            this.target = n;
            this.xpath = x;
            this.value = v;
            this.parentXPath = parentX;
        }

        public Node getTarget() {
            return this.target;
        }

        public String getXPath() {
            return this.xpath;
        }

        public Object getValue() {
            return this.value;
        }

        public String getParentXPath() {
            return this.parentXPath;
        }
    }
}

