/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.protocol;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.EndpointDetails;
import wiremock.org.apache.hc.core5.http.EntityDetails;
import wiremock.org.apache.hc.core5.http.Header;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.HttpRequestInterceptor;
import wiremock.org.apache.hc.core5.http.HttpVersion;
import wiremock.org.apache.hc.core5.http.ProtocolException;
import wiremock.org.apache.hc.core5.http.ProtocolVersion;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.http.protocol.HttpCoreContext;
import wiremock.org.apache.hc.core5.net.URIAuthority;
import wiremock.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ForwardedRequest
implements HttpRequestInterceptor {
    private static final String FORWARDED_HEADER_NAME = "Forwarded";
    public static final HttpRequestInterceptor INSTANCE = new ForwardedRequest();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext localContext) throws HttpException, IOException {
        String protoValue;
        EndpointDetails endpointDetails;
        boolean forwardedHeaderExists;
        Args.notNull(request, "HTTP request");
        Args.notNull(localContext, "HTTP context");
        HttpCoreContext context = HttpCoreContext.cast(localContext);
        ProtocolVersion ver = context.getProtocolVersion() != null ? context.getProtocolVersion() : HttpVersion.HTTP_1_1;
        URIAuthority authority = request.getAuthority();
        if (authority == null) {
            throw new ProtocolException("Request authority not specified");
        }
        int port = authority.getPort();
        StringBuilder valueBuilder = new StringBuilder();
        Header forwardedHeader = request.getFirstHeader(FORWARDED_HEADER_NAME);
        boolean bl = forwardedHeaderExists = forwardedHeader != null;
        if (forwardedHeaderExists) {
            valueBuilder.append(forwardedHeader.getValue());
            valueBuilder.append(", ");
        }
        if ((endpointDetails = context.getEndpointDetails()) != null) {
            SocketAddress localAddress;
            SocketAddress remoteAddress = endpointDetails.getRemoteAddress();
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddress = (InetSocketAddress)remoteAddress;
                String byValue = inetAddress.getHostString() + ":" + inetAddress.getPort();
                if (inetAddress.getAddress() instanceof Inet6Address) {
                    valueBuilder.append("by=\"").append(byValue).append("\"");
                } else {
                    valueBuilder.append("by=").append(byValue);
                }
            }
            if ((localAddress = endpointDetails.getLocalAddress()) instanceof InetSocketAddress) {
                InetSocketAddress inetAddress = (InetSocketAddress)localAddress;
                String forValue = inetAddress.getHostString() + ":" + inetAddress.getPort();
                if (inetAddress.getAddress() instanceof Inet6Address) {
                    valueBuilder.append(";for=\"").append(forValue).append("\"");
                } else {
                    valueBuilder.append(";for=").append(forValue);
                }
            }
        }
        if (valueBuilder.length() > 0 && !forwardedHeaderExists) {
            valueBuilder.append(";");
        }
        valueBuilder.append("host=\"").append(authority.getHostName()).append("\"");
        if (port != -1) {
            valueBuilder.append(";port=").append(port);
        }
        if ((protoValue = ver.getProtocol()) != null) {
            valueBuilder.append(";proto=").append(protoValue);
        }
        String value = valueBuilder.toString();
        request.setHeader(FORWARDED_HEADER_NAME, value);
    }
}

