/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.serialization;

import java.io.IOException;
import java.io.InputStream;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;
import wiremock.com.networknt.schema.InputFormat;
import wiremock.com.networknt.schema.serialization.JsonMapperFactory;
import wiremock.com.networknt.schema.serialization.JsonNodeReader;
import wiremock.com.networknt.schema.serialization.YamlMapperFactory;
import wiremock.com.networknt.schema.serialization.node.JsonNodeFactoryFactory;
import wiremock.com.networknt.schema.serialization.node.LocationJsonNodeFactoryFactory;
import wiremock.com.networknt.schema.utils.JsonNodes;

public class DefaultJsonNodeReader
implements JsonNodeReader {
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper yamlMapper;
    protected final JsonNodeFactoryFactory jsonNodeFactoryFactory;

    protected DefaultJsonNodeReader(ObjectMapper jsonMapper, ObjectMapper yamlMapper, JsonNodeFactoryFactory jsonNodeFactoryFactory) {
        this.jsonMapper = jsonMapper;
        this.yamlMapper = yamlMapper;
        this.jsonNodeFactoryFactory = jsonNodeFactoryFactory;
    }

    @Override
    public JsonNode readTree(String content, InputFormat inputFormat) throws IOException {
        if (this.jsonNodeFactoryFactory == null) {
            return this.getObjectMapper(inputFormat).readTree(content);
        }
        return JsonNodes.readTree(this.getObjectMapper(inputFormat), content, this.jsonNodeFactoryFactory);
    }

    @Override
    public JsonNode readTree(InputStream content, InputFormat inputFormat) throws IOException {
        if (this.jsonNodeFactoryFactory == null) {
            return this.getObjectMapper(inputFormat).readTree(content);
        }
        return JsonNodes.readTree(this.getObjectMapper(inputFormat), content, this.jsonNodeFactoryFactory);
    }

    protected ObjectMapper getYamlMapper() {
        return this.yamlMapper != null ? this.yamlMapper : YamlMapperFactory.getInstance();
    }

    protected ObjectMapper getJsonMapper() {
        return this.jsonMapper != null ? this.jsonMapper : JsonMapperFactory.getInstance();
    }

    protected ObjectMapper getObjectMapper(InputFormat inputFormat) {
        if (InputFormat.JSON.equals((Object)inputFormat)) {
            return this.getJsonMapper();
        }
        if (InputFormat.YAML.equals((Object)inputFormat)) {
            return this.getYamlMapper();
        }
        throw new IllegalArgumentException("Unsupported input format " + (Object)((Object)inputFormat));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BuilderSupport<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        public Builder locationAware() {
            return (Builder)this.jsonNodeFactoryFactory(LocationJsonNodeFactoryFactory.getInstance());
        }

        public JsonNodeReader build() {
            return new DefaultJsonNodeReader(this.jsonMapper, this.yamlMapper, this.jsonNodeFactoryFactory);
        }
    }

    public static abstract class BuilderSupport<T> {
        protected ObjectMapper jsonMapper = null;
        protected ObjectMapper yamlMapper = null;
        protected JsonNodeFactoryFactory jsonNodeFactoryFactory = null;

        protected abstract T self();

        public T jsonMapper(ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
            return this.self();
        }

        public T yamlMapper(ObjectMapper yamlMapper) {
            this.yamlMapper = yamlMapper;
            return this.self();
        }

        public T jsonNodeFactoryFactory(JsonNodeFactoryFactory jsonNodeFactoryFactory) {
            this.jsonNodeFactoryFactory = jsonNodeFactoryFactory;
            return this.self();
        }
    }
}

