/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Strings {
    private Strings() {
    }

    private static ThreadLocalRandom random() {
        return ThreadLocalRandom.current();
    }

    public static int getLevenshteinDistance(CharSequence s, CharSequence t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            CharSequence tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            int upperleft = p[0];
            char jOfT = t.charAt(j - 1);
            p[0] = j;
            for (i = 1; i <= n; ++i) {
                int upper = p[i];
                int cost = s.charAt(i - 1) == jOfT ? 0 : 1;
                p[i] = Math.min(Math.min(p[i - 1] + 1, p[i] + 1), upperleft + cost);
                upperleft = upper;
            }
        }
        return p[n];
    }

    public static String randomAlphanumeric(int count) {
        return Strings.random(count, true, true);
    }

    public static String random(int count, boolean letters, boolean numbers) {
        return Strings.random(count, 0, 0, letters, numbers);
    }

    public static String randomAlphabetic(int count) {
        return Strings.random(count, true, false);
    }

    public static String randomNumeric(int count) {
        return Strings.random(count, false, true);
    }

    public static String random(int count, String chars) {
        if (chars == null) {
            return Strings.random(count, 0, 0, false, false, null, Strings.random());
        }
        return Strings.random(count, chars.toCharArray());
    }

    public static String random(int count, char ... chars) {
        if (chars == null) {
            return Strings.random(count, 0, 0, false, false, null, Strings.random());
        }
        return Strings.random(count, 0, chars.length, false, false, chars, Strings.random());
    }

    public static String randomAscii(int count) {
        return Strings.random(count, 32, 127, false, false);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers) {
        return Strings.random(count, start, end, letters, numbers, null, Strings.random());
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
        }
        if (chars != null && chars.length == 0) {
            throw new IllegalArgumentException("The chars array must not be empty");
        }
        if (start == 0 && end == 0) {
            if (chars != null) {
                end = chars.length;
            } else if (!letters && !numbers) {
                end = 0x10FFFF;
            } else {
                end = 123;
                start = 32;
            }
        } else if (end <= start) {
            throw new IllegalArgumentException("Parameter end (" + end + ") must be greater than start (" + start + ")");
        }
        int zeroDigitAscii = 48;
        int firstLetterAscii = 65;
        if (chars == null && (numbers && end <= 48 || letters && end <= 65)) {
            throw new IllegalArgumentException("Parameter end (" + end + ") must be greater then (48) for generating digits or greater then (65) for generating letters.");
        }
        StringBuilder builder = new StringBuilder(count);
        int gap = end - start;
        block3: while (count-- != 0) {
            int codePoint;
            if (chars == null) {
                codePoint = random.nextInt(gap) + start;
                switch (Character.getType(codePoint)) {
                    case 0: 
                    case 18: 
                    case 19: {
                        ++count;
                        continue block3;
                    }
                }
            } else {
                codePoint = chars[random.nextInt(gap) + start];
            }
            int numberOfChars = Character.charCount(codePoint);
            if (count == 0 && numberOfChars > 1) {
                ++count;
                continue;
            }
            if (letters && Character.isLetter(codePoint) || numbers && Character.isDigit(codePoint) || !letters && !numbers) {
                builder.appendCodePoint(codePoint);
                if (numberOfChars != 2) continue;
                --count;
                continue;
            }
            ++count;
        }
        return builder.toString();
    }

    public static String rightPad(String str, int size) {
        return Strings.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return Strings.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(Strings.repeat(padChar, pads));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (Strings.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return Strings.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return "";
        }
        char[] buf = new char[repeat];
        Arrays.fill(buf, ch);
        return new String(buf);
    }

    public static String stringFromBytes(byte[] bytes) {
        return Strings.stringFromBytes(bytes, StandardCharsets.UTF_8);
    }

    public static String stringFromBytes(byte[] bytes, Charset charset) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, charset);
    }

    public static byte[] bytesFromString(String str) {
        return Strings.bytesFromString(str, StandardCharsets.UTF_8);
    }

    public static byte[] bytesFromString(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        return str.getBytes(charset);
    }

    public static String wrapIfLongestLineExceedsLimit(String s, int maxLineLength) {
        int longestLength = Strings.findLongestLineLength(s);
        if (longestLength > maxLineLength) {
            String wrapped = Strings.wrap(s, maxLineLength, null, true);
            return wrapped.replaceAll("(?m)^[ \t]*\r?\n", "");
        }
        return s;
    }

    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        return Strings.wrap(str, wrapLength, newLineStr, wrapLongWords, " ");
    }

    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords, String wrapOn) {
        if (str == null) {
            return null;
        }
        if (newLineStr == null) {
            newLineStr = System.lineSeparator();
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        if (Strings.isBlank(wrapOn)) {
            wrapOn = " ";
        }
        Pattern patternToWrapOn = Pattern.compile(wrapOn);
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (offset < inputLineLength) {
            int spaceToWrapAt = -1;
            Matcher matcher = patternToWrapOn.matcher(str.substring(offset, Math.min((int)Math.min(Integer.MAX_VALUE, (long)(offset + wrapLength) + 1L), inputLineLength)));
            if (matcher.find()) {
                if (matcher.start() == 0) {
                    offset += matcher.end();
                    continue;
                }
                spaceToWrapAt = matcher.start() + offset;
            }
            if (inputLineLength - offset <= wrapLength) break;
            while (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset;
            }
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str, offset, wrapLength + offset);
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            matcher = patternToWrapOn.matcher(str.substring(offset + wrapLength));
            if (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset + wrapLength;
            }
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str, offset, str.length());
            offset = inputLineLength;
        }
        wrappedLine.append(str, offset, str.length());
        return wrappedLine.toString();
    }

    public static String substringAfterLast(String str, int separator) {
        if (Strings.isEmpty(str)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - 1) {
            return "";
        }
        return str.substring(pos + 1);
    }

    public static String substringAfterLast(String str, String separator) {
        if (Strings.isEmpty(str)) {
            return str;
        }
        if (Strings.isEmpty(separator)) {
            return "";
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static int countMatches(CharSequence str, char ch) {
        if (Strings.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (ch != str.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal) {
        return Strings.ordinalIndexOf(str, searchStr, ordinal, false);
    }

    private static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal, boolean lastIndex) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return lastIndex ? str.length() : 0;
        }
        int found = 0;
        int index = lastIndex ? str.length() : -1;
        do {
            if ((index = lastIndex ? Strings.lastIndexOf(str, searchStr, index - 1) : Strings.indexOf(str, searchStr, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    private static int findLongestLineLength(String s) {
        String[] lines = s.split("\n");
        int longestLength = 0;
        for (String line : lines) {
            int length = line.length();
            if (length <= longestLength) continue;
            longestLength = length;
        }
        return longestLength;
    }

    public static double normalisedLevenshteinDistance(String one, String two) {
        if (one == null || two == null) {
            return 1.0;
        }
        double maxDistance = Math.max(one.length(), two.length());
        double actualDistance = Strings.getLevenshteinDistance(one, two);
        return actualDistance / maxDistance;
    }

    public static String normaliseLineBreaks(String s) {
        return s.replace("\r\n", "\n").replace("\n", System.lineSeparator());
    }

    public static boolean isNullOrEmpty(String s) {
        return Strings.isNull(s) || s.isEmpty();
    }

    public static boolean isNotNullOrEmpty(String s) {
        return !Strings.isNullOrEmpty(s);
    }

    public static boolean isBlank(String s) {
        return Strings.isNull(s) || s.isBlank();
    }

    public static boolean isNotBlank(String s) {
        return !Strings.isBlank(s);
    }

    public static boolean isNull(String s) {
        return s == null;
    }

    public static boolean isNotNull(String s) {
        return !Strings.isNull(s);
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isEmpty(String s) {
        return Strings.isNull(s) || s.isEmpty();
    }

    public static boolean isNotEmpty(String s) {
        return !Strings.isEmpty(s);
    }

    public static String removeStart(String str, String remove) {
        if (Strings.isEmpty(str) || Strings.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    private static boolean checkLaterThan1(CharSequence cs, CharSequence searchChar, int len2, int start1) {
        int i = 1;
        for (int j = len2 - 1; i <= j; ++i, --j) {
            if (cs.charAt(start1 + i) == searchChar.charAt(i) && cs.charAt(start1 + j) == searchChar.charAt(j)) continue;
            return false;
        }
        return true;
    }

    private static int indexOf(CharSequence cs, CharSequence searchChar, int start) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar.toString(), start);
        }
        if (cs instanceof StringBuilder) {
            return ((StringBuilder)cs).indexOf(searchChar.toString(), start);
        }
        if (cs instanceof StringBuffer) {
            return ((StringBuffer)cs).indexOf(searchChar.toString(), start);
        }
        return cs.toString().indexOf(searchChar.toString(), start);
    }

    /*
     * Unable to fully structure code
     */
    private static int lastIndexOf(CharSequence cs, CharSequence searchChar, int start) {
        if (searchChar == null || cs == null) {
            return -1;
        }
        if (searchChar instanceof String) {
            if (cs instanceof String) {
                return ((String)cs).lastIndexOf((String)searchChar, start);
            }
            if (cs instanceof StringBuilder) {
                return ((StringBuilder)cs).lastIndexOf((String)searchChar, start);
            }
            if (cs instanceof StringBuffer) {
                return ((StringBuffer)cs).lastIndexOf((String)searchChar, start);
            }
        }
        len1 = cs.length();
        len2 = searchChar.length();
        if (start > len1) {
            start = len1;
        }
        if (start < 0 || len2 > len1) {
            return -1;
        }
        if (len2 == 0) {
            return start;
        }
        if (len2 <= 16) {
            if (cs instanceof String) {
                return ((String)cs).lastIndexOf(searchChar.toString(), start);
            }
            if (cs instanceof StringBuilder) {
                return ((StringBuilder)cs).lastIndexOf(searchChar.toString(), start);
            }
            if (cs instanceof StringBuffer) {
                return ((StringBuffer)cs).lastIndexOf(searchChar.toString(), start);
            }
        }
        if (start + len2 > len1) {
            start = len1 - len2;
        }
        char0 = searchChar.charAt(0);
        i = start;
        do lbl-1000:
        // 3 sources

        {
            block14: {
                if (cs.charAt(i) == char0) break block14;
                if (--i >= 0) ** GOTO lbl-1000
                return -1;
            }
            if (!Strings.checkLaterThan1(cs, searchChar, len2, i)) continue;
            return i;
        } while (--i >= 0);
        return -1;
    }
}

