/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.function.Supplier;
import org.wildfly.security.authz.AggregateAttributes;
import org.wildfly.security.authz.Attributes;

public interface AuthorizationIdentity {
    public static final AuthorizationIdentity EMPTY = AuthorizationIdentity.basicIdentity(Attributes.EMPTY);

    default public Attributes getAttributes() {
        return Attributes.EMPTY;
    }

    default public Attributes getRuntimeAttributes() {
        return Attributes.EMPTY;
    }

    public static AuthorizationIdentity basicIdentity(Attributes attributes) {
        return AuthorizationIdentity.basicIdentity(() -> attributes, "EMPTY");
    }

    public static AuthorizationIdentity basicIdentity(final Supplier<Attributes> attributes, final String string) {
        return new AuthorizationIdentity(){

            @Override
            public Attributes getAttributes() {
                return (Attributes)attributes.get();
            }

            public String toString() {
                return string;
            }
        };
    }

    public static AuthorizationIdentity basicIdentity(final Supplier<Attributes> attributes, final Supplier<Attributes> runtimeAttributes, final String string) {
        return new AuthorizationIdentity(){

            @Override
            public Attributes getAttributes() {
                return (Attributes)attributes.get();
            }

            @Override
            public Attributes getRuntimeAttributes() {
                return (Attributes)runtimeAttributes.get();
            }

            public String toString() {
                return string;
            }
        };
    }

    public static AuthorizationIdentity basicIdentity(AuthorizationIdentity authorizationIdentity, Attributes runtimeAttributes) {
        Attributes attributes = authorizationIdentity.getAttributes();
        Attributes combinedRuntimeAttributes = AggregateAttributes.aggregateOf(authorizationIdentity.getRuntimeAttributes(), runtimeAttributes);
        return AuthorizationIdentity.basicIdentity(() -> attributes, () -> combinedRuntimeAttributes, "EMPTY");
    }
}

