/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.springframework.core.ResolvableType;
import org.springframework.test.context.bean.override.BeanOverrideProcessor;
import org.springframework.test.context.bean.override.mockito.AbstractMockitoBeanOverrideHandler;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.context.bean.override.mockito.MockitoBeanOverrideHandler;
import org.springframework.test.context.bean.override.mockito.MockitoSpyBean;
import org.springframework.test.context.bean.override.mockito.MockitoSpyBeanOverrideHandler;

class MockitoBeanOverrideProcessor
implements BeanOverrideProcessor {
    MockitoBeanOverrideProcessor() {
    }

    @Override
    public AbstractMockitoBeanOverrideHandler createHandler(Annotation overrideAnnotation, Class<?> testClass, Field field) {
        if (overrideAnnotation instanceof MockitoBean) {
            MockitoBean mockBean = (MockitoBean)overrideAnnotation;
            return new MockitoBeanOverrideHandler(field, ResolvableType.forField((Field)field, testClass), mockBean);
        }
        if (overrideAnnotation instanceof MockitoSpyBean) {
            MockitoSpyBean spyBean = (MockitoSpyBean)overrideAnnotation;
            return new MockitoSpyBeanOverrideHandler(field, ResolvableType.forField((Field)field, testClass), spyBean);
        }
        throw new IllegalStateException("Invalid annotation passed to MockitoBeanOverrideProcessor: expected either @MockitoBean or @MockitoSpyBean on field %s.%s".formatted(field.getDeclaringClass().getName(), field.getName()));
    }
}

