/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.karaf.commands;

import java.util.Set;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;
import org.ops4j.pax.web.karaf.commands.WebCommand;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.model.views.ReportWebContainerView;

@Command(scope="web", name="wab-list", description="Lists all available, deployed Web Application Bundles.")
@Service
public class WabListCommand
extends WebCommand {
    @Override
    public void doExecute(WebContainer webContainer) {
        ReportWebContainerView view = (ReportWebContainerView)webContainer.adapt(ReportWebContainerView.class);
        if (view == null) {
            System.err.println("Can't obtain a reference to WebContainer/HttpService.");
            return;
        }
        Set webapps = view.listWebApplications();
        String url = null;
        if (this.runtime != null) {
            String base = ((String[])this.runtime.getRuntimeDTO().serviceDTO.properties.get("osgi.http.endpoint"))[0];
            base = base.substring(0, base.length() - 1);
            url = base = base.replace("0.0.0.0", "127.0.0.1");
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
        }
        ShellTable table = new ShellTable();
        table.column(new Col("Context Path"));
        table.column(new Col("Bundle ID"));
        table.column(new Col("Symbolic Name"));
        table.column(new Col("State"));
        if (url != null) {
            table.column(new Col("Base URL"));
        }
        String finalUrl = url;
        webapps.forEach(app -> {
            if (!app.isWab()) {
                return;
            }
            long bundleId = app.getBundle().getBundleId();
            String symbolicName = app.getBundle().getSymbolicName();
            String contextPath = app.getContextPath();
            String state = app.getDeploymentState();
            Row row = table.addRow();
            row.addContent(new Object[]{contextPath, bundleId, symbolicName, state});
            if (finalUrl != null) {
                row.addContent(new Object[]{finalUrl + contextPath});
            }
        });
        table.print(System.out, true);
    }
}

