/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.karaf.commands;

import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.ShellUtil;
import org.ops4j.pax.web.karaf.commands.WebCommand;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.model.info.WebApplicationInfo;
import org.ops4j.pax.web.service.spi.model.views.ReportWebContainerView;
import org.osgi.framework.Bundle;

@Command(scope="web", name="wab-info", description="Shows information about Web Application Bundle.")
@Service
public class WabInfoCommand
extends WebCommand {
    @Argument(name="wab", description="WAB specified by context path or bundle ID")
    private Object wab;

    @Override
    public void doExecute(WebContainer webContainer) {
        List appBundles;
        List containerBundles;
        List resources;
        List scis;
        WebApplicationInfo app;
        ReportWebContainerView view = (ReportWebContainerView)webContainer.adapt(ReportWebContainerView.class);
        if (view == null) {
            System.err.println("Can't obtain a reference to WebContainer/HttpService.");
            return;
        }
        if (this.wab == null) {
            System.err.println("Please specify the WAB using context path or bundle ID");
            return;
        }
        long bundleId = -1L;
        if (this.wab.toString().startsWith("/")) {
            app = view.getWebApplication(this.wab.toString());
        } else {
            try {
                bundleId = Long.parseLong(this.wab.toString());
                app = view.getWebApplication(bundleId);
            }
            catch (NumberFormatException e) {
                System.err.println("Can't parse \"" + this.wab.toString() + "\" as bundle ID.");
                return;
            }
        }
        if (app == null) {
            if (bundleId >= 0L) {
                System.err.println("Can't find Web Application Bundle with bundle ID = " + bundleId + ".");
            } else {
                System.err.println("Can't find Web Application Bundle with context path = \"" + this.wab + "\".");
            }
            return;
        }
        String title = ShellUtil.getBundleName((Bundle)app.getBundle());
        System.out.println("\n" + title);
        System.out.println(ShellUtil.getUnderlineString((String)title));
        System.out.println("Context Path: " + app.getContextPath());
        System.out.println("Deployment State: " + app.getDeploymentState());
        List wabClassPath = app.getWabClassPath();
        Set wabClassPathSkipped = app.getWabClassPathSkipped();
        if (!wabClassPath.isEmpty()) {
            System.out.println("WAB ClassPath:");
            wabClassPath.forEach(url -> {
                System.out.print(" - " + url);
                if (wabClassPathSkipped != null && wabClassPathSkipped.contains(url)) {
                    System.out.print(" (scanning skipped)");
                }
                System.out.println();
            });
        }
        if (!(scis = app.getServletContainerInitializers()).isEmpty()) {
            System.out.println("ServletContainerInitializers:");
            scis.forEach(sci -> System.out.println(" - " + sci));
        }
        if (!(resources = app.getMetaInfResources()).isEmpty()) {
            System.out.println("Available /META-INF/resources:");
            resources.forEach(r -> System.out.println(" - " + r));
        }
        if (!(containerBundles = app.getContainerFragmentBundles()).isEmpty()) {
            System.out.println("Container web fragments (reachable bundles without /META-INF/web-fragment.xml):");
            containerBundles.forEach(b -> System.out.println(" - (" + b.getBundleId() + ") " + b.getSymbolicName() + "/" + b.getVersion()));
        }
        if (!(appBundles = app.getApplicationFragmentBundles()).isEmpty()) {
            System.out.println("Application web fragments (reachable bundles containing /META-INF/web-fragment.xml):");
            appBundles.forEach(b -> System.out.println(" - (" + b.getBundleId() + ") " + b.getSymbolicName() + "/" + b.getVersion()));
        }
    }
}

