/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.server.CachedContentFactory;
import org.eclipse.jetty.server.ResourceContentFactory;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServlet
extends HttpServlet
implements ResourceFactory,
ResourceService.WelcomeFactory {
    public static final String CONTEXT_INIT = "org.eclipse.jetty.servlet.Default.";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServlet.class);
    private static final long serialVersionUID = 4930458713846881193L;
    protected final ResourceService _resourceService;
    private ServletContext _servletContext;
    private ContextHandler _contextHandler;
    private boolean _welcomeServlets = false;
    private boolean _welcomeExactServlets = false;
    private Resource _resourceBase;
    protected CachedContentFactory _cache;
    private MimeTypes _mimeTypes;
    protected String[] _welcomes;
    private Resource _stylesheet;
    private boolean _useFileMappedBuffer = false;
    private String _relativeResourceBase;
    private ServletHandler _servletHandler;

    public DefaultServlet(ResourceService resourceService) {
        this._resourceService = resourceService;
    }

    public DefaultServlet() {
        this(new ResourceService());
    }

    public void init() throws UnavailableException {
        String cc;
        this._servletContext = this.getServletContext();
        this._contextHandler = this.initContextHandler(this._servletContext);
        this._mimeTypes = this._contextHandler.getMimeTypes();
        this._welcomes = this._contextHandler.getWelcomeFiles();
        if (this._welcomes == null) {
            this._welcomes = new String[]{"index.html", "index.jsp"};
        }
        this._resourceService.setAcceptRanges(this.getInitBoolean("acceptRanges", this._resourceService.isAcceptRanges()));
        this._resourceService.setDirAllowed(this.getInitBoolean("dirAllowed", this._resourceService.isDirAllowed()));
        this._resourceService.setRedirectWelcome(this.getInitBoolean("redirectWelcome", this._resourceService.isRedirectWelcome()));
        this._resourceService.setPrecompressedFormats(this.parsePrecompressedFormats(this.getInitParameter("precompressed"), this.getInitBoolean("gzip"), this._resourceService.getPrecompressedFormats()));
        this._resourceService.setPathInfoOnly(this.getInitBoolean("pathInfoOnly", this._resourceService.isPathInfoOnly()));
        this._resourceService.setEtags(this.getInitBoolean("etags", this._resourceService.isEtags()));
        if ("exact".equals(this.getInitParameter("welcomeServlets"))) {
            this._welcomeExactServlets = true;
            this._welcomeServlets = false;
        } else {
            this._welcomeServlets = this.getInitBoolean("welcomeServlets", this._welcomeServlets);
        }
        this._useFileMappedBuffer = this.getInitBoolean("useFileMappedBuffer", this._useFileMappedBuffer);
        this._relativeResourceBase = this.getInitParameter("relativeResourceBase");
        String rb = this.getInitParameter("resourceBase");
        if (rb != null) {
            if (this._relativeResourceBase != null) {
                throw new UnavailableException("resourceBase & relativeResourceBase");
            }
            try {
                this._resourceBase = this._contextHandler.newResource(rb);
            }
            catch (Exception e) {
                LOG.warn("Unable to create resourceBase from {}", (Object)rb, (Object)e);
                throw new UnavailableException(e.toString());
            }
        }
        String css = this.getInitParameter("stylesheet");
        try {
            if (css != null) {
                this._stylesheet = Resource.newResource((String)css);
                if (!this._stylesheet.exists()) {
                    LOG.warn("!{}", (Object)css);
                    this._stylesheet = null;
                }
            }
            if (this._stylesheet == null) {
                this._stylesheet = ResourceHandler.getDefaultStylesheet();
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to use stylesheet: {}", (Object)css, (Object)e);
            }
            LOG.warn("Unable to use stylesheet: {} - {}", (Object)css, (Object)e.toString());
        }
        int encodingHeaderCacheSize = this.getInitInt("encodingHeaderCacheSize", -1);
        if (encodingHeaderCacheSize >= 0) {
            this._resourceService.setEncodingCacheSize(encodingHeaderCacheSize);
        }
        if ((cc = this.getInitParameter("cacheControl")) != null) {
            this._resourceService.setCacheControl((HttpField)new PreEncodedHttpField(HttpHeader.CACHE_CONTROL, cc));
        }
        String resourceCache = this.getInitParameter("resourceCache");
        int maxCacheSize = this.getInitInt("maxCacheSize", -2);
        int maxCachedFileSize = this.getInitInt("maxCachedFileSize", -2);
        int maxCachedFiles = this.getInitInt("maxCachedFiles", -2);
        if (resourceCache != null) {
            if (maxCacheSize != -1 || maxCachedFileSize != -2 || maxCachedFiles != -2) {
                LOG.debug("ignoring resource cache configuration, using resourceCache attribute");
            }
            if (this._relativeResourceBase != null || this._resourceBase != null) {
                throw new UnavailableException("resourceCache specified with resource bases");
            }
            this._cache = (CachedContentFactory)this._servletContext.getAttribute(resourceCache);
        }
        try {
            if (this._cache == null && (maxCachedFiles != -2 || maxCacheSize != -2 || maxCachedFileSize != -2)) {
                this._cache = new CachedContentFactory(null, (ResourceFactory)this, this._mimeTypes, this._useFileMappedBuffer, this._resourceService.isEtags(), this._resourceService.getPrecompressedFormats());
                if (maxCacheSize >= 0) {
                    this._cache.setMaxCacheSize(maxCacheSize);
                }
                if (maxCachedFileSize >= -1) {
                    this._cache.setMaxCachedFileSize(maxCachedFileSize);
                }
                if (maxCachedFiles >= -1) {
                    this._cache.setMaxCachedFiles(maxCachedFiles);
                }
                this._servletContext.setAttribute(resourceCache == null ? "resourceCache" : resourceCache, (Object)this._cache);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to setup CachedContentFactory", (Throwable)e);
            throw new UnavailableException(e.toString());
        }
        CachedContentFactory contentFactory = this._cache;
        if (contentFactory == null) {
            contentFactory = new ResourceContentFactory((ResourceFactory)this, this._mimeTypes, this._resourceService.getPrecompressedFormats());
            if (resourceCache != null) {
                this._servletContext.setAttribute(resourceCache, (Object)contentFactory);
            }
        }
        this._resourceService.setContentFactory((HttpContent.ContentFactory)contentFactory);
        this._resourceService.setWelcomeFactory((ResourceService.WelcomeFactory)this);
        ArrayList<Object> gzipEquivalentFileExtensions = new ArrayList<Object>();
        String otherGzipExtensions = this.getInitParameter("otherGzipFileExtensions");
        if (otherGzipExtensions != null) {
            StringTokenizer tok = new StringTokenizer(otherGzipExtensions, ",", false);
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken().trim();
                gzipEquivalentFileExtensions.add(s.charAt(0) == '.' ? s : "." + s);
            }
        } else {
            gzipEquivalentFileExtensions.add(".svgz");
        }
        this._resourceService.setGzipEquivalentFileExtensions(gzipEquivalentFileExtensions);
        this._servletHandler = (ServletHandler)this._contextHandler.getChildHandlerByClass(ServletHandler.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("resource base = {}", (Object)this._resourceBase);
        }
    }

    private CompressedContentFormat[] parsePrecompressedFormats(String precompressed, Boolean gzip, CompressedContentFormat[] dft) {
        if (precompressed == null && gzip == null) {
            return dft;
        }
        ArrayList<CompressedContentFormat> ret = new ArrayList<CompressedContentFormat>();
        if (precompressed != null && precompressed.indexOf(61) > 0) {
            for (String pair : precompressed.split(",")) {
                String[] setting = pair.split("=");
                String encoding = setting[0].trim();
                String extension = setting[1].trim();
                ret.add(new CompressedContentFormat(encoding, extension));
                if (gzip != Boolean.TRUE || ret.contains(CompressedContentFormat.GZIP)) continue;
                ret.add(CompressedContentFormat.GZIP);
            }
        } else if (precompressed != null) {
            if (Boolean.parseBoolean(precompressed)) {
                ret.add(CompressedContentFormat.BR);
                ret.add(CompressedContentFormat.GZIP);
            }
        } else if (gzip == Boolean.TRUE) {
            ret.add(CompressedContentFormat.GZIP);
        }
        return ret.toArray(new CompressedContentFormat[ret.size()]);
    }

    protected ContextHandler initContextHandler(ServletContext servletContext) {
        ContextHandler.Context scontext = ContextHandler.getCurrentContext();
        if (scontext == null) {
            if (servletContext instanceof ContextHandler.Context) {
                return ((ContextHandler.Context)servletContext).getContextHandler();
            }
            throw new IllegalArgumentException("The servletContext " + String.valueOf(servletContext) + " " + servletContext.getClass().getName() + " is not " + ContextHandler.Context.class.getName());
        }
        return ContextHandler.getCurrentContext().getContextHandler();
    }

    public String getInitParameter(String name) {
        String value = this.getServletContext().getInitParameter(CONTEXT_INIT + name);
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    private Boolean getInitBoolean(String name) {
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    private boolean getInitBoolean(String name, boolean dft) {
        return Optional.ofNullable(this.getInitBoolean(name)).orElse(dft);
    }

    private int getInitInt(String name, int dft) {
        String value = this.getInitParameter(name);
        if (value == null) {
            value = this.getInitParameter(name);
        }
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return dft;
    }

    public Resource getResource(String pathInContext) {
        Resource r = null;
        if (this._relativeResourceBase != null) {
            pathInContext = URIUtil.addPaths((String)this._relativeResourceBase, (String)pathInContext);
        }
        try {
            if (this._resourceBase != null) {
                r = this._resourceBase.addPath(pathInContext);
                if (!this._contextHandler.checkAlias(pathInContext, r)) {
                    r = null;
                }
            } else if (this._servletContext instanceof ContextHandler.Context) {
                r = this._contextHandler.getResource(pathInContext);
            } else {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource {}={}", (Object)pathInContext, (Object)r);
            }
        }
        catch (IOException e) {
            LOG.trace("IGNORED", (Throwable)e);
        }
        if ((r == null || !r.exists()) && pathInContext.endsWith("/jetty-dir.css")) {
            r = this._stylesheet;
        }
        return r;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this._resourceService.doGet(request, response)) {
            response.sendError(404);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Allow", "GET,HEAD,POST,OPTIONS");
    }

    public void destroy() {
        if (this._cache != null) {
            this._cache.flushCache();
        }
        super.destroy();
    }

    public String getWelcomeFile(String pathInContext) {
        if (this._welcomes == null) {
            return null;
        }
        String welcomeServlet = null;
        for (String s : this._welcomes) {
            MatchedResource entry;
            String welcomeInContext = URIUtil.addPaths((String)pathInContext, (String)s);
            Resource welcome = this.getResource(welcomeInContext);
            if (welcome != null && welcome.exists()) {
                return welcomeInContext;
            }
            if (!this._welcomeServlets && !this._welcomeExactServlets || welcomeServlet != null || (entry = this._servletHandler.getMatchedServlet(welcomeInContext)) == null || ((ServletHandler.MappedServlet)entry.getResource()).getServletHolder().getServletInstance() == this || !this._welcomeServlets && (!this._welcomeExactServlets || !entry.getPathSpec().getDeclaration().equals(welcomeInContext))) continue;
            welcomeServlet = welcomeInContext;
        }
        return welcomeServlet;
    }
}

