/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.resource.PathResource;
import org.ops4j.pax.web.service.jetty.internal.JettyFactory;
import org.ops4j.pax.web.service.jetty.internal.JettyServerWrapper;
import org.ops4j.pax.web.service.jetty.internal.PriorityValue;
import org.ops4j.pax.web.service.jetty.internal.web.JettyResourceServlet;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerState;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.model.events.ServerEvent;
import org.ops4j.pax.web.service.spi.model.events.ServerListener;
import org.ops4j.pax.web.service.spi.task.Batch;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyServerController
implements ServerController {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServerController.class);
    private final Bundle paxWebJettyBundle;
    private final ClassLoader classLoader;
    private final Configuration configuration;
    private ServerState state;
    private final Set<ServerListener> listeners;
    private final JettyFactory jettyFactory;
    private JettyServerWrapper jettyServerWrapper;

    JettyServerController(Bundle paxWebJettyBundle, ClassLoader classLoader, JettyFactory jettyFactory, Configuration configuration) {
        this.paxWebJettyBundle = paxWebJettyBundle;
        this.classLoader = classLoader;
        this.jettyFactory = jettyFactory;
        this.configuration = configuration;
        this.state = ServerState.UNCONFIGURED;
        this.listeners = Collections.synchronizedSet(new LinkedHashSet());
        this.jettyServerWrapper = new JettyServerWrapper(configuration, jettyFactory, paxWebJettyBundle, classLoader);
    }

    public ServerState getState() {
        return this.state;
    }

    public void configure() throws Exception {
        LOG.info("Configuring {}", (Object)this);
        if (this.state != ServerState.UNCONFIGURED) {
            throw new IllegalStateException("Can't configure Jetty server controller in state " + String.valueOf(this.state));
        }
        this.jettyServerWrapper.configure();
        this.state = ServerState.STOPPED;
        this.notifyListeners(new ServerEvent(ServerEvent.State.CONFIGURED, this.jettyServerWrapper.getAddresses(false)));
    }

    public void start() throws Exception {
        LOG.info("Starting {}", (Object)this);
        if (this.state != ServerState.STOPPED) {
            throw new IllegalStateException("Can't start Jetty server controller in state " + String.valueOf(this.state));
        }
        this.jettyServerWrapper.start();
        this.state = ServerState.STARTED;
        this.notifyListeners(new ServerEvent(ServerEvent.State.STARTED, this.jettyServerWrapper.getAddresses(true)));
    }

    public void stop() throws Exception {
        LOG.info("Stopping {}", (Object)this);
        if (this.state != ServerState.STARTED) {
            throw new IllegalStateException("Can't stop Jetty server controller in state " + String.valueOf(this.state));
        }
        this.jettyServerWrapper.stop();
        this.state = ServerState.STOPPED;
        this.notifyListeners(new ServerEvent(ServerEvent.State.STOPPED, null));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void addListener(ServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("ServerListener is null");
        }
        if (this.state == ServerState.STOPPED) {
            listener.stateChanged(new ServerEvent(ServerEvent.State.CONFIGURED, this.jettyServerWrapper.getAddresses(false)));
        } else if (this.state == ServerState.STARTED) {
            listener.stateChanged(new ServerEvent(ServerEvent.State.STARTED, this.jettyServerWrapper.getAddresses(true)));
        }
        this.listeners.add(listener);
    }

    public void removeListener(ServerListener listener) {
        this.listeners.remove(listener);
    }

    void notifyListeners(ServerEvent event) {
        for (ServerListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    public void sendBatch(Batch batch) {
        LOG.info("Receiving {}", (Object)batch);
        if (this.state == ServerState.UNCONFIGURED) {
            throw new IllegalStateException("Can't process batch in Jetty server controller in state " + String.valueOf(this.state));
        }
        batch.accept((BatchVisitor)this.jettyServerWrapper);
    }

    public Servlet createResourceServlet(URL urlBase, String base) {
        PathResource baseUrlResource;
        try {
            baseUrlResource = urlBase == null ? null : new PathResource(urlBase);
        }
        catch (IOException | URISyntaxException notPossbleButStill) {
            throw new IllegalArgumentException(notPossbleButStill.getMessage(), notPossbleButStill);
        }
        String chroot = baseUrlResource == null ? base : null;
        return new JettyResourceServlet(baseUrlResource, chroot);
    }

    public String toString() {
        return "JettyServerController{configuration=" + this.configuration.id() + ",state=" + String.valueOf(this.state) + "}";
    }

    public void setHandlers(Set<PriorityValue<Handler>> handlers) {
        this.jettyServerWrapper.setHandlers(handlers);
    }

    public void setCustomizers(Set<PriorityValue<HttpConfiguration.Customizer>> customizers) {
        this.jettyServerWrapper.setCustomizers(customizers);
    }

    public void removeCustomizer(HttpConfiguration.Customizer customizer) {
        this.jettyServerWrapper.removeCustomizer(customizer);
    }
}

