/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import org.eclipse.jetty.ee10.servlet.ResourceServlet;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.http.content.ValidatingCachingHttpContentFactory;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.ops4j.pax.web.service.jetty.internal.web.PaxWebResource;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyResourceServlet
extends ResourceServlet {
    public static final Logger LOG = LoggerFactory.getLogger(JettyResourceServlet.class);
    public static final ThreadLocal<Resource> BASE_RESOURCE = new ThreadLocal();
    private final PathResource baseUrlResource;
    private final String chroot;
    private PaxWebResource baseResource;

    public JettyResourceServlet(PathResource baseUrlResource, String chroot) {
        this.baseUrlResource = baseUrlResource;
        this.chroot = chroot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        this.baseResource = new PaxWebResource(this.getServletContext(), this.baseUrlResource, this.chroot);
        try {
            BASE_RESOURCE.set(this.baseResource);
            super.init();
            String maxCacheSize = this.getInitParameter("maxCacheSize");
            String maxCachedFileSize = this.getInitParameter("maxCachedFileSize");
            String maxCachedFiles = this.getInitParameter("maxCachedFiles");
            if (maxCacheSize == null) {
                maxCacheSize = Integer.toString(0x400000);
            }
            if (maxCachedFileSize == null) {
                maxCachedFileSize = Integer.toString(0x200000);
            }
            if (maxCachedFiles == null) {
                maxCachedFiles = "2048";
            }
            LOG.info("Initialized Jetty Resource Servlet for base=\"{}\" with cache maxSize={}kB, maxEntrySize={}kB, maxEntries={}", new Object[]{this.baseUrlResource != null ? this.baseUrlResource.getPath() : this.chroot, Integer.parseInt(maxCacheSize) / 1024, Integer.parseInt(maxCachedFileSize) / 1024, maxCachedFiles});
        }
        finally {
            BASE_RESOURCE.remove();
        }
    }

    public void setWelcomeFiles(String[] welcomeFiles) {
        HttpContent.Factory factory;
        if (this.getResourceService() != null && (factory = this.getResourceService().getHttpContentFactory()) instanceof ValidatingCachingHttpContentFactory) {
            ValidatingCachingHttpContentFactory cache = (ValidatingCachingHttpContentFactory)factory;
            cache.flushCache();
        }
    }

    public void setWelcomeFilesRedirect(boolean welcomeFilesRedirect) {
        if (this.getResourceService() != null) {
            this.getResourceService().setWelcomeMode(welcomeFilesRedirect ? ResourceService.WelcomeMode.REDIRECT : ResourceService.WelcomeMode.SERVE);
        }
    }

    protected ServletContextHandler initContextHandler(ServletContext servletContext) {
        if (servletContext instanceof OsgiServletContext) {
            OsgiServletContext osgiServletContext = (OsgiServletContext)servletContext;
            return super.initContextHandler(osgiServletContext.getContainerServletContext());
        }
        if (servletContext instanceof OsgiScopedServletContext) {
            OsgiScopedServletContext osgiScopedServletContext = (OsgiScopedServletContext)servletContext;
            return super.initContextHandler(osgiScopedServletContext.getContainerServletContext());
        }
        return super.initContextHandler(servletContext);
    }
}

