/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.util.Map;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.session.ManagedSession;

public class PaxWebSessionHandler
extends SessionHandler {
    public HttpCookie getSessionCookie(ManagedSession session, boolean requestIsSecure) {
        HttpCookie cookie = super.getSessionCookie(session, requestIsSecure);
        if (cookie != null) {
            String id = this.getExtendedId(cookie.getValue());
            return HttpCookie.from((String)cookie.getName(), (String)id, (Map)this.getSessionCookieAttributes());
        }
        return cookie;
    }

    public void renewSessionId(String oldId, String oldExtendedId, String newId, String newExtendedId) {
        int id1 = oldId.indexOf("~");
        int id2 = oldExtendedId.indexOf("~");
        int id3 = newId.indexOf("~");
        int id4 = newExtendedId.indexOf("~");
        if (id1 > 0 && id2 > 0 && id3 == -1 && id4 == -1) {
            String s1 = oldId.substring(id1);
            String s2 = oldExtendedId.substring(id2);
            super.renewSessionId(oldId, oldExtendedId, newId + s1, newExtendedId + s2);
        } else {
            super.renewSessionId(oldId, oldExtendedId, newId, newExtendedId);
        }
    }

    public String getExtendedId(String eid) {
        int tilde = eid.indexOf("~");
        if (tilde == -1) {
            return eid;
        }
        int dot = eid.lastIndexOf(".");
        if (dot == -1) {
            return eid.substring(0, tilde);
        }
        return eid.substring(0, tilde) + eid.substring(dot);
    }
}

