/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.security.auth.Subject;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.FilterMapping;
import org.eclipse.jetty.ee10.servlet.ListenerHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.ServletMapping;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.UserPrincipal;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.Callback;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.jetty.internal.PaxWebFilterHolder;
import org.ops4j.pax.web.service.jetty.internal.PaxWebFilterMapping;
import org.ops4j.pax.web.service.jetty.internal.PaxWebServletHolder;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiFilterChain;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiSessionAttributeListener;
import org.ops4j.pax.web.service.spi.servlet.PreprocessorFilterConfig;
import org.osgi.service.servlet.whiteboard.Preprocessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxWebServletHandler
extends ServletHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PaxWebServletHandler.class);
    private final List<PreprocessorFilterConfig> preprocessors = new LinkedList<PreprocessorFilterConfig>();
    private OsgiServletContext defaultServletContext;
    private OsgiContextModel defaultOsgiContextModel;
    private WebContainerContext defaultWebContainerContext;
    private final OsgiSessionAttributeListener osgiSessionsBridge;
    private final Servlet default404Servlet;
    private final ThreadLocal<PaxWebServletHolder> currentServletHolder = new ThreadLocal();

    PaxWebServletHandler(Servlet default404Servlet, OsgiSessionAttributeListener osgiSessionsBridge) {
        this.setEnsureDefaultServlet(true);
        this.setFilterChainsCached(true);
        int cacheSize = this.getMaxFilterChainsCacheSize();
        this.setMaxFilterChainsCacheSize(2 * cacheSize);
        this.setFilters(new PaxWebFilterHolder[0]);
        this.default404Servlet = default404Servlet;
        this.osgiSessionsBridge = osgiSessionsBridge;
    }

    public void setDefaultServletContext(OsgiServletContext defaultServletContext) {
        this.defaultServletContext = defaultServletContext;
    }

    public OsgiServletContext getDefaultServletContext() {
        return this.defaultServletContext;
    }

    public void setDefaultOsgiContextModel(OsgiContextModel defaultOsgiContextModel, WebContainerContext resolvedWebContainerContext) {
        this.defaultOsgiContextModel = defaultOsgiContextModel;
        this.defaultWebContainerContext = resolvedWebContainerContext;
    }

    public OsgiContextModel getDefaultOsgiContextModel() {
        return this.defaultOsgiContextModel;
    }

    protected synchronized void doStart() throws Exception {
        if (this.getServletMapping("/") == null && this.isEnsureDefaultServlet()) {
            this.addServletWithMapping(new PaxWebServletHolder("default", this.default404Servlet, true), "/");
            this.getServletMapping("/").setFromDefaultDescriptor(true);
        }
        super.doStart();
    }

    public void initialize() throws Exception {
        for (PreprocessorFilterConfig fc : this.preprocessors) {
            fc.getInstance().init((FilterConfig)fc);
        }
        try {
            super.initialize();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    protected synchronized void doStop() throws Exception {
        ArrayList<PaxWebFilterHolder> newFilters = new ArrayList<PaxWebFilterHolder>();
        ArrayList<PaxWebFilterMapping> newFilterMappings = new ArrayList<PaxWebFilterMapping>();
        for (FilterHolder fh : this.getFilters()) {
            if (!(fh instanceof PaxWebFilterHolder)) continue;
            PaxWebFilterHolder pwfh = (PaxWebFilterHolder)fh;
            if (pwfh.getFilterModel() == null || pwfh.getFilterModel().isDynamic()) {
                try {
                    pwfh.destroyInstance(pwfh.getInstance());
                }
                catch (Exception e) {
                    LOG.warn("Problem destroying filter {}: {}", new Object[]{pwfh, e.getMessage(), e});
                }
                continue;
            }
            newFilters.add(pwfh);
            newFilterMappings.addAll(pwfh.getMapping());
        }
        this.setFilters(newFilters.toArray(new PaxWebFilterHolder[0]));
        this.setFilterMappings(newFilterMappings.toArray(new PaxWebFilterMapping[0]));
        for (PreprocessorFilterConfig fc : this.preprocessors) {
            fc.destroy();
        }
        ServletHolder[] servlets = this.getServlets();
        ServletMapping[] servletMappings = this.getServletMappings();
        FilterHolder[] filters = this.getFilters();
        FilterMapping[] filterMappings = this.getFilterMappings();
        ListenerHolder[] listeners = this.getListeners();
        super.doStop();
        super.setServlets(servlets);
        this.setServletMappings(servletMappings);
        this.setFilters(filters);
        this.setFilterMappings(filterMappings);
        this.setListeners(listeners);
    }

    public synchronized void setServlets(ServletHolder[] holders) {
        for (ServletHolder holder : holders) {
            if (holder instanceof PaxWebServletHolder) continue;
            throw new IllegalArgumentException("This ServletHandler should manage only PaxWebServletHolders");
        }
        super.setServlets(holders);
    }

    public void addServletWithMapping(PaxWebServletHolder holder, ServletMapping mapping) {
        holder.setMapping(mapping);
        this.addServlet(holder);
        this.addServletMapping(mapping);
    }

    public void addFilterWithMapping(FilterHolder holder, String pathSpec, EnumSet<DispatcherType> dispatches) {
        if (holder instanceof PaxWebFilterHolder) {
            super.addFilterWithMapping(holder, pathSpec, dispatches);
            return;
        }
        PaxWebFilterHolder paxWebFilterHolder = new PaxWebFilterHolder(holder, this.defaultServletContext);
        super.addFilterWithMapping((FilterHolder)paxWebFilterHolder, pathSpec, dispatches);
    }

    public void prependFilter(FilterHolder filter) {
        if (filter instanceof PaxWebFilterHolder) {
            super.prependFilter(filter);
            return;
        }
        PaxWebFilterHolder paxWebFilterHolder = new PaxWebFilterHolder(filter, this.defaultServletContext);
        super.prependFilter((FilterHolder)paxWebFilterHolder);
    }

    public void removeServletWithMapping(ServletModel model) {
        Object[] holders = this.getServlets();
        Object[] mappings = this.getServletMappings();
        if (holders != null && mappings != null) {
            PaxWebServletHolder holder = (PaxWebServletHolder)this.getServlet(model.getName());
            if (holder == null) {
                throw new IllegalArgumentException("Can't unregister servlet named \"" + model.getName() + "\" from Jetty servlet handler of " + this.defaultOsgiContextModel.getContextPath() + " context");
            }
            ServletMapping mapping = holder.getMapping();
            this.setServlets((ServletHolder[])ArrayUtil.removeFromArray((Object[])holders, (Object)((Object)holder)));
            this.setServletMappings((ServletMapping[])ArrayUtil.removeFromArray((Object[])mappings, (Object)mapping));
            LOG.debug("Stopping servlet holder {}", (Object)holder);
            try {
                holder.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (this.getServletMapping("/") == null && this.isEnsureDefaultServlet()) {
            this.addServletWithMapping(new PaxWebServletHolder("default", this.default404Servlet, true), "/");
            this.getServletMapping("/").setFromDefaultDescriptor(true);
        }
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        return super.handle(request, response, callback);
    }

    protected FilterChain getOsgiFilterChain(ServletContextRequest baseRequest, String pathInContext, ServletHolder servletHolder) {
        PaxWebServletHolder holder = (PaxWebServletHolder)servletHolder;
        FilterChain chain = this.getFilterChain((HttpServletRequest)baseRequest.getServletApiRequest(), pathInContext, servletHolder);
        if (chain == null) {
            chain = (arg_0, arg_1) -> ((PaxWebServletHolder)holder).handle(arg_0, arg_1);
        }
        AuthBridgeConsumer authListener = new AuthBridgeConsumer(baseRequest);
        List<Preprocessor> preprocessorInstances = this.preprocessors.stream().map(PreprocessorFilterConfig::getInstance).toList();
        if (!holder.is404()) {
            return new OsgiFilterChain(new ArrayList<Preprocessor>(preprocessorInstances), holder.getOsgiServletContext(), holder.getWebContainerContext(), chain, this.osgiSessionsBridge, (Consumer)authListener);
        }
        return new OsgiFilterChain(new ArrayList<Preprocessor>(preprocessorInstances), (ServletContext)this.defaultServletContext, this.defaultWebContainerContext, chain, this.osgiSessionsBridge, (Consumer)authListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FilterChain getFilterChain(HttpServletRequest baseRequest, String pathInContext, ServletHolder servletHolder) {
        Object prefix;
        PaxWebServletHolder holder = (PaxWebServletHolder)servletHolder;
        WebContainerContext wcc = holder.getWebContainerContext();
        Object object = prefix = wcc == null ? "" : wcc.getContextId() + "|";
        if (wcc != null && wcc.isShared()) {
            prefix = "~|" + (String)prefix;
        }
        String contextlessKey = pathInContext == null ? holder.getName() : pathInContext;
        String key = (String)prefix + contextlessKey;
        int dispatch = FilterMapping.dispatch((DispatcherType)baseRequest.getDispatcherType());
        AuthBridgeConsumer authListener = new AuthBridgeConsumer(ServletContextRequest.getServletContextRequest((ServletRequest)baseRequest));
        FilterChain chain = (FilterChain)this._chainCache[dispatch].get(key);
        if (chain != null) {
            List<Preprocessor> preprocessorInstances = this.preprocessors.stream().map(PreprocessorFilterConfig::getInstance).toList();
            if (!holder.is404()) {
                return new OsgiFilterChain(new ArrayList<Preprocessor>(preprocessorInstances), holder.getOsgiServletContext(), holder.getWebContainerContext(), chain, this.osgiSessionsBridge, (Consumer)authListener);
            }
            return new OsgiFilterChain(new ArrayList<Preprocessor>(preprocessorInstances), (ServletContext)this.defaultServletContext, this.defaultWebContainerContext, chain, this.osgiSessionsBridge, (Consumer)authListener);
        }
        this._chainCache[dispatch].remove(contextlessKey);
        this.currentServletHolder.set(holder);
        try {
            chain = super.getFilterChain(baseRequest, pathInContext, servletHolder);
        }
        finally {
            this.currentServletHolder.remove();
        }
        if (chain != null) {
            this._chainCache[dispatch].put(key, chain);
        }
        if (chain == null) {
            chain = (arg_0, arg_1) -> ((PaxWebServletHolder)holder).handle(arg_0, arg_1);
        }
        List<Preprocessor> preprocessorInstances = this.preprocessors.stream().map(PreprocessorFilterConfig::getInstance).toList();
        if (!holder.is404()) {
            return new OsgiFilterChain(new ArrayList<Preprocessor>(preprocessorInstances), holder.getOsgiServletContext(), holder.getWebContainerContext(), chain, this.osgiSessionsBridge, (Consumer)authListener);
        }
        return new OsgiFilterChain(new ArrayList<Preprocessor>(preprocessorInstances), (ServletContext)this.defaultServletContext, this.defaultWebContainerContext, chain, this.osgiSessionsBridge, (Consumer)authListener);
    }

    protected FilterChain newFilterChain(FilterHolder filterHolder, FilterChain chain) {
        PaxWebFilterHolder fHolder;
        PaxWebServletHolder holder = this.currentServletHolder.get();
        OsgiContextModel targetContext = holder.getOsgiContextModel();
        if (targetContext == null) {
            targetContext = this.defaultOsgiContextModel;
        }
        if ((fHolder = (PaxWebFilterHolder)filterHolder).matches(targetContext)) {
            return super.newFilterChain(filterHolder, chain);
        }
        return chain;
    }

    public List<PreprocessorFilterConfig> getPreprocessors() {
        return this.preprocessors;
    }

    private static class AuthBridgeConsumer
    implements Consumer<HttpServletRequest> {
        private final ServletContextRequest baseRequest;

        AuthBridgeConsumer(ServletContextRequest baseRequest) {
            this.baseRequest = baseRequest;
        }

        @Override
        public void accept(HttpServletRequest req) {
            Object user = req.getAttribute("org.osgi.service.http.authentication.remote.user");
            Object authType = req.getAttribute("org.osgi.service.http.authentication.type");
            if ((user != null || authType != null) && this.baseRequest.getServletApiRequest().getAuthentication() == null) {
                String userName = user != null ? user.toString() : null;
                String authMethod = authType != null ? authType.toString() : null;
                UserPrincipal p = new UserPrincipal(userName, null);
                Subject s = new Subject(true, Collections.singleton(p), Collections.emptySet(), Collections.emptySet());
                Request.setAuthenticationState((Request)this.baseRequest, (Request.AuthenticationState)this.baseRequest.getServletApiRequest().getAuthentication());
                LoginAuthenticator.UserAuthenticationSucceeded auth = new LoginAuthenticator.UserAuthenticationSucceeded(authMethod, (UserIdentity)new DefaultUserIdentity(s, (Principal)p));
                Request.setAuthenticationState((Request)this.baseRequest, (Request.AuthenticationState)auth);
            }
        }
    }

    private static class DefaultUserIdentity
    implements UserIdentity {
        private final Subject subject;
        private final Principal principal;

        private DefaultUserIdentity(Subject subject, Principal principal) {
            this.subject = subject;
            this.principal = principal;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            return false;
        }
    }
}

