/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePropertiesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServicePropertiesUtils.class);

    private ServicePropertiesUtils() {
    }

    public static Boolean getBooleanProperty(ServiceReference<?> serviceReference, String key) {
        String stringProperty = Utils.getStringProperty(serviceReference, (String)key);
        return Boolean.parseBoolean(stringProperty);
    }

    public static Integer getIntegerProperty(ServiceReference<?> serviceReference, String key) {
        if (serviceReference == null) {
            throw new IllegalArgumentException("Service reference is null.");
        }
        if (key == null || "".equals(key.trim())) {
            throw new IllegalArgumentException("Property key is empty.");
        }
        Object value = serviceReference.getProperty(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value != null) {
            try {
                return Integer.parseInt(String.valueOf(value));
            }
            catch (NumberFormatException e) {
                String message = String.format("Property [%s] value must be an Integer: %s", key, e.getMessage());
                LOG.error(message, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static Map<String, Object> getSubsetStartingWith(ServiceReference<?> serviceReference, String prefix) {
        HashMap<String, Object> subset = new HashMap<String, Object>();
        for (String key : serviceReference.getPropertyKeys()) {
            if (key == null || !key.startsWith(prefix) || key.trim().length() <= prefix.length()) continue;
            subset.put(key.substring(prefix.length()), serviceReference.getProperty(key));
        }
        if (subset.isEmpty()) {
            return null;
        }
        return subset;
    }

    public static Object mergePropertyListOfStringsToArrayOfStrings(Object objectToMerge, List<String> listOfStrings) {
        HashSet<String> setToMerge = new HashSet<String>(listOfStrings);
        if (objectToMerge instanceof String && ((String)objectToMerge).trim().length() != 0) {
            setToMerge.add((String)objectToMerge);
        } else if (objectToMerge instanceof String[]) {
            setToMerge.addAll(Arrays.asList((String[])objectToMerge));
        }
        return setToMerge.toArray(new String[setToMerge.size()]);
    }
}

