/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker.legacy;

import java.util.Arrays;
import org.ops4j.pax.web.extender.whiteboard.internal.WhiteboardExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractContextTracker;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.http.HttpContext;
import org.ops4j.pax.web.service.spi.context.DefaultHttpContext;
import org.ops4j.pax.web.service.spi.context.DefaultMultiBundleWebContainerContext;
import org.ops4j.pax.web.service.spi.context.WebContainerContextWrapper;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.service.whiteboard.ContextMapping;
import org.ops4j.pax.web.service.whiteboard.HttpContextMapping;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class HttpContextMappingTracker
extends AbstractContextTracker<HttpContextMapping> {
    private HttpContextMappingTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        super(whiteboardExtenderContext, bundleContext);
    }

    public static ServiceTracker<HttpContextMapping, OsgiContextModel> createTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        return new HttpContextMappingTracker(whiteboardExtenderContext, bundleContext).create(HttpContextMapping.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureContextModel(ServiceReference<HttpContextMapping> serviceReference, OsgiContextModel model) {
        HttpContextMapping service = null;
        try {
            HttpContext httpContext;
            String scope;
            LOG.debug("Dereferencing service {} to obtain HttpContextMapping instance", serviceReference);
            service = (HttpContextMapping)model.getOwnerBundle().getBundleContext().getService(serviceReference);
            model.setShared(Boolean.valueOf(service.isShared()));
            String name = this.setupName(model, (ContextMapping)service);
            String contextPath = this.setupContextPath(model, (ContextMapping)service);
            model.getContextParams().clear();
            if (service.getInitParameters() != null) {
                model.getContextParams().putAll(service.getInitParameters());
            }
            this.setupArtificialServiceRegistrationProperties(model, (ContextMapping)service, false);
            model.getContextRegistrationProperties().put("osgi.http.whiteboard.context.httpservice", name);
            model.getContextRegistrationProperties().put("osgi.http.whiteboard.context.path", contextPath);
            model.getVirtualHosts().clear();
            model.getConnectors().clear();
            if (service.getVirtualHosts() != null) {
                model.getVirtualHosts().addAll(Arrays.asList(service.getVirtualHosts()));
            }
            if (service.getConnectors() != null) {
                model.getConnectors().addAll(Arrays.asList(service.getConnectors()));
            }
            if (!"singleton".equals(scope = Utils.getStringProperty(serviceReference, (String)"service.scope"))) {
                LOG.warn("HttpContextMapping service was not registered as \"singleton\". However it's only used to obtain a HttpContext instance. Consider registering non-singleton HttpContext service instead");
            }
            if ((httpContext = service.getHttpContext(serviceReference.getBundle())) == null) {
                DefaultHttpContext ctx = new DefaultHttpContext(model.getOwnerBundle(), name);
                Object object = httpContext = !service.isShared() ? ctx : new DefaultMultiBundleWebContainerContext(ctx);
            }
            if (httpContext instanceof WebContainerContext) {
                model.setHttpContext((WebContainerContext)httpContext);
                boolean actuallyShared = ((WebContainerContext)httpContext).isShared();
                if (model.isShared() && !actuallyShared) {
                    LOG.warn("contextMapping is registered as shared, but actual HttpContext is not shared. Switching to non-shared.");
                } else if (!model.isShared() && actuallyShared) {
                    LOG.warn("contextMapping is registered as non-shared, but actual HttpContext is marked as shared. Switching to shared.");
                }
                model.setShared(Boolean.valueOf(actuallyShared));
            } else {
                if (model.isShared()) {
                    LOG.warn("contextMapping is registered as shared, but actual HttpContext is not an instance of WebContainerContext with \"shared\" property");
                }
                model.setHttpContext((WebContainerContext)new WebContainerContextWrapper(serviceReference.getBundle(), httpContext, name));
                model.setShared(Boolean.valueOf(false));
            }
            model.getContextRegistrationProperties().remove("osgi.http.whiteboard.context.name");
        }
        finally {
            if (service != null) {
                this.bundleContext.ungetService(serviceReference);
            }
        }
    }
}

