/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.List;
import org.ops4j.pax.web.extender.whiteboard.internal.WhiteboardExtenderContext;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.events.WebElementEventData;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.service.whiteboard.ContextRelated;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractElementTracker<S, R, D extends WebElementEventData, T extends ElementModel<R, D>>
implements ServiceTrackerCustomizer<S, T> {
    public static final String DEFAULT_CONTEXT_SELECTOR = String.format("(%s=%s)", "osgi.http.whiteboard.context.name", "default");
    public static Filter defaultContextSelectorFilter = null;
    private static final String LEGACY_MAPPING_PACKAGE = ContextRelated.class.getPackage().getName();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final BundleContext bundleContext;
    protected boolean whiteboardSynchronous = false;
    private final WhiteboardExtenderContext whiteboardExtenderContext;

    protected AbstractElementTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        this.whiteboardExtenderContext = whiteboardExtenderContext;
        this.bundleContext = bundleContext;
        String flag = bundleContext.getProperty("org.ops4j.pax.web.extender.whiteboard.synchronous");
        this.whiteboardSynchronous = Boolean.parseBoolean(flag);
        try {
            defaultContextSelectorFilter = bundleContext.createFilter(DEFAULT_CONTEXT_SELECTOR);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SafeVarargs
    protected final ServiceTracker<S, T> create(Class<? extends S> ... trackedClass) {
        return new ServiceTracker(this.bundleContext, Utils.createFilter((BundleContext)this.bundleContext, (Class[])trackedClass), (ServiceTrackerCustomizer)this);
    }

    protected final ServiceTracker<S, T> create(String filter) {
        try {
            return new ServiceTracker(this.bundleContext, this.bundleContext.createFilter(filter), (ServiceTrackerCustomizer)this);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Problem creating service tracker. Bad filter definition: " + e.getMessage());
        }
    }

    protected abstract T createElementModel(ServiceReference<S> var1, Integer var2, Long var3);

    public T addingService(ServiceReference<S> serviceReference) {
        T webElement;
        Long serviceId;
        this.log.debug("Processing new Whiteboard service reference: {}", serviceReference);
        Integer rank = 0;
        Object rankObject = serviceReference.getProperty("service.ranking");
        if (rankObject instanceof Integer) {
            rank = (Integer)rankObject;
        }
        if ((serviceId = (Long)serviceReference.getProperty("service.id")) == null) {
            serviceId = 0L;
        }
        if ((webElement = this.createElementModel(serviceReference, rank, serviceId)) != null) {
            webElement.setAsynchronusRegistration(!this.whiteboardSynchronous);
        }
        return this.addingService(serviceReference, webElement);
    }

    private T addingService(ServiceReference<S> serviceReference, T webElement) {
        Filter contextFilter;
        String selector;
        String[] objectClasses;
        Object selectorProperty;
        String legacyId;
        if (webElement == null) {
            this.log.debug("No element model was created from reference {}", serviceReference);
            return null;
        }
        Object legacyIdProperty = serviceReference.getProperty("httpContext.id");
        String string = legacyId = legacyIdProperty instanceof String ? (String)legacyIdProperty : null;
        if (legacyId != null) {
            this.log.warn("Legacy {} property used, please select context(s) using {} property.", (Object)"httpContext.id", (Object)"osgi.http.whiteboard.context.select");
        }
        if ((selectorProperty = serviceReference.getProperty("osgi.http.whiteboard.context.select")) != null && !(selectorProperty instanceof String)) {
            this.log.warn("{} context selection property is not of type String. Ignoring {}.", (Object)"osgi.http.whiteboard.context.select", serviceReference);
            return null;
        }
        boolean legacyMapping = false;
        for (String oc : objectClasses = Utils.getObjectClasses(serviceReference)) {
            String oc2;
            if (!oc.startsWith(LEGACY_MAPPING_PACKAGE) || !(oc2 = oc.substring(LEGACY_MAPPING_PACKAGE.length())).startsWith(".") || oc2.indexOf(46, 1) != -1) continue;
            legacyMapping = true;
            break;
        }
        if ((selector = webElement.getContextSelector()) == null) {
            selector = this.determineSelector(legacyMapping, legacyId, (String)selectorProperty, serviceReference);
        }
        try {
            contextFilter = selector == DEFAULT_CONTEXT_SELECTOR ? defaultContextSelectorFilter : this.bundleContext.createFilter(selector);
        }
        catch (InvalidSyntaxException e) {
            this.log.error("Can't register web element from reference {}, skipping registration. Bad context selector: {}", new Object[]{serviceReference, selector, e});
            return null;
        }
        webElement.setContextSelectFilter(contextFilter);
        List<OsgiContextModel> contexts = this.whiteboardExtenderContext.resolveContexts(serviceReference.getBundle(), contextFilter);
        for (OsgiContextModel contextModel : contexts) {
            webElement.addContextModel(contextModel);
        }
        if (webElement.isValid()) {
            this.whiteboardExtenderContext.addWebElement(serviceReference.getBundle(), webElement);
            return webElement;
        }
        if (webElement instanceof FilterModel && ((FilterModel)webElement).isIgnored()) {
            return null;
        }
        if (webElement instanceof ServletModel && ((ServletModel)webElement).isIgnored()) {
            return null;
        }
        this.whiteboardExtenderContext.configureFailedDTOs((ElementModel<?, ?>)webElement);
        return webElement;
    }

    public void modifiedService(ServiceReference<S> reference, T service) {
        this.log.debug("Processing Whiteboard service reference change: {}", reference);
        this.removedService(reference, service);
        int rank = 0;
        Object rankObject = reference.getProperty("service.ranking");
        if (rankObject instanceof Integer) {
            rank = (Integer)rankObject;
        }
        service.setServiceRank(rank);
        service.resetContextModels();
        Long serviceId = (Long)reference.getProperty("service.id");
        if (serviceId == null) {
            serviceId = 0L;
        }
        T webElement = this.createElementModel(reference, rank, serviceId);
        service.alterWithNewModel(webElement);
        this.addingService(reference, service);
    }

    public void removedService(ServiceReference<S> serviceReference, T webElement) {
        this.log.debug("Whiteboard service removed: {}", serviceReference);
        this.whiteboardExtenderContext.removeWebElement(serviceReference.getBundle(), webElement);
    }

    protected String determineSelector(boolean legacyMapping, String legacyId, String selector, ServiceReference<S> serviceReference) {
        if (selector != null && legacyId != null) {
            this.log.warn("Both legacy {} and R7 {} properties are specified. Using R7 property: {}.", new Object[]{"httpContext.id", "osgi.http.whiteboard.context.select", selector});
            legacyId = null;
        }
        if (!legacyMapping && selector == null && legacyId != null) {
            selector = String.format("(%s=%s)", "osgi.http.whiteboard.context.httpservice", legacyId);
        }
        if (!legacyMapping && selector == null) {
            selector = DEFAULT_CONTEXT_SELECTOR;
        }
        return selector;
    }
}

