/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.util.ArrayList;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.karaf.container.internal.KarafTestContainer;
import org.ops4j.pax.exam.karaf.container.internal.runner.KarafJavaRunner;
import org.ops4j.pax.exam.karaf.container.internal.runner.NixRunner;
import org.ops4j.pax.exam.karaf.container.internal.runner.WindowsRunner;
import org.ops4j.pax.exam.karaf.options.KarafDistributionBaseConfigurationOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionKitConfigurationOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafTestContainerFactory
implements TestContainerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(KarafTestContainer.class);
    private static final boolean IS_WINDOWS_OS = System.getProperty("os.name").toLowerCase().contains("windows");

    public TestContainer[] create(ExamSystem system) {
        KarafDistributionBaseConfigurationOption[] options;
        KarafDistributionKitConfigurationOption[] kitOptions;
        ArrayList<KarafTestContainer> containers = new ArrayList<KarafTestContainer>();
        for (KarafDistributionKitConfigurationOption kitOption : kitOptions = (KarafDistributionKitConfigurationOption[])system.getOptions(KarafDistributionKitConfigurationOption.class)) {
            if (kitOption.getPlatform().equals((Object)KarafDistributionKitConfigurationOption.Platform.WINDOWS)) {
                if (IS_WINDOWS_OS) {
                    containers.add(new KarafTestContainer(system, kitOption, new WindowsRunner(kitOption.getMakeExec(), kitOption.getExec())));
                    continue;
                }
                LOGGER.info("Ignore windows settings on non windows platforms");
                continue;
            }
            if (!IS_WINDOWS_OS) {
                containers.add(new KarafTestContainer(system, kitOption, new NixRunner(kitOption.getMakeExec(), kitOption.getExec())));
                continue;
            }
            LOGGER.info("Ignore non windows settings on windows platforms");
        }
        for (KarafDistributionBaseConfigurationOption testContainer : options = (KarafDistributionBaseConfigurationOption[])system.getOptions(KarafDistributionConfigurationOption.class)) {
            containers.add(new KarafTestContainer(system, testContainer, new KarafJavaRunner()));
        }
        return containers.toArray(new TestContainer[containers.size()]);
    }
}

