/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang.rdfxml.rrx;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.lang.rdfxml.rrx.ParserRDFXML_SAX;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.JenaXMLInput;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ReaderRDFXML_SAX
implements ReaderRIOT {
    public static ReaderRIOTFactory factory = (language, parserProfile) -> new ReaderRDFXML_SAX(parserProfile);
    private final ParserProfile parserProfile;
    public static boolean TRACE = false;

    public ReaderRDFXML_SAX(ParserProfile parserProfile) {
        this.parserProfile = parserProfile;
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        InputSource input = new InputSource(in);
        this.parse(input, baseURI, ct, output, context2);
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        InputSource input = new InputSource(reader);
        this.parse(input, baseURI, ct, output, context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputSource inputSource, String xmlBase, ContentType ct, StreamRDF destination, Context context2) {
        ParserRDFXML_SAX sax2rdf = new ParserRDFXML_SAX(xmlBase, this.parserProfile, destination, RIOT.getContext().copy());
        try {
            XMLReader xmlReader = ReaderRDFXML_SAX.createXMLReader();
            xmlReader.setDTDHandler(sax2rdf);
            xmlReader.setEntityResolver(sax2rdf);
            xmlReader.setErrorHandler(sax2rdf);
            xmlReader.setContentHandler(sax2rdf);
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", sax2rdf);
            destination.start();
            try {
                xmlReader.parse(inputSource);
            }
            finally {
                destination.finish();
            }
        }
        catch (RiotException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw IOX.exception((IOException)ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RiotException(ex);
        }
    }

    private static XMLReader createXMLReader() throws Exception {
        XMLReader xmlreader = JenaXMLInput.createXMLReader();
        xmlreader.setFeature("http://xml.org/sax/features/namespaces", true);
        xmlreader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        return xmlreader;
    }
}

