/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.shell;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.karaf.shell.CamelCommandSupport;
import org.apache.camel.karaf.shell.completers.CamelContextCompleter;
import org.apache.camel.util.URISupport;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="camel", name="endpoint-list", description="Lists the Camel endpoints")
@Service
public class EndpointList
extends CamelCommandSupport
implements Action {
    @Argument(index=0, name="context", description="The name of the Camel context (support wildcard)", required=false, multiValued=false)
    @Completion(value=CamelContextCompleter.class)
    String name;
    @Option(name="--decode", aliases={"-d"}, description="Whether to decode the endpoint uri so its human readable", required=false, multiValued=false, valueToShowInHelp="true")
    boolean decode = true;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Context");
        table.column("Uri");
        table.column("Status");
        List<CamelContext> camelContexts = this.getCamelContext(this.name);
        for (CamelContext camelContext : camelContexts) {
            ArrayList endpoints = new ArrayList(camelContext.getEndpoints());
            Collections.sort(endpoints, new Comparator<Endpoint>(){

                @Override
                public int compare(Endpoint e1, Endpoint e2) {
                    return e1.getEndpointKey().compareTo(e2.getEndpointKey());
                }
            });
            for (Endpoint endpoint : endpoints) {
                String uri = endpoint.getEndpointUri();
                if (this.decode) {
                    uri = URLDecoder.decode(uri, "UTF-8");
                }
                uri = URISupport.sanitizeUri((String)uri);
                table.addRow().addContent(new Object[]{camelContext.getName(), uri, EndpointList.getEndpointState(endpoint)});
            }
        }
        table.print(System.out);
        return null;
    }

    private static String getEndpointState(Endpoint endpoint) {
        if (endpoint instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)endpoint).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }
}

