/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.dsl;

import org.apache.camel.tooling.model.ComponentModel;
import org.apache.commons.text.CaseUtils;

public final class DslHelper {
    private DslHelper() {
    }

    public static String toCamelCaseLower(String schema) {
        String convertedText = CaseUtils.toCamelCase((String)schema, (boolean)false, (char[])new char[]{'-', '+'});
        if (convertedText != null) {
            convertedText = DslHelper.sanitizeText(convertedText);
        }
        return convertedText;
    }

    public static String sanitizeText(String convertedText) {
        switch (convertedText) {
            case "class": {
                convertedText = "clas";
                break;
            }
            case "package": {
                convertedText = "packag";
                break;
            }
            case "rest": {
                convertedText = "restEndpoint";
                break;
            }
        }
        return convertedText;
    }

    public static String getMainDescriptionWithoutPathOptions(ComponentModel componentModel) {
        String desc = componentModel.getTitle() + " (" + componentModel.getArtifactId() + ")";
        desc = desc + "\n" + componentModel.getDescription();
        desc = desc + "\n";
        desc = desc + "\nCategory: " + componentModel.getLabel();
        desc = desc + "\nSince: " + componentModel.getFirstVersionShort();
        desc = desc + "\nMaven coordinates: " + componentModel.getGroupId() + ":" + componentModel.getArtifactId();
        return desc;
    }
}

