/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;

public class OWLObjectDuplicator
implements OWLObjectVisitorEx<OWLObject> {
    protected final RemappingIndividualProvider anonProvider;
    private final OWLDataFactory df;
    private final Map<OWLEntity, IRI> replacementMap;
    private final Map<OWLLiteral, OWLLiteral> replacementLiterals;

    public OWLObjectDuplicator(Map<OWLEntity, IRI> entityIRIReplacementMap, OWLOntologyManager m) {
        this(entityIRIReplacementMap, Collections.emptyMap(), m);
    }

    public OWLObjectDuplicator(Map<OWLEntity, IRI> entityIRIReplacementMap, Map<OWLLiteral, OWLLiteral> literals, OWLOntologyManager m) {
        this(entityIRIReplacementMap, literals, m, new RemappingIndividualProvider(m.getOntologyConfigurator(), m.getOWLDataFactory()));
    }

    public OWLObjectDuplicator(Map<OWLEntity, IRI> entityIRIReplacementMap, Map<OWLLiteral, OWLLiteral> literals, OWLOntologyManager m, RemappingIndividualProvider anonProvider) {
        this.df = OWLAPIPreconditions.checkNotNull(m, "ontology manager cannot be null").getOWLDataFactory();
        this.anonProvider = anonProvider;
        this.replacementMap = new HashMap<OWLEntity, IRI>(OWLAPIPreconditions.checkNotNull(entityIRIReplacementMap, "entityIRIReplacementMap cannot be null"));
        OWLAPIPreconditions.checkNotNull(literals, "literals cannot be null");
        this.replacementLiterals = literals;
    }

    public OWLObjectDuplicator(OWLOntologyManager m) {
        this(Collections.emptyMap(), m);
    }

    public OWLObjectDuplicator(OWLOntologyManager m, Map<IRI, IRI> iriReplacementMap) {
        this(OWLObjectDuplicator.remap(iriReplacementMap, m.getOWLDataFactory()), m);
    }

    public OWLObjectDuplicator(OWLOntologyManager m, Map<IRI, IRI> iriReplacementMap, RemappingIndividualProvider anonProvider) {
        this(OWLObjectDuplicator.remap(iriReplacementMap, m.getOWLDataFactory()), Collections.emptyMap(), m, anonProvider);
    }

    private static Map<OWLEntity, IRI> remap(Map<IRI, IRI> iriReplacementMap, OWLDataFactory df) {
        HashMap<OWLEntity, IRI> map = new HashMap<OWLEntity, IRI>();
        iriReplacementMap.forEach((k, v) -> {
            map.put(df.getOWLClass((IRI)k), (IRI)v);
            map.put(df.getOWLObjectProperty((IRI)k), (IRI)v);
            map.put(df.getOWLDataProperty((IRI)k), (IRI)v);
            map.put(df.getOWLNamedIndividual((IRI)k), (IRI)v);
            map.put(df.getOWLDatatype((IRI)k), (IRI)v);
            map.put(df.getOWLAnnotationProperty((IRI)k), (IRI)v);
        });
        return map;
    }

    public <O extends OWLObject> O duplicateObject(O object) {
        OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
        return this.t(object);
    }

    private IRI getIRI(OWLEntity entity) {
        OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null");
        IRI replacement = this.replacementMap.get(entity);
        if (replacement == null) {
            return entity.getIRI();
        }
        return replacement;
    }

    private List<OWLAnnotation> a(HasAnnotations axiom) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        return OWLAPIStreamUtils.asList(axiom.annotations().map(this::t));
    }

    @Override
    public OWLAsymmetricObjectPropertyAxiom visit(OWLAsymmetricObjectPropertyAxiom ax) {
        return this.df.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)ax.getProperty()), this.a(ax));
    }

    @Override
    public OWLClassAssertionAxiom visit(OWLClassAssertionAxiom ax) {
        return this.df.getOWLClassAssertionAxiom(this.t(ax.getClassExpression()), this.t(ax.getIndividual()), this.a(ax));
    }

    @Override
    public OWLDataPropertyAssertionAxiom visit(OWLDataPropertyAssertionAxiom ax) {
        return this.df.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.t(ax.getProperty()), this.t(ax.getSubject()), (OWLLiteral)this.t(ax.getObject()), this.a(ax));
    }

    @Override
    public OWLDataPropertyDomainAxiom visit(OWLDataPropertyDomainAxiom ax) {
        return this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)this.t((OWLObject)ax.getProperty()), (OWLClassExpression)this.t((OWLObject)ax.getDomain()), this.a(ax));
    }

    @Override
    public OWLDataPropertyRangeAxiom visit(OWLDataPropertyRangeAxiom ax) {
        return this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)this.t((OWLObject)ax.getProperty()), (OWLDataRange)this.t((OWLObject)ax.getRange()), this.a(ax));
    }

    @Override
    public OWLSubDataPropertyOfAxiom visit(OWLSubDataPropertyOfAxiom ax) {
        return this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)this.t((OWLObject)ax.getSubProperty()), (OWLDataPropertyExpression)this.t((OWLObject)ax.getSuperProperty()), this.a(ax));
    }

    @Override
    public OWLDeclarationAxiom visit(OWLDeclarationAxiom ax) {
        return this.df.getOWLDeclarationAxiom(this.t(ax.getEntity()), this.a(ax));
    }

    @Override
    public OWLDifferentIndividualsAxiom visit(OWLDifferentIndividualsAxiom ax) {
        return this.df.getOWLDifferentIndividualsAxiom(this.list(ax.individuals()), this.a(ax));
    }

    @Override
    public OWLDisjointClassesAxiom visit(OWLDisjointClassesAxiom ax) {
        return this.df.getOWLDisjointClassesAxiom(this.list(ax.classExpressions()), this.a(ax));
    }

    @Override
    public OWLDisjointDataPropertiesAxiom visit(OWLDisjointDataPropertiesAxiom ax) {
        return this.df.getOWLDisjointDataPropertiesAxiom(this.list(ax.properties()), this.a(ax));
    }

    @Override
    public OWLDisjointObjectPropertiesAxiom visit(OWLDisjointObjectPropertiesAxiom ax) {
        return this.df.getOWLDisjointObjectPropertiesAxiom(this.list(ax.properties()), this.a(ax));
    }

    @Override
    public OWLDisjointUnionAxiom visit(OWLDisjointUnionAxiom ax) {
        return this.df.getOWLDisjointUnionAxiom(this.t(ax.getOWLClass()), this.list(ax.classExpressions()), this.a(ax));
    }

    @Override
    public OWLAnnotationAssertionAxiom visit(OWLAnnotationAssertionAxiom ax) {
        return this.df.getOWLAnnotationAssertionAxiom((OWLAnnotationProperty)this.t((OWLObject)ax.getProperty()), (OWLAnnotationSubject)this.t((OWLObject)ax.getSubject()), this.t(ax.getValue()), this.a(ax));
    }

    @Override
    public OWLEquivalentClassesAxiom visit(OWLEquivalentClassesAxiom ax) {
        return this.df.getOWLEquivalentClassesAxiom(this.list(ax.classExpressions()), this.a(ax));
    }

    @Override
    public OWLEquivalentDataPropertiesAxiom visit(OWLEquivalentDataPropertiesAxiom ax) {
        return this.df.getOWLEquivalentDataPropertiesAxiom(this.list(ax.properties()), this.a(ax));
    }

    @Override
    public OWLEquivalentObjectPropertiesAxiom visit(OWLEquivalentObjectPropertiesAxiom ax) {
        return this.df.getOWLEquivalentObjectPropertiesAxiom(this.list(ax.properties()), this.a(ax));
    }

    @Override
    public OWLFunctionalDataPropertyAxiom visit(OWLFunctionalDataPropertyAxiom ax) {
        return this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.t((OWLObject)ax.getProperty()), this.a(ax));
    }

    @Override
    public OWLFunctionalObjectPropertyAxiom visit(OWLFunctionalObjectPropertyAxiom ax) {
        return this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)ax.getProperty()), this.a(ax));
    }

    @Override
    public OWLInverseFunctionalObjectPropertyAxiom visit(OWLInverseFunctionalObjectPropertyAxiom ax) {
        return this.df.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)ax.getProperty()), this.a(ax));
    }

    @Override
    public OWLInverseObjectPropertiesAxiom visit(OWLInverseObjectPropertiesAxiom ax) {
        return this.df.getOWLInverseObjectPropertiesAxiom(this.t(ax.getFirstProperty()), this.t(ax.getSecondProperty()), this.a(ax));
    }

    @Override
    public OWLIrreflexiveObjectPropertyAxiom visit(OWLIrreflexiveObjectPropertyAxiom ax) {
        return this.df.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)ax.getProperty()), this.a(ax));
    }

    @Override
    public OWLNegativeDataPropertyAssertionAxiom visit(OWLNegativeDataPropertyAssertionAxiom ax) {
        return this.df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.t(ax.getProperty()), this.t(ax.getSubject()), (OWLLiteral)this.t(ax.getObject()), this.a(ax));
    }

    @Override
    public OWLNegativeObjectPropertyAssertionAxiom visit(OWLNegativeObjectPropertyAssertionAxiom ax) {
        return this.df.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.t(ax.getProperty()), this.t(ax.getSubject()), (OWLIndividual)this.t(ax.getObject()), this.a(ax));
    }

    @Override
    public OWLObjectPropertyAssertionAxiom visit(OWLObjectPropertyAssertionAxiom ax) {
        return this.df.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.t(ax.getProperty()), this.t(ax.getSubject()), (OWLIndividual)this.t(ax.getObject()), this.a(ax));
    }

    @Override
    public OWLSubPropertyChainOfAxiom visit(OWLSubPropertyChainOfAxiom ax) {
        List<OWLObjectPropertyExpression> chain = OWLAPIStreamUtils.asList(ax.getPropertyChain().stream().map(this::t));
        return this.df.getOWLSubPropertyChainOfAxiom(chain, this.t(ax.getSuperProperty()), this.a(ax));
    }

    @Override
    public OWLObjectPropertyDomainAxiom visit(OWLObjectPropertyDomainAxiom ax) {
        return this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)this.t((OWLObject)ax.getProperty()), (OWLClassExpression)this.t((OWLObject)ax.getDomain()), this.a(ax));
    }

    @Override
    public OWLObjectPropertyRangeAxiom visit(OWLObjectPropertyRangeAxiom ax) {
        return this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.t((OWLObject)ax.getProperty()), (OWLClassExpression)this.t((OWLObject)ax.getRange()), this.a(ax));
    }

    @Override
    public OWLSubObjectPropertyOfAxiom visit(OWLSubObjectPropertyOfAxiom ax) {
        return this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.t((OWLObject)ax.getSubProperty()), (OWLObjectPropertyExpression)this.t((OWLObject)ax.getSuperProperty()), this.a(ax));
    }

    @Override
    public OWLReflexiveObjectPropertyAxiom visit(OWLReflexiveObjectPropertyAxiom ax) {
        return this.df.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)ax.getProperty()), this.a(ax));
    }

    @Override
    public OWLSameIndividualAxiom visit(OWLSameIndividualAxiom ax) {
        return this.df.getOWLSameIndividualAxiom(this.list(ax.individuals()), this.a(ax));
    }

    @Override
    public OWLSubClassOfAxiom visit(OWLSubClassOfAxiom ax) {
        return this.df.getOWLSubClassOfAxiom(this.t(ax.getSubClass()), this.t(ax.getSuperClass()), this.a(ax));
    }

    @Override
    public OWLSymmetricObjectPropertyAxiom visit(OWLSymmetricObjectPropertyAxiom ax) {
        return this.df.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)ax.getProperty()), this.a(ax));
    }

    @Override
    public OWLTransitiveObjectPropertyAxiom visit(OWLTransitiveObjectPropertyAxiom ax) {
        return this.df.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.t((OWLObject)ax.getProperty()), this.a(ax));
    }

    @Override
    public OWLClass visit(OWLClass ce) {
        return this.df.getOWLClass(this.getIRI(ce));
    }

    @Override
    public OWLDataAllValuesFrom visit(OWLDataAllValuesFrom ce) {
        return this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLDataExactCardinality visit(OWLDataExactCardinality ce) {
        return this.df.getOWLDataExactCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLDataMaxCardinality visit(OWLDataMaxCardinality ce) {
        return this.df.getOWLDataMaxCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLDataMinCardinality visit(OWLDataMinCardinality ce) {
        return this.df.getOWLDataMinCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLDataSomeValuesFrom visit(OWLDataSomeValuesFrom ce) {
        return this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLDataHasValue visit(OWLDataHasValue ce) {
        return this.df.getOWLDataHasValue((OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLLiteral)this.t((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLObjectAllValuesFrom visit(OWLObjectAllValuesFrom ce) {
        return this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLObjectComplementOf visit(OWLObjectComplementOf ce) {
        return this.df.getOWLObjectComplementOf(this.t(ce.getOperand()));
    }

    @Override
    public OWLObjectExactCardinality visit(OWLObjectExactCardinality ce) {
        return this.df.getOWLObjectExactCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLObjectIntersectionOf visit(OWLObjectIntersectionOf ce) {
        return this.df.getOWLObjectIntersectionOf(this.list(ce.operands()));
    }

    @Override
    public OWLObjectMaxCardinality visit(OWLObjectMaxCardinality ce) {
        return this.df.getOWLObjectMaxCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLObjectMinCardinality visit(OWLObjectMinCardinality ce) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.t(ce.getProperty());
        return this.df.getOWLObjectMinCardinality(ce.getCardinality(), prop, (OWLClassExpression)this.t((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLObjectOneOf visit(OWLObjectOneOf ce) {
        return this.df.getOWLObjectOneOf(this.list(ce.individuals()));
    }

    @Override
    public OWLObjectHasSelf visit(OWLObjectHasSelf ce) {
        return this.df.getOWLObjectHasSelf(this.t(ce.getProperty()));
    }

    @Override
    public OWLObjectSomeValuesFrom visit(OWLObjectSomeValuesFrom ce) {
        return this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLObjectUnionOf visit(OWLObjectUnionOf ce) {
        return this.df.getOWLObjectUnionOf(this.list(ce.operands()));
    }

    @Override
    public OWLObjectHasValue visit(OWLObjectHasValue ce) {
        return this.df.getOWLObjectHasValue((OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLIndividual)this.t((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLDataComplementOf visit(OWLDataComplementOf node) {
        return this.df.getOWLDataComplementOf(this.t(node.getDataRange()));
    }

    @Override
    public OWLDataOneOf visit(OWLDataOneOf node) {
        return this.df.getOWLDataOneOf(this.list(node.values()));
    }

    @Override
    public OWLDatatype visit(OWLDatatype node) {
        return this.df.getOWLDatatype(this.getIRI(node));
    }

    @Override
    public OWLDatatypeRestriction visit(OWLDatatypeRestriction node) {
        return this.df.getOWLDatatypeRestriction(this.t(node.getDatatype()), this.list(node.facetRestrictions()));
    }

    @Override
    public OWLFacetRestriction visit(OWLFacetRestriction node) {
        return this.df.getOWLFacetRestriction(node.getFacet(), this.t(node.getFacetValue()));
    }

    @Override
    public OWLLiteral visit(OWLLiteral node) {
        OWLLiteral l = this.replacementLiterals.get(node);
        if (l != null) {
            return l;
        }
        if (node.hasLang()) {
            return this.df.getOWLLiteral(node.getLiteral(), node.getLang());
        }
        return this.df.getOWLLiteral(node.getLiteral(), this.t(node.getDatatype()));
    }

    @Override
    public OWLDataProperty visit(OWLDataProperty property) {
        return this.df.getOWLDataProperty(this.getIRI(property));
    }

    @Override
    public OWLObjectProperty visit(OWLObjectProperty property) {
        return this.df.getOWLObjectProperty(this.getIRI(property));
    }

    @Override
    public OWLObjectInverseOf visit(OWLObjectInverseOf property) {
        OWLObjectPropertyExpression inverse = property.getInverse();
        if (inverse.isAnonymous()) {
            return this.df.getOWLObjectInverseOf(this.t(property.getNamedProperty()));
        }
        return this.df.getOWLObjectInverseOf(this.t(inverse.asOWLObjectProperty()));
    }

    @Override
    public OWLNamedIndividual visit(OWLNamedIndividual individual) {
        return this.df.getOWLNamedIndividual(this.getIRI(individual));
    }

    @Override
    public OWLOntology visit(OWLOntology ontology) {
        return ontology;
    }

    @Override
    public SWRLRule visit(SWRLRule rule) {
        return this.df.getSWRLRule(this.list(rule.body()), this.list(rule.head()), this.a(rule));
    }

    @Override
    public SWRLClassAtom visit(SWRLClassAtom node) {
        return this.df.getSWRLClassAtom(this.t(node.getPredicate()), (SWRLIArgument)this.t((OWLObject)node.getArgument()));
    }

    @Override
    public SWRLDataRangeAtom visit(SWRLDataRangeAtom node) {
        return this.df.getSWRLDataRangeAtom(this.t(node.getPredicate()), (SWRLDArgument)this.t((OWLObject)node.getArgument()));
    }

    @Override
    public SWRLObjectPropertyAtom visit(SWRLObjectPropertyAtom node) {
        return this.df.getSWRLObjectPropertyAtom(this.t(node.getPredicate()), (SWRLIArgument)this.t((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.t((OWLObject)node.getSecondArgument()));
    }

    @Override
    public SWRLDataPropertyAtom visit(SWRLDataPropertyAtom node) {
        return this.df.getSWRLDataPropertyAtom(this.t(node.getPredicate()), (SWRLIArgument)this.t((OWLObject)node.getFirstArgument()), (SWRLDArgument)this.t((OWLObject)node.getSecondArgument()));
    }

    @Override
    public SWRLBuiltInAtom visit(SWRLBuiltInAtom node) {
        return this.df.getSWRLBuiltInAtom(node.getPredicate(), this.list(node.arguments()));
    }

    @Override
    public SWRLDifferentIndividualsAtom visit(SWRLDifferentIndividualsAtom node) {
        return this.df.getSWRLDifferentIndividualsAtom((SWRLIArgument)this.t((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.t((OWLObject)node.getSecondArgument()));
    }

    @Override
    public SWRLSameIndividualAtom visit(SWRLSameIndividualAtom node) {
        return this.df.getSWRLSameIndividualAtom((SWRLIArgument)this.t((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.t((OWLObject)node.getSecondArgument()));
    }

    @Override
    public SWRLVariable visit(SWRLVariable node) {
        return this.df.getSWRLVariable(this.t(node.getIRI()));
    }

    @Override
    public SWRLIndividualArgument visit(SWRLIndividualArgument node) {
        return this.df.getSWRLIndividualArgument(this.t(node.getIndividual()));
    }

    @Override
    public SWRLLiteralArgument visit(SWRLLiteralArgument node) {
        return this.df.getSWRLLiteralArgument(this.t(node.getLiteral()));
    }

    @Override
    public OWLHasKeyAxiom visit(OWLHasKeyAxiom ax) {
        return this.df.getOWLHasKeyAxiom(this.t(ax.getClassExpression()), this.list(ax.propertyExpressions()), this.a(ax));
    }

    @Override
    public OWLDataIntersectionOf visit(OWLDataIntersectionOf node) {
        return this.df.getOWLDataIntersectionOf(this.list(node.operands()));
    }

    @Override
    public OWLDataUnionOf visit(OWLDataUnionOf node) {
        return this.df.getOWLDataUnionOf(this.list(node.operands()));
    }

    @Override
    public OWLAnnotationProperty visit(OWLAnnotationProperty property) {
        return this.df.getOWLAnnotationProperty(this.getIRI(property));
    }

    @Override
    public OWLAnnotationPropertyDomainAxiom visit(OWLAnnotationPropertyDomainAxiom ax) {
        return this.df.getOWLAnnotationPropertyDomainAxiom((OWLAnnotationProperty)this.t((OWLObject)ax.getProperty()), (IRI)this.t((OWLObject)ax.getDomain()), this.a(ax));
    }

    @Override
    public OWLAnnotationPropertyRangeAxiom visit(OWLAnnotationPropertyRangeAxiom ax) {
        return this.df.getOWLAnnotationPropertyRangeAxiom((OWLAnnotationProperty)this.t((OWLObject)ax.getProperty()), (IRI)this.t((OWLObject)ax.getRange()), this.a(ax));
    }

    @Override
    public OWLSubAnnotationPropertyOfAxiom visit(OWLSubAnnotationPropertyOfAxiom ax) {
        return this.df.getOWLSubAnnotationPropertyOfAxiom(this.t(ax.getSubProperty()), this.t(ax.getSuperProperty()), this.a(ax));
    }

    @Override
    public OWLAnnotation visit(OWLAnnotation node) {
        if (node.annotationsAsList().isEmpty()) {
            return this.df.getOWLAnnotation(this.t(node.getProperty()), this.t(node.getValue()));
        }
        return this.df.getOWLAnnotation(this.t(node.getProperty()), this.t(node.getValue()), node.annotations().map(this::t));
    }

    @Override
    public OWLAnonymousIndividual visit(OWLAnonymousIndividual individual) {
        return this.anonProvider.getOWLAnonymousIndividual(individual.getID().getID());
    }

    @Override
    public IRI visit(IRI iri) {
        for (EntityType<?> entityType : EntityType.values()) {
            Object entity = this.df.getOWLEntity(entityType, iri);
            IRI replacementIRI = this.replacementMap.get(entity);
            if (replacementIRI == null) continue;
            return replacementIRI;
        }
        return iri;
    }

    @Override
    public OWLDatatypeDefinitionAxiom visit(OWLDatatypeDefinitionAxiom ax) {
        return this.df.getOWLDatatypeDefinitionAxiom(this.t(ax.getDatatype()), this.t(ax.getDataRange()), this.a(ax));
    }

    protected <O extends OWLObject> List<O> list(Stream<O> objects) {
        return OWLAPIStreamUtils.asList(objects.map(this::t));
    }

    protected <O extends OWLObject> O t(O o) {
        return (O)o.accept(this);
    }
}

