/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasOperands;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public interface OWLHasKeyAxiom
extends OWLLogicalAxiom,
HasOperands<OWLPropertyExpression> {
    public OWLHasKeyAxiom getAxiomWithoutAnnotations();

    @Override
    default public Stream<?> components() {
        return Stream.of(this.getClassExpression(), this.getOperandsAsList(), this.annotationsAsList());
    }

    @Override
    default public int initHashCode() {
        int hash = this.hashIndex();
        hash = OWLObject.hashIteration(hash, this.getClassExpression().hashCode());
        hash = OWLObject.hashIteration(hash, this.getOperandsAsList().hashCode());
        return OWLObject.hashIteration(hash, this.annotationsAsList().hashCode());
    }

    @Override
    default public Stream<?> componentsWithoutAnnotations() {
        return Stream.of(this.getClassExpression(), this.getOperandsAsList());
    }

    @Override
    default public Stream<?> componentsAnnotationsFirst() {
        return Stream.of(this.annotationsAsList(), this.getClassExpression(), this.getOperandsAsList());
    }

    @Override
    default public int hashIndex() {
        return 821;
    }

    public OWLClassExpression getClassExpression();

    default public Set<OWLPropertyExpression> getPropertyExpressions() {
        return OWLAPIStreamUtils.asSet(this.propertyExpressions());
    }

    public Stream<OWLPropertyExpression> propertyExpressions();

    default public Set<OWLObjectPropertyExpression> getObjectPropertyExpressions() {
        return OWLAPIStreamUtils.asSet(this.objectPropertiesInSignature(), OWLObjectPropertyExpression.class);
    }

    default public Stream<OWLObjectPropertyExpression> objectPropertyExpressions() {
        return this.propertyExpressions().filter(OWLPropertyExpression::isObjectPropertyExpression).map(OWLPropertyExpression::asObjectPropertyExpression);
    }

    default public Set<OWLDataPropertyExpression> getDataPropertyExpressions() {
        return OWLAPIStreamUtils.asSet(this.dataPropertyExpressions());
    }

    default public Stream<OWLDataPropertyExpression> dataPropertyExpressions() {
        return this.propertyExpressions().filter(OWLPropertyExpression::isDataPropertyExpression).map(OWLPropertyExpression::asDataPropertyExpression);
    }

    @Override
    default public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    default public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    default public AxiomType<?> getAxiomType() {
        return AxiomType.HAS_KEY;
    }
}

