/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.List;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.HttpAuthenticationScheme;
import springfox.documentation.service.VendorExtension;

public class HttpAuthenticationBuilder {
    private String name;
    private String description;
    private String scheme;
    private String bearerFormat;
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();

    public HttpAuthenticationBuilder name(String name) {
        this.name = name;
        return this;
    }

    public HttpAuthenticationBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public HttpAuthenticationBuilder bearerFormat(String bearerFormat) {
        this.bearerFormat = bearerFormat;
        return this;
    }

    public HttpAuthenticationBuilder description(String description) {
        this.description = description;
        return this;
    }

    public HttpAuthenticationBuilder extensions(List<VendorExtension> extensions) {
        this.extensions.addAll(BuilderDefaults.nullToEmptyList(extensions));
        return this;
    }

    public HttpAuthenticationScheme build() {
        return new HttpAuthenticationScheme(this.name, this.description, "http", this.scheme, this.bearerFormat, this.extensions);
    }
}

