/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateExtension;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.generator.AbstractGenerator;
import io.quarkus.qute.generator.Descriptors;
import io.quarkus.qute.generator.DotNames;
import io.quarkus.qute.generator.ValueResolverGenerator;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;

public class ExtensionMethodGenerator
extends AbstractGenerator {
    public static final DotName TEMPLATE_EXTENSION = DotName.createSimple((String)TemplateExtension.class.getName());
    public static final DotName TEMPLATE_ATTRIBUTE = DotName.createSimple((String)TemplateExtension.TemplateAttribute.class.getName());
    public static final String SUFFIX = "_Extension_ValueResolver";
    public static final String NAMESPACE_SUFFIX = "_Namespace_Extension_ValueResolver";
    public static final String MATCH_NAME = "matchName";
    public static final String MATCH_NAMES = "matchNames";
    public static final String MATCH_REGEX = "matchRegex";
    public static final String PRIORITY = "priority";
    public static final String NAMESPACE = "namespace";
    public static final String PATTERN = "pattern";

    public ExtensionMethodGenerator(IndexView index, ClassOutput classOutput) {
        super(index, classOutput);
    }

    @Override
    public Set<String> getGeneratedTypes() {
        return this.generatedTypes;
    }

    public static void validate(MethodInfo method, String namespace) {
        if (!Modifier.isStatic(method.flags())) {
            throw new IllegalStateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + "  must be static: " + String.valueOf(method));
        }
        if (method.returnType().kind() == Type.Kind.VOID) {
            throw new IllegalStateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + " must not return void: " + String.valueOf(method));
        }
        if (Modifier.isPrivate(method.flags())) {
            throw new IllegalStateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + " must not be private: " + String.valueOf(method));
        }
    }

    public String generate(MethodInfo method, String matchName, List<String> matchNames, String matchRegex, Integer priority) {
        AnnotationValue matchRegexValue;
        AnnotationValue priorityValue;
        AnnotationValue matchNamesValue;
        AnnotationValue matchNameValue;
        AnnotationInstance extensionAnnotation = method.annotation(TEMPLATE_EXTENSION);
        List parameters = method.parameterTypes();
        ExtensionMethodGenerator.validate(method, null);
        ClassInfo declaringClass = method.declaringClass();
        if (matchName == null && extensionAnnotation != null && (matchNameValue = extensionAnnotation.value(MATCH_NAME)) != null) {
            matchName = matchNameValue.asString();
        }
        if (matchName == null || matchName.equals("<<method name>>")) {
            matchName = method.name();
        }
        if (matchNames == null && extensionAnnotation != null && (matchNamesValue = extensionAnnotation.value(MATCH_NAMES)) != null) {
            matchNames = new ArrayList<String>();
            for (String name : matchNamesValue.asStringArray()) {
                matchNames.add(name);
            }
        }
        if (priority == null && extensionAnnotation != null && (priorityValue = extensionAnnotation.value(PRIORITY)) != null) {
            priority = priorityValue.asInt();
        }
        if (priority == null) {
            priority = 5;
        }
        if (matchRegex == null && extensionAnnotation != null && (matchRegexValue = extensionAnnotation.value(MATCH_REGEX)) != null) {
            matchRegex = matchRegexValue.asString();
        }
        if (!(matchRegex == null && matchNames.isEmpty() && !matchName.equals("*") || parameters.size() >= 2 && ((Type)parameters.get(1)).name().equals((Object)DotNames.STRING))) {
            throw new TemplateException("A template extension method matching multiple names or a regular expression must declare at least two parameters and the second parameter must be string: " + String.valueOf(method));
        }
        Object baseName = declaringClass.enclosingClass() != null ? ValueResolverGenerator.simpleName(declaringClass.enclosingClass()) + "$_" + ValueResolverGenerator.simpleName(declaringClass) : ValueResolverGenerator.simpleName(declaringClass);
        String targetPackage = ValueResolverGenerator.packageName(declaringClass.name());
        String suffix = "_Extension_ValueResolver_" + method.name() + "_" + ExtensionMethodGenerator.sha1(parameters.toString());
        String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, (String)baseName, suffix);
        String generatedClassName = generatedName.replace('/', '.');
        this.generatedTypes.add(generatedClassName);
        String effectiveMatchRegex = matchRegex;
        int effectivePriority = priority;
        String effectiveMatchName = matchName;
        List<String> effectiveMatchNames = matchNames;
        this.gizmo.class_(generatedClassName, cc -> {
            cc.implements_(ValueResolver.class);
            FieldDesc pattern = null;
            if (effectiveMatchRegex != null && !effectiveMatchRegex.isEmpty()) {
                pattern = cc.field(PATTERN, fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(Pattern.class);
                    fc.setInitializer(fci -> fci.yield(fci.invokeStatic(Descriptors.PATTERN_COMPILE, new Expr[]{Const.of((String)effectiveMatchRegex)})));
                });
            }
            cc.defaultConstructor();
            this.implementGetPriority((ClassCreator)cc, effectivePriority);
            Parameters params = new Parameters(method, pattern != null || !effectiveMatchNames.isEmpty() || effectiveMatchName.equals("*"), false);
            this.implementAppliesTo((ClassCreator)cc, method, effectiveMatchName, effectiveMatchNames, pattern, params);
            this.implementResolve((ClassCreator)cc, declaringClass, method, effectiveMatchName, effectiveMatchNames, pattern, params);
        });
        return generatedClassName;
    }

    public String generateNamespaceResolver(ClassInfo declaringClass, String namespace, int priority, List<ExtensionMethodInfo> extensionMethods) {
        Object baseName = declaringClass.enclosingClass() != null ? ValueResolverGenerator.simpleName(declaringClass.enclosingClass()) + "$_" + ValueResolverGenerator.simpleName(declaringClass) : ValueResolverGenerator.simpleName(declaringClass);
        String targetPackage = ValueResolverGenerator.packageName(declaringClass.name());
        String suffix = "_Namespace_Extension_ValueResolver_" + ExtensionMethodGenerator.sha1(namespace) + "_" + priority;
        String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, (String)baseName, suffix);
        String generatedClassName = generatedName.replace('/', '.');
        this.generatedTypes.add(generatedClassName);
        this.gizmo.class_(generatedClassName, cc -> {
            cc.implements_(NamespaceResolver.class);
            for (ExtensionMethodInfo extensionMethod : extensionMethods) {
                String matchRegex = extensionMethod.matchRegex();
                if (matchRegex == null || matchRegex.isEmpty()) continue;
                cc.field("pattern_" + ExtensionMethodGenerator.sha1(extensionMethod.method().toString()), fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(Pattern.class);
                    fc.setInitializer(fci -> fci.yield(fci.invokeStatic(Descriptors.PATTERN_COMPILE, new Expr[]{Const.of((String)matchRegex)})));
                });
            }
            cc.defaultConstructor();
            this.implementGetNamespace((ClassCreator)cc, namespace);
            this.implementGetPriority((ClassCreator)cc, priority);
            cc.method("resolve", mc -> {
                mc.returning(CompletionStage.class);
                ParamVar evalContext = mc.parameter("ec", EvalContext.class);
                mc.body(bc -> {
                    LocalVar name = bc.localVar("name", bc.invokeInterface(Descriptors.GET_NAME, (Expr)evalContext, new Expr[0]));
                    LocalVar paramsCount = bc.localVar("count", bc.invokeInterface(Descriptors.COLLECTION_SIZE, bc.invokeInterface(Descriptors.GET_PARAMS, (Expr)evalContext, new Expr[0]), new Expr[0]));
                    for (ExtensionMethodInfo extensionMethod : extensionMethods) {
                        String matchRegex = extensionMethod.matchRegex();
                        FieldDesc patternField = matchRegex != null ? FieldDesc.of((ClassDesc)cc.type(), (String)("pattern_" + ExtensionMethodGenerator.sha1(extensionMethod.method().toString())), Pattern.class) : null;
                        this.addNamespaceExtensionMethod((ClassCreator)cc, (BlockCreator)bc, evalContext, patternField, extensionMethod.method(), extensionMethod.matchName(), extensionMethod.matchNames(), matchRegex, (Var)name, (Var)paramsCount);
                    }
                    bc.return_(bc.invokeStatic(Descriptors.RESULTS_NOT_FOUND_EC, new Expr[]{evalContext}));
                });
            });
        });
        return generatedClassName;
    }

    private void addNamespaceExtensionMethod(ClassCreator namespaceResolver, BlockCreator resolve, ParamVar evalContext, FieldDesc patternField, MethodInfo method, String matchName, List<String> matchNames, String matchRegex, Var name, Var paramsCount) {
        boolean isNameParamRequired = patternField != null || !matchNames.isEmpty() || matchName.equals("*");
        Parameters params = new Parameters(method, isNameParamRequired, true);
        boolean matchAny = patternField == null && matchNames.isEmpty() && matchName.equals("*");
        boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
        resolve.block(nested -> {
            if (!matchAny) {
                if (patternField != null) {
                    InstanceFieldVar pattern = namespaceResolver.this_().field(patternField);
                    Expr matcher = nested.invokeVirtual(Descriptors.PATTERN_MATCHER, (Expr)pattern, new Expr[]{name});
                    nested.ifNot(nested.invokeVirtual(Descriptors.MATCHER_MATCHES, matcher, new Expr[0]), notMatching -> notMatching.break_(nested));
                } else if (!matchNames.isEmpty()) {
                    nested.block(namesMatch -> {
                        for (String match : matchNames) {
                            namesMatch.if_(namesMatch.objEquals((Expr)name, (Expr)Const.of((String)match)), matching -> matching.break_(namesMatch));
                        }
                        namesMatch.break_(nested);
                    });
                } else {
                    nested.ifNot(nested.objEquals((Expr)name, (Expr)Const.of((String)matchName)), matching -> matching.break_(nested));
                }
            }
            int realParamSize = params.evaluated().size();
            if (!isVarArgs || realParamSize > 1) {
                if (isVarArgs) {
                    nested.if_(nested.le((Expr)paramsCount, (Expr)Const.of((int)(realParamSize - 1))), lessEqual -> lessEqual.break_(nested));
                } else {
                    nested.if_(nested.ne((Expr)paramsCount, (Expr)Const.of((int)realParamSize)), notEqual -> notEqual.break_(nested));
                }
            }
            if (!params.needsEvaluation()) {
                Expr[] args = new Expr[params.size()];
                for (int i = 0; i < params.size(); ++i) {
                    Param param = params.get(i);
                    if (param.kind == ParamKind.NAME) {
                        args[i] = name;
                        continue;
                    }
                    if (param.kind != ParamKind.ATTR) continue;
                    args[i] = nested.invokeInterface(Descriptors.GET_ATTRIBUTE, (Expr)evalContext, new Expr[]{Const.of((String)param.name)});
                }
                nested.return_(nested.invokeStatic(Descriptors.COMPLETED_STAGE_OF, new Expr[]{nested.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)method), args)}));
            } else {
                LocalVar ret = nested.localVar("ret", nested.new_(CompletableFuture.class, new Expr[0]));
                LocalVar evaluatedParams = nested.localVar("evaluatedParams", nested.invokeStatic(Descriptors.EVALUATED_PARAMS_EVALUATE, new Expr[]{evalContext}));
                InstanceFieldVar paramsReady = evaluatedParams.field(Descriptors.EVALUATED_PARAMS_STAGE);
                Expr whenCompleteFun = nested.lambda(BiConsumer.class, lc -> {
                    Var capturedName = isNameParamRequired ? lc.capture(name) : null;
                    Var capturedRet = lc.capture((Var)ret);
                    Var capturedEvaluatedParams = lc.capture((Var)evaluatedParams);
                    Var capturedEvalContext = lc.capture((Var)evalContext);
                    ParamVar result = lc.parameter("r", 0);
                    ParamVar throwable = lc.parameter("t", 1);
                    lc.body(accept -> {
                        accept.ifElse(accept.isNull((Expr)throwable), success -> {
                            List<Param> evaluated = params.evaluated();
                            LocalVar paramTypes = success.localVar("pt", success.newArray(Class.class, evaluated.stream().map(p -> Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)p.type))).toList()));
                            success.ifNot(success.invokeVirtual(Descriptors.EVALUATED_PARAMS_PARAM_TYPES_MATCH, (Expr)capturedEvaluatedParams, new Expr[]{Const.of((boolean)isVarArgs), paramTypes}), typeMatchFailed -> {
                                typeMatchFailed.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet, new Expr[]{typeMatchFailed.invokeStatic(Descriptors.NOT_FOUND_FROM_EC, new Expr[]{capturedEvalContext})});
                                typeMatchFailed.return_();
                            });
                            success.try_(tc -> {
                                tc.body(tcb -> {
                                    Expr[] args = new Expr[params.size()];
                                    int evalIdx = 0;
                                    int lastIdx = params.size() - 1;
                                    for (int i = 0; i < params.size(); ++i) {
                                        Param param = params.get(i);
                                        if (param.kind == ParamKind.NAME) {
                                            args[i] = capturedName;
                                            continue;
                                        }
                                        if (param.kind == ParamKind.ATTR) {
                                            args[i] = tcb.invokeInterface(Descriptors.GET_ATTRIBUTE, (Expr)capturedEvalContext, new Expr[]{Const.of((String)param.name)});
                                            continue;
                                        }
                                        if (isVarArgs && i == lastIdx) {
                                            Expr varargsResults;
                                            Type varargsParam = params.get((int)lastIdx).type;
                                            Const componentType = Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)varargsParam.asArrayType().elementType()));
                                            args[i] = varargsResults = tcb.invokeVirtual(Descriptors.EVALUATED_PARAMS_GET_VARARGS_RESULTS, (Expr)capturedEvaluatedParams, new Expr[]{Const.of((int)evaluated.size()), componentType});
                                            continue;
                                        }
                                        args[i] = tcb.invokeVirtual(Descriptors.EVALUATED_PARAMS_GET_RESULT, (Expr)capturedEvaluatedParams, new Expr[]{Const.of((int)evalIdx++)});
                                    }
                                    Expr invokeRet = tcb.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)method), args);
                                    tcb.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet, new Expr[]{invokeRet});
                                });
                                tc.catch_(Throwable.class, "e", (cb, e) -> cb.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet, new Expr[]{e}));
                            });
                        }, failure -> failure.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet, new Expr[]{throwable}));
                        accept.return_();
                    });
                });
                nested.invokeInterface(Descriptors.CF_WHEN_COMPLETE, (Expr)paramsReady, new Expr[]{whenCompleteFun});
                nested.return_((Expr)ret);
            }
        });
    }

    private void implementGetNamespace(ClassCreator namespaceResolver, String namespace) {
        namespaceResolver.method("getNamespace", mc -> {
            mc.returning(String.class);
            mc.body(bc -> bc.return_(namespace));
        });
    }

    private void implementGetPriority(ClassCreator valueResolver, int priority) {
        valueResolver.method("getPriority", mc -> {
            mc.returning(Integer.TYPE);
            mc.body(bc -> bc.return_(priority));
        });
    }

    private void implementResolve(ClassCreator valueResolver, ClassInfo declaringClass, MethodInfo method, String matchName, List<String> matchNames, FieldDesc patternField, Parameters params) {
        valueResolver.method("resolve", mc -> {
            mc.returning(CompletionStage.class);
            ParamVar evalContext = mc.parameter("evalContext", EvalContext.class);
            mc.body(bc -> {
                boolean isNameParamRequired = patternField != null || !matchNames.isEmpty() || matchName.equals("*");
                boolean returnsCompletionStage = this.hasCompletionStage(method.returnType());
                if (!params.needsEvaluation()) {
                    LocalVar ret = bc.localVar("ret", (Expr)Const.ofNull(CompletionStage.class));
                    Expr[] args = new Expr[params.size()];
                    for (int i = 0; i < params.size(); ++i) {
                        Param param = params.get(i);
                        if (param.kind == ParamKind.BASE) {
                            args[i] = bc.localVar("base", bc.invokeInterface(Descriptors.GET_BASE, (Expr)evalContext, new Expr[0]));
                            continue;
                        }
                        if (param.kind == ParamKind.NAME) {
                            args[i] = bc.invokeInterface(Descriptors.GET_NAME, (Expr)evalContext, new Expr[0]);
                            continue;
                        }
                        if (param.kind != ParamKind.ATTR) continue;
                        args[i] = bc.invokeInterface(Descriptors.GET_ATTRIBUTE, (Expr)evalContext, new Expr[]{Const.of((String)param.name)});
                    }
                    Expr result = bc.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)method), args);
                    if (returnsCompletionStage) {
                        bc.set((Assignable)ret, result);
                    } else {
                        bc.set((Assignable)ret, bc.invokeStatic(Descriptors.COMPLETED_STAGE_OF, new Expr[]{result}));
                    }
                    bc.return_((Expr)ret);
                } else {
                    LocalVar ret = bc.localVar("ret", bc.new_(CompletableFuture.class, new Expr[0]));
                    LocalVar base = bc.localVar("base", bc.invokeInterface(Descriptors.GET_BASE, (Expr)evalContext, new Expr[0]));
                    LocalVar name = bc.localVar("name", bc.invokeInterface(Descriptors.GET_NAME, (Expr)evalContext, new Expr[0]));
                    LocalVar evaluatedParams = bc.localVar("evaluatedParams", bc.invokeStatic(Descriptors.EVALUATED_PARAMS_EVALUATE, new Expr[]{evalContext}));
                    InstanceFieldVar paramsReady = evaluatedParams.field(Descriptors.EVALUATED_PARAMS_STAGE);
                    Expr whenCompleteFun = bc.lambda(BiConsumer.class, lc -> {
                        Var capturedBase = lc.capture((Var)base);
                        Var capturedName = isNameParamRequired ? lc.capture((Var)name) : null;
                        Var capturedRet = lc.capture((Var)ret);
                        Var capturedEvaluatedParams = lc.capture((Var)evaluatedParams);
                        Var capturedEvalContext = lc.capture((Var)evalContext);
                        ParamVar result = lc.parameter("r", 0);
                        ParamVar throwable = lc.parameter("t", 1);
                        lc.body(accept -> {
                            accept.ifElse(accept.isNull((Expr)throwable), success -> {
                                boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
                                List<Param> evaluated = params.evaluated();
                                LocalVar paramTypes = success.localVar("pt", success.newArray(Class.class, evaluated.stream().map(p -> Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)p.type))).toList()));
                                success.ifNot(success.invokeVirtual(Descriptors.EVALUATED_PARAMS_PARAM_TYPES_MATCH, (Expr)capturedEvaluatedParams, new Expr[]{Const.of((boolean)isVarArgs), paramTypes}), typeMatchFailed -> {
                                    typeMatchFailed.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet, new Expr[]{typeMatchFailed.invokeStatic(Descriptors.NOT_FOUND_FROM_EC, new Expr[]{capturedEvalContext})});
                                    typeMatchFailed.return_();
                                });
                                success.try_(tc -> {
                                    tc.body(tcb -> {
                                        Expr[] args = new Expr[params.size()];
                                        int evalIdx = 0;
                                        int lastIdx = params.size() - 1;
                                        for (int i = 0; i < params.size(); ++i) {
                                            Param param = params.get(i);
                                            if (param.kind == ParamKind.BASE) {
                                                args[i] = capturedBase;
                                                continue;
                                            }
                                            if (param.kind == ParamKind.NAME) {
                                                args[i] = capturedName;
                                                continue;
                                            }
                                            if (param.kind == ParamKind.ATTR) {
                                                args[i] = tcb.invokeInterface(Descriptors.GET_ATTRIBUTE, (Expr)capturedEvalContext, new Expr[]{Const.of((String)param.name)});
                                                continue;
                                            }
                                            if (isVarArgs && i == lastIdx) {
                                                Expr varargsResults;
                                                Type varargsParam = params.get((int)lastIdx).type;
                                                Const componentType = Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)varargsParam.asArrayType().constituent().name()));
                                                args[i] = varargsResults = tcb.invokeVirtual(Descriptors.EVALUATED_PARAMS_GET_VARARGS_RESULTS, (Expr)capturedEvaluatedParams, new Expr[]{Const.of((int)evaluated.size()), componentType});
                                                continue;
                                            }
                                            args[i] = tcb.invokeVirtual(Descriptors.EVALUATED_PARAMS_GET_RESULT, (Expr)capturedEvaluatedParams, new Expr[]{Const.of((int)evalIdx++)});
                                        }
                                        Expr invokeRet = tcb.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)method), args);
                                        tcb.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet, new Expr[]{invokeRet});
                                    });
                                    tc.catch_(Throwable.class, "e", (cb, e) -> cb.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet, new Expr[]{e}));
                                });
                            }, failure -> failure.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet, new Expr[]{throwable}));
                            accept.return_();
                        });
                    });
                    bc.invokeInterface(Descriptors.CF_WHEN_COMPLETE, (Expr)paramsReady, new Expr[]{whenCompleteFun});
                    bc.return_((Expr)ret);
                }
            });
        });
    }

    private void implementAppliesTo(ClassCreator valueResolver, MethodInfo method, String matchName, List<String> matchNames, FieldDesc patternField, Parameters params) {
        valueResolver.method("appliesTo", mc -> {
            mc.returning(Boolean.TYPE);
            ParamVar evalContext = mc.parameter("ec", EvalContext.class);
            boolean matchAny = patternField == null && matchNames.isEmpty() && matchName.equals("*");
            boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
            mc.body(bc -> {
                LocalVar base = bc.localVar("base", bc.invokeInterface(Descriptors.GET_BASE, (Expr)evalContext, new Expr[0]));
                bc.ifNull((Expr)base, baseNull -> baseNull.returnFalse());
                Expr baseClass = bc.invokeVirtual(Descriptors.GET_CLASS, (Expr)base, new Expr[0]);
                Const testClass = Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)ExtensionMethodGenerator.box(params.getFirst((ParamKind)ParamKind.BASE).type)));
                bc.ifNot(bc.invokeVirtual(Descriptors.IS_ASSIGNABLE_FROM, (Expr)testClass, new Expr[]{baseClass}), baseNotAssignable -> baseNotAssignable.returnFalse());
                int evaluatedParamsSize = params.evaluated().size();
                if (!isVarArgs || evaluatedParamsSize > 1) {
                    Expr paramsCount = bc.invokeInterface(Descriptors.COLLECTION_SIZE, bc.invokeInterface(Descriptors.GET_PARAMS, (Expr)evalContext, new Expr[0]), new Expr[0]);
                    if (isVarArgs) {
                        bc.if_(bc.gt((Expr)Const.of((int)(evaluatedParamsSize - 1)), paramsCount), gt -> gt.returnFalse());
                    } else {
                        bc.if_(bc.ne(paramsCount, (Expr)Const.of((int)evaluatedParamsSize)), notEqual -> notEqual.returnFalse());
                    }
                }
                LocalVar name = bc.localVar("name", bc.invokeInterface(Descriptors.GET_NAME, (Expr)evalContext, new Expr[0]));
                if (!matchAny) {
                    if (patternField != null) {
                        InstanceFieldVar pattern = valueResolver.this_().field(patternField);
                        Expr matcher = bc.invokeVirtual(Descriptors.PATTERN_MATCHER, (Expr)pattern, new Expr[]{name});
                        bc.ifNot(bc.invokeVirtual(Descriptors.MATCHER_MATCHES, matcher, new Expr[0]), nameNotMatched -> nameNotMatched.returnFalse());
                    } else if (!matchNames.isEmpty()) {
                        bc.block(nested -> {
                            for (String match : matchNames) {
                                nested.if_(nested.objEquals((Expr)name, (Expr)Const.of((String)match)), namesMatch -> namesMatch.break_(nested));
                            }
                            nested.returnFalse();
                        });
                    } else {
                        bc.ifNot(bc.objEquals((Expr)name, (Expr)Const.of((String)matchName)), nameNotMatched -> nameNotMatched.returnFalse());
                    }
                }
                bc.returnTrue();
            });
        });
    }

    static String sha1(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(value.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder(40);
            for (int i = 0; i < digest.length; ++i) {
                sb.append(Integer.toHexString(digest[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    static Type box(Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return ExtensionMethodGenerator.box(type.asPrimitiveType().primitive());
        }
        return type;
    }

    static Type box(PrimitiveType.Primitive primitive) {
        switch (primitive) {
            case BOOLEAN: {
                return Type.create((DotName)DotNames.BOOLEAN, (Type.Kind)Type.Kind.CLASS);
            }
            case DOUBLE: {
                return Type.create((DotName)DotNames.DOUBLE, (Type.Kind)Type.Kind.CLASS);
            }
            case FLOAT: {
                return Type.create((DotName)DotNames.FLOAT, (Type.Kind)Type.Kind.CLASS);
            }
            case LONG: {
                return Type.create((DotName)DotNames.LONG, (Type.Kind)Type.Kind.CLASS);
            }
            case INT: {
                return Type.create((DotName)DotNames.INTEGER, (Type.Kind)Type.Kind.CLASS);
            }
            case BYTE: {
                return Type.create((DotName)DotNames.BYTE, (Type.Kind)Type.Kind.CLASS);
            }
            case CHAR: {
                return Type.create((DotName)DotNames.CHARACTER, (Type.Kind)Type.Kind.CLASS);
            }
            case SHORT: {
                return Type.create((DotName)DotNames.SHORT, (Type.Kind)Type.Kind.CLASS);
            }
        }
        throw new IllegalArgumentException("Unsupported primitive: " + String.valueOf(primitive));
    }

    public static final class Parameters
    implements Iterable<Param> {
        final List<Param> params;

        public Parameters(MethodInfo method, boolean isNameParameterRequired, boolean hasNamespace) {
            Param nameParam;
            List parameters = method.parameterTypes();
            HashMap<Integer, String> attributeParamNames = new HashMap<Integer, String>();
            for (AnnotationInstance annotation : method.annotations()) {
                String name;
                if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || !annotation.name().equals((Object)TEMPLATE_ATTRIBUTE)) continue;
                AnnotationValue value = annotation.value();
                short position = annotation.target().asMethodParameter().position();
                String string = name = value != null ? value.asString() : method.parameterName((int)position);
                if (name == null) {
                    throw new TemplateException("Parameter names not recorded for " + String.valueOf(method.declaringClass().name()) + ": compile the class with -parameters");
                }
                attributeParamNames.put(Integer.valueOf(position), name);
            }
            ArrayList<Param> params = new ArrayList<Param>(parameters.size());
            int indexed = 0;
            for (int i = 0; i < parameters.size(); ++i) {
                if (attributeParamNames.containsKey(i)) {
                    params.add(new Param((String)attributeParamNames.get(i), (Type)parameters.get(i), i, ParamKind.ATTR));
                    continue;
                }
                if (indexed == 0) {
                    ++indexed;
                    if (hasNamespace) {
                        if (isNameParameterRequired) {
                            params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.NAME));
                            continue;
                        }
                        params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.EVAL));
                        continue;
                    }
                    params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.BASE));
                    continue;
                }
                if (indexed == 1 && !hasNamespace && isNameParameterRequired) {
                    ++indexed;
                    params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.NAME));
                    continue;
                }
                ++indexed;
                params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.EVAL));
            }
            this.params = params;
            if (isNameParameterRequired && ((nameParam = this.getFirst(ParamKind.NAME)) == null || !nameParam.type.name().equals((Object)DotNames.STRING))) {
                throw new TemplateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + " must accept at least one string parameter to match the name: " + String.valueOf(method));
            }
            if (!hasNamespace && this.getFirst(ParamKind.BASE) == null) {
                throw new TemplateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + " must accept at least one parameter to match the base object: " + String.valueOf(method));
            }
            for (Param param : params) {
                if (param.kind != ParamKind.ATTR || param.type.name().equals((Object)DotNames.OBJECT)) continue;
                throw new TemplateException("Template extension method parameter annotated with @TemplateAttribute declared on " + String.valueOf(method.declaringClass().name()) + " must be of type java.lang.Object: " + String.valueOf(method));
            }
        }

        public String[] parameterTypesAsStringArray() {
            String[] types = new String[this.params.size()];
            for (int i = 0; i < this.params.size(); ++i) {
                types[i] = this.params.get((int)i).type.name().toString();
            }
            return types;
        }

        public Param getFirst(ParamKind kind) {
            for (Param param : this.params) {
                if (param.kind != kind) continue;
                return param;
            }
            return null;
        }

        public Param get(int index) {
            return this.params.get(index);
        }

        public int size() {
            return this.params.size();
        }

        public boolean needsEvaluation() {
            for (Param param : this.params) {
                if (param.kind != ParamKind.EVAL) continue;
                return true;
            }
            return false;
        }

        public List<Param> evaluated() {
            if (this.params.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Param> evaluated = new ArrayList<Param>();
            for (Param param : this.params) {
                if (param.kind != ParamKind.EVAL) continue;
                evaluated.add(param);
            }
            return evaluated;
        }

        @Override
        public Iterator<Param> iterator() {
            return this.params.iterator();
        }
    }

    static enum ParamKind {
        BASE,
        NAME,
        ATTR,
        EVAL;

    }

    public static final class Param {
        public final String name;
        public final Type type;
        public final int position;
        public final ParamKind kind;

        public Param(String name, Type type, int position, ParamKind paramKind) {
            this.name = name;
            this.type = type;
            this.position = position;
            this.kind = paramKind;
        }

        public String toString() {
            return "Param [name=" + this.name + ", type=" + String.valueOf(this.type) + ", position=" + this.position + ", kind=" + String.valueOf((Object)this.kind) + "]";
        }
    }

    public record ExtensionMethodInfo(MethodInfo method, String matchName, List<String> matchNames, String matchRegex) {
    }
}

