/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment.visitors;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.panache.common.deployment.ByteCodeType;
import io.quarkus.panache.common.deployment.PanacheConstants;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.TypeBundle;
import io.smallrye.common.annotation.SuppressForbidden;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class KotlinPanacheClassOperationGenerationVisitor
extends ClassVisitor {
    public static final String NOT_NULL_DESCRIPTOR = "Lorg/jetbrains/annotations/NotNull;";
    public static final String NULLABLE_DESCRIPTOR = "Lorg/jetbrains/annotations/Nullable;";
    public static final ByteCodeType OBJECT = new ByteCodeType(Object.class);
    protected static final ByteCodeType CLASS = new ByteCodeType(Class.class);
    private static final String CTOR_METHOD_NAME = "<init>";
    private static final String CLINIT_METHOD_NAME = "<clinit>";
    protected final Function<String, Type> argMapper;
    protected final ClassInfo classInfo;
    protected final ByteCodeType entityUpperBound;
    protected final Map<String, ByteCodeType> typeArguments = new HashMap<String, ByteCodeType>();
    private final ByteCodeType baseType;
    private final Set<String> userMethods = new HashSet<String>();
    private final Set<String> baseTypeMethods = new HashSet<String>();
    private final Map<String, String> erasures = new HashMap<String, String>();
    private final IndexView indexView;
    protected List<PanacheMethodCustomizer> methodCustomizers;
    protected TypeBundle typeBundle;
    private final List<Label> labels = new ArrayList<Label>();

    public KotlinPanacheClassOperationGenerationVisitor(ClassVisitor outputClassVisitor, ClassInfo classInfo, IndexView indexView, TypeBundle typeBundle, ByteCodeType baseType, List<PanacheMethodCustomizer> methodCustomizers) {
        super(589824, outputClassVisitor);
        this.classInfo = classInfo;
        this.indexView = indexView;
        this.typeBundle = typeBundle;
        this.baseType = baseType;
        this.methodCustomizers = methodCustomizers;
        List typeVariables = indexView.getClassByName(baseType.dotName()).typeParameters();
        this.entityUpperBound = !typeVariables.isEmpty() ? new ByteCodeType((Type)((TypeVariable)typeVariables.get(0)).bounds().get(0)) : OBJECT;
        this.discoverTypeParameters(classInfo, indexView, typeBundle, baseType);
        this.argMapper = type -> {
            ByteCodeType byteCodeType = this.typeArguments.get(type);
            return byteCodeType != null ? byteCodeType.get() : null;
        };
        this.loadBaseTypeMethods();
    }

    private void loadBaseTypeMethods() {
        for (MethodInfo method : this.indexView.getClassByName(this.baseType.dotName()).methods()) {
            String descriptor = method.descriptor(type -> this.typeArguments.getOrDefault(type, OBJECT).get());
            AnnotationInstance bridge = method.annotation(PanacheConstants.DOTNAME_GENERATE_BRIDGE);
            if (bridge == null) continue;
            this.baseTypeMethods.add(method.name() + "/" + descriptor);
        }
    }

    public static List<ByteCodeType> recursivelyFindEntityTypeArguments(IndexView indexView, DotName clazz, DotName repositoryDotName) {
        if (clazz.equals((Object)JandexUtil.DOTNAME_OBJECT)) {
            return Collections.emptyList();
        }
        return JandexUtil.resolveTypeParameters((DotName)clazz, (DotName)repositoryDotName, (IndexView)indexView).stream().map(t -> new ByteCodeType((Type)t)).collect(Collectors.toList());
    }

    private Label addLabel() {
        Label label = new Label();
        this.labels.add(label);
        return label;
    }

    protected void addNullityChecks(MethodVisitor mv, MethodInfo method) {
        int index = 1;
        for (Type methodParameter : method.parameterTypes()) {
            org.objectweb.asm.Type parameter = this.asmType(methodParameter);
            if (this.isNotPrimitiveId(methodParameter)) {
                mv.visitVarInsn(parameter.getOpcode(21), index);
                String value = method.parameterName(index);
                mv.visitLdcInsn(value != null ? value : "arg" + (index - 1));
                mv.visitMethodInsn(184, "kotlin/jvm/internal/Intrinsics", "checkNotNullParameter", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
            }
            index += parameter.getSize();
        }
    }

    private void loadArguments(MethodVisitor mv, MethodInfo method) {
        mv.visitLdcInsn((Object)this.typeArguments.get("Entity").type());
        int index = 1;
        for (Type methodParameter : method.parameterTypes()) {
            org.objectweb.asm.Type parameter = this.asmType(methodParameter);
            mv.visitVarInsn(parameter.getOpcode(21), index);
            if (parameter.getSort() < 9) {
                org.objectweb.asm.Type wrapper = AsmUtil.autobox((org.objectweb.asm.Type)parameter);
                mv.visitMethodInsn(184, wrapper.getInternalName(), "valueOf", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)wrapper, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{parameter}), false);
            } else if (parameter.getSort() == 9) {
                mv.visitInsn(89);
                mv.visitInsn(190);
                mv.visitMethodInsn(184, "java/util/Arrays", "copyOf", "([Ljava/lang/Object;I)[Ljava/lang/Object;", false);
            }
            index += parameter.getSize();
        }
    }

    private void annotateParamsWithNotNull(MethodVisitor mv, MethodInfo method) {
        List parameters = method.parameterTypes();
        if (parameters.size() != 0) {
            mv.visitAnnotableParameterCount(parameters.size(), false);
            for (int i = 0; i < parameters.size(); ++i) {
                if (!this.isNotPrimitiveId(method.parameterType(i))) continue;
                mv.visitParameterAnnotation(i, NOT_NULL_DESCRIPTOR, false);
            }
        }
    }

    private boolean isNotPrimitiveId(Type type) {
        boolean primitive = true;
        if (type instanceof TypeVariable && ((TypeVariable)type).identifier().equals("Id")) {
            String identifier = ((TypeVariable)type).identifier();
            ByteCodeType idType = this.typeArguments.get(identifier);
            primitive = idType.descriptor().length() != 1;
        }
        return primitive;
    }

    protected String bridgeMethodDescriptor(MethodInfo method, Function<String, Type> mapper) {
        AnnotationValue value;
        StringJoiner joiner = new StringJoiner("", "(", ")");
        this.descriptors(method, joiner);
        AnnotationInstance annotation = method.annotation(PanacheConstants.DOTNAME_GENERATE_BRIDGE);
        boolean erased = annotation != null ? (value = annotation.value("targetReturnTypeErased")) != null && value.asBoolean() : false;
        String returnType = erased ? this.entityUpperBound.descriptor() : method.returnType().descriptor(mapper);
        return String.valueOf(joiner) + returnType;
    }

    private void checkCast(MethodVisitor mv, Type returnType, String operationReturnType) {
        String cast;
        if (returnType.kind() == Type.Kind.TYPE_VARIABLE) {
            ByteCodeType type = this.typeArguments.getOrDefault(returnType.asTypeVariable().identifier(), this.entityUpperBound);
            cast = type.internalName();
        } else {
            cast = returnType.name().toString().replace('.', '/');
        }
        if (!cast.equals(operationReturnType)) {
            mv.visitTypeInsn(192, cast);
        }
    }

    private String desc(String name) {
        String s = name.replace(".", "/");
        return s.startsWith("[") ? s : "L" + s + ";";
    }

    private void descriptors(MethodInfo method, StringJoiner joiner) {
        ByteCodeType id = this.typeArguments.get("Id");
        for (Type parameter : method.parameterTypes()) {
            if (!id.isPrimitive() && parameter.name().equals((Object)id.dotName())) {
                joiner.add(OBJECT.descriptor());
                continue;
            }
            joiner.add(this.mapType(parameter));
        }
    }

    protected void discoverTypeParameters(ClassInfo classInfo, IndexView indexView, TypeBundle types, ByteCodeType baseType) {
        List<ByteCodeType> foundTypeArguments = KotlinPanacheClassOperationGenerationVisitor.recursivelyFindEntityTypeArguments(indexView, classInfo.name(), baseType.dotName());
        ByteCodeType entityType = foundTypeArguments.size() > 0 ? foundTypeArguments.get(0) : OBJECT;
        ByteCodeType idType = foundTypeArguments.size() > 1 ? foundTypeArguments.get(1).unbox() : OBJECT;
        this.typeArguments.put("Entity", entityType);
        this.typeArguments.put("Id", idType);
        this.typeArguments.keySet().stream().filter(k -> !k.equals("Id")).forEach(k -> this.erasures.put((String)k, OBJECT.descriptor()));
        try {
            this.erasures.put(this.typeArguments.get("Entity").dotName().toString(), this.entityUpperBound.descriptor());
            this.erasures.put(types.queryType().dotName().toString(), OBJECT.descriptor());
            this.erasures.put(types.updateType().dotName().toString(), OBJECT.descriptor());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void emitNullCheck(MethodVisitor mv, String operationDescriptor) {
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)this.elideDescriptor(operationDescriptor));
        mv.visitMethodInsn(184, "kotlin/jvm/internal/Intrinsics", "checkNotNullExpressionValue", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
    }

    @SuppressForbidden(reason="Using Type#toString() is what we want here")
    private void emitNullCheck(MethodVisitor mv, Type returnType) {
        Label label = this.addLabel();
        mv.visitInsn(89);
        mv.visitJumpInsn(199, label);
        mv.visitTypeInsn(187, "java/lang/NullPointerException");
        mv.visitInsn(89);
        ParameterizedType parameterizedType = ParameterizedType.create((DotName)returnType.name(), (Type[])new Type[]{Type.create((DotName)this.typeArguments.get("Entity").dotName(), (Type.Kind)Type.Kind.CLASS)}, null);
        mv.visitLdcInsn((Object)("null cannot be cast to non-null type " + parameterizedType.toString().replace("java.util.List", "kotlin.collections.List")));
        mv.visitMethodInsn(183, "java/lang/NullPointerException", CTOR_METHOD_NAME, "(Ljava/lang/String;)V", false);
        mv.visitInsn(191);
        mv.visitLabel(label);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Object"});
    }

    private String elideDescriptor(String descriptor) {
        if (descriptor.length() > 55) {
            return descriptor.substring(0, 24) + "\u2026" + descriptor.substring(descriptor.length() - 24);
        }
        return descriptor;
    }

    private Label endLabel() {
        return this.labels.get(this.labels.size() - 1);
    }

    private void generate(MethodInfo method) {
        MethodVisitor mv = this.cv.visitMethod(1, method.name(), method.descriptor(this.argMapper), method.genericSignature(this.argMapper), null);
        AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
        for (PanacheMethodCustomizer customizer : this.methodCustomizers) {
            org.objectweb.asm.Type thisClass = org.objectweb.asm.Type.getType((String)("L" + this.classInfo.name().toString().replace('.', '/') + ";"));
            customizer.customize(thisClass, method, mv);
        }
        this.annotateParamsWithNotNull(mv, method);
        mv.visitCode();
        this.addNullityChecks(mv, method);
        this.loadOperationsReference(mv);
        this.loadArguments(mv, method);
        this.invokeOperation(mv, method);
        this.emitLocalVariablesTable(mv, method);
        mv.visitMaxs(0, 0);
    }

    private void emitLocalVariablesTable(MethodVisitor mv, MethodInfo method) {
        mv.visitLabel(this.addLabel());
        mv.visitLocalVariable("this", this.desc(this.classInfo.name().toString()), null, this.startLabel(), this.endLabel(), 0);
        for (int i = 0; i < method.parametersCount(); ++i) {
            Type type = method.parameterType(i);
            String typeName = type instanceof TypeVariable ? this.typeArguments.get(((TypeVariable)type).identifier()).descriptor() : this.desc(type.name().toString());
            String parameterName = method.parameterName(i);
            mv.visitLocalVariable(parameterName != null ? parameterName : "arg1", typeName, null, this.startLabel(), this.endLabel(), i + 1);
        }
    }

    private void generateBridge(MethodInfo method, String descriptor) {
        MethodVisitor mv = this.cv.visitMethod(4161, method.name(), descriptor, null, null);
        List parameters = method.parameterTypes();
        AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
        mv.visitCode();
        mv.visitIntInsn(25, 0);
        for (int i = 0; i < parameters.size(); ++i) {
            Type paramType = (Type)parameters.get(i);
            if (paramType.kind() == Type.Kind.PRIMITIVE) {
                throw new IllegalStateException("BUG: Don't know how to generate JVM bridge method for " + String.valueOf(method) + ": has primitive parameters");
            }
            mv.visitIntInsn(AsmUtil.getLoadOpcode((Type)paramType), i + 1);
            if (paramType.kind() != Type.Kind.TYPE_VARIABLE) continue;
            String typeParamName = paramType.asTypeVariable().identifier();
            org.objectweb.asm.Type type = org.objectweb.asm.Type.getType((String)this.typeArguments.get(typeParamName).descriptor());
            if (type.getSort() > 8) {
                mv.visitTypeInsn(192, type.getInternalName());
                continue;
            }
            AsmUtil.unboxIfRequired((MethodVisitor)mv, (org.objectweb.asm.Type)type);
        }
        String targetDescriptor = method.descriptor(name -> this.typeArguments.get(name).get());
        mv.visitMethodInsn(182, this.classInfo.name().toString().replace('.', '/'), method.name(), targetDescriptor, false);
        String targetReturnTypeDescriptor = targetDescriptor.substring(targetDescriptor.indexOf(41) + 1);
        mv.visitInsn(AsmUtil.getReturnInstruction((String)targetReturnTypeDescriptor));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generatePrimitiveBridge(MethodInfo method, String descriptor) {
        String substring = descriptor.substring(0, descriptor.lastIndexOf(41) + 1);
        String descriptor1 = substring + OBJECT.descriptor();
        MethodVisitor mv = this.cv.visitMethod(4161, method.name(), descriptor1, null, null);
        AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
        mv.visitCode();
        mv.visitIntInsn(25, 0);
        mv.visitIntInsn(this.typeArguments.get("Id").type().getOpcode(21), 1);
        String targetDescriptor = method.descriptor(name -> this.typeArguments.get(name).get());
        mv.visitMethodInsn(182, this.classInfo.name().toString().replace('.', '/'), method.name(), targetDescriptor, false);
        String targetReturnTypeDescriptor = targetDescriptor.substring(targetDescriptor.indexOf(41) + 1);
        mv.visitInsn(AsmUtil.getReturnInstruction((String)targetReturnTypeDescriptor));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void invokeOperation(MethodVisitor mv, MethodInfo method) {
        StringJoiner joiner = new StringJoiner("", "(", ")");
        joiner.add(CLASS.descriptor());
        for (Type parameter : method.parameterTypes()) {
            joiner.add(parameter.kind() == Type.Kind.TYPE_VARIABLE ? OBJECT.descriptor() : parameter.descriptor(this.argMapper));
        }
        Type returnType = method.returnType();
        String descriptor = returnType.descriptor(this.argMapper);
        String key = returnType.kind() == Type.Kind.TYPE_VARIABLE ? returnType.asTypeVariable().identifier() : returnType.name().toString();
        String operationReturnType = this.erasures.getOrDefault(key, descriptor);
        String operationDescriptor = String.valueOf(joiner) + operationReturnType;
        mv.visitMethodInsn(182, this.typeBundle.operations().internalName(), method.name(), operationDescriptor, false);
        if (returnType.kind() != Type.Kind.PRIMITIVE && returnType.kind() != Type.Kind.VOID) {
            String retType = operationReturnType.substring(1, operationReturnType.length() - 1);
            String annotationDesc = NOT_NULL_DESCRIPTOR;
            if ("findById".equals(method.name())) {
                annotationDesc = NULLABLE_DESCRIPTOR;
            } else {
                this.nullCheckReturn(mv, returnType, this.typeBundle.operations().dotName().withoutPackagePrefix() + ".INSTANCE." + method.name() + String.valueOf(joiner));
            }
            this.checkCast(mv, returnType, retType);
            mv.visitAnnotation(annotationDesc, false);
        }
        mv.visitInsn(AsmUtil.getReturnInstruction((Type)returnType));
    }

    private org.objectweb.asm.Type asmType(Type methodParameter) {
        org.objectweb.asm.Type parameter = methodParameter.kind() == Type.Kind.TYPE_VARIABLE ? this.typeArguments.get(methodParameter.asTypeVariable().identifier()).type() : org.objectweb.asm.Type.getType((String)methodParameter.descriptor());
        return parameter;
    }

    protected void loadOperationsReference(MethodVisitor mv) {
        mv.visitLabel(this.addLabel());
        mv.visitFieldInsn(178, this.typeBundle.operations().internalName(), "INSTANCE", this.typeBundle.operations().descriptor());
    }

    private String mapType(Type parameter) {
        switch (parameter.kind()) {
            case PRIMITIVE: 
            case TYPE_VARIABLE: {
                return OBJECT.descriptor();
            }
        }
        String value = parameter.descriptor(this.argMapper);
        return this.erasures.getOrDefault(value, value);
    }

    private boolean needsJvmBridge(MethodInfo method) {
        if (this.needsJvmBridge(method.returnType())) {
            return true;
        }
        for (Type paramType : method.parameterTypes()) {
            if (!this.needsJvmBridge(paramType)) continue;
            return true;
        }
        return false;
    }

    private boolean needsJvmBridge(Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            String typeParamName = type.asTypeVariable().identifier();
            return this.typeArguments.containsKey(typeParamName);
        }
        return false;
    }

    private void nullCheckReturn(MethodVisitor mv, Type returnType, String operationDescriptor) {
        if (returnType instanceof ParameterizedType) {
            this.emitNullCheck(mv, returnType);
        } else if (returnType instanceof ClassType) {
            this.emitNullCheck(mv, operationDescriptor);
        }
    }

    private Label startLabel() {
        return this.labels.get(0);
    }

    public String toString() {
        return new StringJoiner(", ", ((Object)((Object)this)).getClass().getSimpleName() + "[", "]").add(this.classInfo.name().toString()).toString();
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        String sig = name + "/" + descriptor;
        if ((access & 0x40) != 0 && this.baseTypeMethods.contains(sig)) {
            return null;
        }
        this.userMethods.add(sig);
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    public void visitEnd() {
        for (MethodInfo method : this.indexView.getClassByName(this.baseType.dotName()).methods()) {
            String descriptor = method.descriptor(type -> this.typeArguments.getOrDefault(type, OBJECT).get());
            AnnotationInstance bridge = method.annotation(PanacheConstants.DOTNAME_GENERATE_BRIDGE);
            if (this.userMethods.contains(method.name() + "/" + descriptor) || bridge == null) continue;
            this.generate(method);
            if (!this.needsJvmBridge(method)) continue;
            String bridgeDescriptor = this.bridgeMethodDescriptor(method, type -> {
                ByteCodeType mapped = this.typeArguments.get(type);
                return mapped != null ? mapped.get() : null;
            });
            if (!this.userMethods.contains(method.name() + "/" + bridgeDescriptor)) {
                this.generateBridge(method, bridgeDescriptor);
            }
            AnnotationValue targetReturnTypeErased = bridge.value("targetReturnTypeErased");
            if (!this.typeArguments.get("Id").isPrimitive() || targetReturnTypeErased == null || !targetReturnTypeErased.asBoolean() || method.parametersCount() != 1 || !method.parameterType(0).asTypeVariable().identifier().equals("Id")) continue;
            this.generatePrimitiveBridge(method, descriptor);
        }
        super.visitEnd();
    }
}

