/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime.dev.ui;

import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseFactoryUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.function.Supplier;

public class LiquibaseFactoriesSupplier
implements Supplier<Collection<LiquibaseFactory>> {
    @Override
    public Collection<LiquibaseFactory> get() {
        TreeSet<LiquibaseFactory> containers = new TreeSet<LiquibaseFactory>(LiquibaseFactoryComparator.INSTANCE);
        for (InstanceHandle<LiquibaseFactory> handle : LiquibaseFactoryUtil.getActiveLiquibaseFactories()) {
            containers.add((LiquibaseFactory)handle.get());
        }
        return containers;
    }

    private static class LiquibaseFactoryComparator
    implements Comparator<LiquibaseFactory> {
        private static final LiquibaseFactoryComparator INSTANCE = new LiquibaseFactoryComparator();

        private LiquibaseFactoryComparator() {
        }

        @Override
        public int compare(LiquibaseFactory o1, LiquibaseFactory o2) {
            String dataSourceName1 = o1.getDataSourceName();
            String dataSourceName2 = o2.getDataSourceName();
            if (DataSourceUtil.isDefault((String)dataSourceName1)) {
                return -1;
            }
            if (DataSourceUtil.isDefault((String)dataSourceName2)) {
                return 1;
            }
            return dataSourceName1.compareTo(dataSourceName2);
        }
    }
}

