/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.websocket.deployment;

import io.quarkiverse.mcp.server.InitialCheck;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.NotificationManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.ToolManagerImpl;
import io.quarkiverse.mcp.server.runtime.config.McpServersRuntimeConfig;
import io.quarkiverse.mcp.server.websocket.runtime.WebSocketMcpMessageHandler;
import io.quarkiverse.mcp.server.websocket.runtime.config.McpWebSocketServerBuildTimeConfig;
import io.quarkiverse.mcp.server.websocket.runtime.config.McpWebSocketServersBuildTimeConfig;
import io.quarkus.arc.All;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.SignatureBuilder;
import io.quarkus.gizmo.Type;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.websockets.next.WebSocket;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Instance;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;

public class WebSocketMcpServerProcessor {
    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("mcp-server-websocket");
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem dummyEndpoint() {
        return new AdditionalIndexedClassesBuildItem("io.quarkiverse.mcp.server.websocket.runtime.DummyEndpoint");
    }

    @BuildStep
    void generateEndpoints(McpWebSocketServersBuildTimeConfig config, BuildProducer<GeneratedBeanBuildItem> generatedBeans) {
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(generatedBeans, name -> false);
        for (Map.Entry e : config.servers().entrySet()) {
            String endpointClassName = "io.quarkiverse.mcp.server.websocket.runtime.Endpoint" + HashUtil.sha1((String)((String)e.getKey()));
            ClassCreator endpointCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(endpointClassName).superClass(WebSocketMcpMessageHandler.class).build();
            endpointCreator.addAnnotation(AnnotationInstance.builder(WebSocket.class).add("path", ((McpWebSocketServerBuildTimeConfig)e.getValue()).websocket().endpointPath()).build());
            Class[] params = new Class[]{McpServersRuntimeConfig.class, ConnectionManager.class, PromptManagerImpl.class, ToolManagerImpl.class, ResourceManagerImpl.class, PromptCompletionManagerImpl.class, ResourceTemplateManagerImpl.class, ResourceTemplateCompletionManagerImpl.class, NotificationManagerImpl.class, ResponseHandlers.class, McpMetadata.class, Vertx.class, List.class, Instance.class};
            MethodCreator constructor = endpointCreator.getConstructorCreator(params);
            constructor.setSignature(SignatureBuilder.forMethod().addParameterType((Type)Type.classType(McpServersRuntimeConfig.class)).addParameterType((Type)Type.classType(ConnectionManager.class)).addParameterType((Type)Type.classType(PromptManagerImpl.class)).addParameterType((Type)Type.classType(ToolManagerImpl.class)).addParameterType((Type)Type.classType(ResourceManagerImpl.class)).addParameterType((Type)Type.classType(PromptCompletionManagerImpl.class)).addParameterType((Type)Type.classType(ResourceTemplateManagerImpl.class)).addParameterType((Type)Type.classType(ResourceTemplateCompletionManagerImpl.class)).addParameterType((Type)Type.classType(NotificationManagerImpl.class)).addParameterType((Type)Type.classType(ResponseHandlers.class)).addParameterType((Type)Type.classType(McpMetadata.class)).addParameterType((Type)Type.classType(Vertx.class)).addParameterType((Type)Type.parameterizedType((Type.ClassType)Type.classType(List.class), (Type[])new Type[]{Type.classType(InitialCheck.class)})).addParameterType((Type)Type.parameterizedType((Type.ClassType)Type.classType(Instance.class), (Type[])new Type[]{Type.classType(CurrentIdentityAssociation.class)})).build());
            constructor.getParameterAnnotations(12).addAnnotation(All.class);
            constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(WebSocketMcpMessageHandler.class, (Class[])params), constructor.getThis(), new ResultHandle[]{constructor.getMethodParam(0), constructor.getMethodParam(1), constructor.getMethodParam(2), constructor.getMethodParam(3), constructor.getMethodParam(4), constructor.getMethodParam(5), constructor.getMethodParam(6), constructor.getMethodParam(7), constructor.getMethodParam(8), constructor.getMethodParam(9), constructor.getMethodParam(10), constructor.getMethodParam(11), constructor.getMethodParam(12), constructor.getMethodParam(13)});
            constructor.returnVoid();
            MethodCreator serverName = endpointCreator.getMethodCreator("serverName", String.class, new Class[0]);
            serverName.returnValue(serverName.load((String)e.getKey()));
            endpointCreator.close();
        }
    }
}

