/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.sse.runtime;

import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.config.McpServerRuntimeConfig;
import io.quarkiverse.mcp.server.runtime.config.McpServersRuntimeConfig;
import io.quarkiverse.mcp.server.sse.runtime.SseMcpConnection;
import io.quarkiverse.mcp.server.sse.runtime.SseMcpMessageHandler;
import io.quarkiverse.mcp.server.sse.runtime.StreamableHttpMcpConnection;
import io.quarkiverse.mcp.server.sse.runtime.StreamableHttpMcpMessageHandler;
import io.quarkiverse.mcp.server.sse.runtime.config.McpSseServersBuildTimeConfig;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

@Recorder
public class SseMcpServerRecorder {
    private static final Logger LOG = Logger.getLogger(SseMcpServerRecorder.class);
    static final String CONTEXT_KEY = "mcp.sse.server-name";
    private final RuntimeValue<McpServersRuntimeConfig> config;
    private final McpSseServersBuildTimeConfig sseConfig;

    public SseMcpServerRecorder(RuntimeValue<McpServersRuntimeConfig> config, McpSseServersBuildTimeConfig sseConfig) {
        this.config = config;
        this.sseConfig = sseConfig;
    }

    public Handler<RoutingContext> createMcpEndpointHandler(final String serverName) {
        ArcContainer container = Arc.container();
        final ConnectionManager connectionManager = (ConnectionManager)container.instance(ConnectionManager.class, new Annotation[0]).get();
        final StreamableHttpMcpMessageHandler handler = (StreamableHttpMcpMessageHandler)((Object)container.instance(StreamableHttpMcpMessageHandler.class, new Annotation[0]).get());
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                ctx.put(SseMcpServerRecorder.CONTEXT_KEY, (Object)serverName);
                HttpMethod method = ctx.request().method();
                if (HttpMethod.GET.equals((Object)method)) {
                    SseMcpServerRecorder.this.openSseStream(ctx, connectionManager);
                } else if (HttpMethod.POST.equals((Object)method)) {
                    handler.handle(ctx);
                } else if (HttpMethod.DELETE.equals((Object)method)) {
                    handler.terminateSession(ctx);
                } else {
                    throw new IllegalArgumentException("Unexpected HTTP method: " + String.valueOf(method));
                }
            }
        };
    }

    private void openSseStream(RoutingContext ctx, ConnectionManager connectionManager) {
        HttpServerRequest request = ctx.request();
        String mcpSessionId = request.getHeader("Mcp-Session-Id");
        if (mcpSessionId == null) {
            LOG.errorf("%s header not found", (Object)"Mcp-Session-Id");
            ctx.fail(405);
            return;
        }
        McpConnectionBase connection = connectionManager.get(mcpSessionId);
        if (connection == null) {
            LOG.errorf("Mcp session not found: %s", (Object)mcpSessionId);
            ctx.fail(404);
            return;
        }
        HttpServerResponse response = ctx.response();
        response.setChunked(true);
        response.headers().add(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/event-stream");
        StreamableHttpMcpConnection streamableConnection = (StreamableHttpMcpConnection)connection;
        StreamableHttpMcpConnection.SubsidiarySse sse = new StreamableHttpMcpConnection.SubsidiarySse(ConnectionManager.connectionId(), response);
        streamableConnection.addSse(sse);
        JsonObject log = Messages.newNotification((String)"notifications/message", (Object)Messages.newLog((McpLog.LogLevel)McpLog.LogLevel.DEBUG, (String)"SubsidiarySse", (Object)"Subsidiary SSE opened [%s]".formatted(connection.id())));
        if (connection.trafficLogger() != null) {
            connection.trafficLogger().messageSent(log, (McpConnection)connection);
        }
        sse.sendEvent("message", log.encode());
        this.setCloseHandler(request, () -> {
            if (streamableConnection.removeSse(sse.id())) {
                LOG.debugf("Subsidiary SSE [%s] stream closed [%s]", (Object)sse.id(), (Object)connection.id());
            }
        }, "subsidiary SSE will be closed upon session termination".formatted(connection.id()));
        LOG.debugf("Subsidiary SSE stream [%s] initialized [%s]", (Object)sse.id(), (Object)connection.id());
    }

    public Handler<RoutingContext> createSseEndpointHandler(final String mcpPath, final String serverName) {
        final McpServerRuntimeConfig serverConfig = (McpServerRuntimeConfig)((McpServersRuntimeConfig)this.config.getValue()).servers().get(serverName);
        ArcContainer container = Arc.container();
        final ConnectionManager connectionManager = (ConnectionManager)container.instance(ConnectionManager.class, new Annotation[0]).get();
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                MultiMap queryParams;
                if (HttpMethod.POST.equals((Object)ctx.request().method())) {
                    ctx.fail(405);
                    return;
                }
                ctx.put(SseMcpServerRecorder.CONTEXT_KEY, (Object)serverName);
                HttpServerResponse response = ctx.response();
                response.setChunked(true);
                response.headers().add(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/event-stream");
                String id = ConnectionManager.connectionId();
                LOG.debugf("SSE connection initialized [%s]", (Object)id);
                SseMcpConnection connection = new SseMcpConnection(id, serverConfig, response);
                connectionManager.add((McpConnectionBase)connection);
                SseMcpServerRecorder.this.setCloseHandler(ctx.request(), id, connectionManager);
                StringBuilder endpointPath = new StringBuilder(mcpPath);
                if (!mcpPath.endsWith("/")) {
                    endpointPath.append("/");
                }
                endpointPath.append("messages/").append(id);
                if (SseMcpServerRecorder.this.sseConfig.servers().get(serverName).sse().messageEndpoint().includeQueryParams() && !(queryParams = ctx.queryParams()).isEmpty()) {
                    endpointPath.append("?");
                    Iterator it = queryParams.iterator();
                    while (it.hasNext()) {
                        Map.Entry e = (Map.Entry)it.next();
                        endpointPath.append((String)e.getKey()).append("=").append(URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8));
                        if (!it.hasNext()) continue;
                        endpointPath.append("&");
                    }
                }
                String endpoint = endpointPath.toString();
                LOG.debugf("POST endpoint path: %s", (Object)endpoint);
                connection.sendEvent("endpoint", endpoint);
            }
        };
    }

    private void setCloseHandler(HttpServerRequest request, String connectionId, ConnectionManager connectionManager) {
        this.setCloseHandler(request, () -> {
            if (connectionManager.remove(connectionId)) {
                LOG.debugf("Connection %s closed", (Object)connectionId);
            }
        }, "client should close the connection [%s] explicitly".formatted(connectionId));
    }

    private void setCloseHandler(HttpServerRequest request, final Runnable closeAction, String errorMessage) {
        HttpConnection connection = request.connection();
        if (connection instanceof ConnectionBase) {
            ConnectionBase base = (ConnectionBase)connection;
            try {
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(ConnectionBase.class, MethodHandles.lookup());
                VarHandle varHandle = lookup.findVarHandle(ConnectionBase.class, "closeHandler", Handler.class);
                final Handler closeHandler = varHandle.get(base);
                base.closeHandler((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        if (closeHandler != null) {
                            closeHandler.handle((Object)event);
                        }
                        closeAction.run();
                    }
                });
            }
            catch (Exception e) {
                LOG.warnf((Throwable)e, "Unable to set close handler - %s", (Object)errorMessage);
            }
        } else {
            LOG.warnf("Unable to set close handler - %s", (Object)errorMessage);
        }
    }

    public Consumer<Route> addBodyHandler(final Handler<RoutingContext> bodyHandler) {
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                route.handler(bodyHandler);
            }
        };
    }

    public Handler<RoutingContext> createMessagesEndpointHandler(final String serverName) {
        final SseMcpMessageHandler handler = (SseMcpMessageHandler)((Object)Arc.container().instance(SseMcpMessageHandler.class, new Annotation[0]).get());
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                ctx.put(SseMcpServerRecorder.CONTEXT_KEY, (Object)serverName);
                handler.handle(ctx);
            }
        };
    }

    public static void logEndpoints(List<McpServerEndpoints> endpoints, HttpServerOptions httpServerOptions) {
        Logger log = Logger.getLogger((String)"io.quarkiverse.mcp.server");
        String base = (httpServerOptions.isSsl() ? "https://" : "http://") + httpServerOptions.getHost() + ":" + httpServerOptions.getPort();
        for (McpServerEndpoints e : endpoints) {
            Object serverInfo = "";
            if (!"<default>".equals(e.serverName)) {
                serverInfo = " [" + e.serverName + "]";
            }
            log.infof("MCP%s HTTP transport endpoints [streamable: %s, SSE: %s]", serverInfo, (Object)(base + e.mcpPath), (Object)(base + e.ssePath));
        }
    }

    public static class McpServerEndpoints {
        public String serverName;
        public String mcpPath;
        public String ssePath;

        public McpServerEndpoints(String serverName, String mcpPath, String ssePath) {
            this.serverName = serverName;
            this.mcpPath = mcpPath;
            this.ssePath = ssePath;
        }
    }
}

