/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.common;

import dev.langchain4j.model.openai.internal.AsyncResponseHandling;
import dev.langchain4j.model.openai.internal.ErrorHandling;
import dev.langchain4j.model.openai.internal.OpenAiClient;
import dev.langchain4j.model.openai.internal.ResponseHandle;
import dev.langchain4j.model.openai.internal.StreamingCompletionHandling;
import dev.langchain4j.model.openai.internal.StreamingResponseHandling;
import dev.langchain4j.model.openai.internal.SyncOrAsync;
import dev.langchain4j.model.openai.internal.SyncOrAsyncOrStreaming;
import dev.langchain4j.model.openai.internal.chat.ChatCompletionRequest;
import dev.langchain4j.model.openai.internal.chat.ChatCompletionResponse;
import dev.langchain4j.model.openai.internal.completion.CompletionRequest;
import dev.langchain4j.model.openai.internal.completion.CompletionResponse;
import dev.langchain4j.model.openai.internal.embedding.EmbeddingRequest;
import dev.langchain4j.model.openai.internal.embedding.EmbeddingResponse;
import dev.langchain4j.model.openai.internal.image.GenerateImagesRequest;
import dev.langchain4j.model.openai.internal.image.GenerateImagesResponse;
import dev.langchain4j.model.openai.internal.moderation.ModerationRequest;
import dev.langchain4j.model.openai.internal.moderation.ModerationResponse;
import dev.langchain4j.model.openai.internal.spi.OpenAiClientBuilderFactory;
import io.quarkiverse.langchain4j.auth.ModelAuthProvider;
import io.quarkiverse.langchain4j.openai.common.OpenAiRestApi;
import io.quarkiverse.langchain4j.openai.common.runtime.AdditionalPropertiesHack;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.Cancellable;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

public class QuarkusOpenAiClient
extends OpenAiClient {
    private final String azureApiKey;
    private final String azureAdToken;
    private final String openaiApiKey;
    private final String apiVersion;
    private final String organizationId;
    private final OpenAiRestApi restApi;
    private static final Map<Builder, OpenAiRestApi> cache = new ConcurrentHashMap<Builder, OpenAiRestApi>();

    public QuarkusOpenAiClient(String openaiApiKey) {
        this(new Builder().openAiApiKey(openaiApiKey));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void clearCache() {
        cache.clear();
    }

    private QuarkusOpenAiClient(Builder builder) {
        this.azureApiKey = builder.azureApiKey;
        this.openaiApiKey = builder.openAiApiKey != null ? builder.openAiApiKey : builder.apiKey;
        this.apiVersion = builder.apiVersion;
        this.organizationId = builder.organizationId;
        this.azureAdToken = builder.azureAdToken;
        this.restApi = cache.compute(builder, new BiFunction<Builder, OpenAiRestApi, OpenAiRestApi>(){

            @Override
            public OpenAiRestApi apply(final Builder builder, OpenAiRestApi openAiRestApi) {
                try {
                    boolean logResponses;
                    QuarkusRestClientBuilder restApiBuilder = QuarkusRestClientBuilder.newBuilder().baseUri(new URI(builder.baseUrl)).connectTimeout(builder.getConnectTimeout().toSeconds(), TimeUnit.SECONDS).readTimeout(builder.getReadTimeout().toSeconds(), TimeUnit.SECONDS);
                    boolean bl = logResponses = builder.logResponses || builder.logStreamingResponses;
                    if (builder.logRequests || logResponses) {
                        restApiBuilder.loggingScope(LoggingScope.REQUEST_RESPONSE);
                        restApiBuilder.clientLogger((ClientLogger)new OpenAiRestApi.OpenAiClientLogger(builder.logRequests, logResponses));
                    }
                    if (builder.proxy != null) {
                        if (builder.proxy.type() != Proxy.Type.HTTP) {
                            throw new IllegalArgumentException("Only HTTP type proxy is supported");
                        }
                        if (!(builder.proxy.address() instanceof InetSocketAddress)) {
                            throw new IllegalArgumentException("Unsupported proxy type");
                        }
                        InetSocketAddress socketAddress = (InetSocketAddress)builder.proxy.address();
                        restApiBuilder.proxyAddress(socketAddress.getHostName(), socketAddress.getPort());
                    }
                    if (builder.userAgent != null) {
                        restApiBuilder.register((Object)new ClientRequestFilter(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void filter(ClientRequestContext requestContext) {
                                requestContext.getHeaders().putSingle((Object)"User-Agent", (Object)builder.userAgent);
                            }
                        });
                    }
                    ModelAuthProvider.resolve((String)builder.configName).ifPresent(modelAuthProvider -> restApiBuilder.register((Object)new OpenAiRestApi.OpenAIRestAPIFilter((ModelAuthProvider)modelAuthProvider)));
                    Instance tlsConfigurationRegistry = CDI.current().select(TlsConfigurationRegistry.class, new Annotation[0]);
                    if (tlsConfigurationRegistry.isResolvable()) {
                        TlsConfiguration.from((TlsConfigurationRegistry)((TlsConfigurationRegistry)tlsConfigurationRegistry.get()), Optional.ofNullable(builder.tlsConfigurationName)).ifPresent(arg_0 -> ((QuarkusRestClientBuilder)restApiBuilder).tlsConfiguration(arg_0));
                    }
                    return (OpenAiRestApi)restApiBuilder.build(OpenAiRestApi.class);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public SyncOrAsyncOrStreaming<CompletionResponse> completion(final CompletionRequest request) {
        return new SyncOrAsyncOrStreaming<CompletionResponse>(this){
            final /* synthetic */ QuarkusOpenAiClient this$0;
            {
                this.this$0 = this$0;
            }

            public CompletionResponse execute() {
                return this.this$0.restApi.blockingCompletion(CompletionRequest.builder().from(request).stream(null).build(), OpenAiRestApi.ApiMetadata.builder().azureApiKey(this.this$0.azureApiKey).azureAdToken(this.this$0.azureAdToken).openAiApiKey(this.this$0.openaiApiKey).apiVersion(this.this$0.apiVersion).organizationId(this.this$0.organizationId).build());
            }

            public AsyncResponseHandling onResponse(Consumer<CompletionResponse> responseHandler) {
                return new AsyncResponseHandlingImpl<CompletionResponse>(new Supplier<Uni<CompletionResponse>>(){

                    @Override
                    public Uni<CompletionResponse> get() {
                        return this$0.restApi.completion(request, OpenAiRestApi.ApiMetadata.builder().azureApiKey(this$0.azureApiKey).openAiApiKey(this$0.openaiApiKey).apiVersion(this$0.apiVersion).organizationId(this$0.organizationId).build());
                    }
                }, responseHandler);
            }

            public StreamingResponseHandling onPartialResponse(Consumer<CompletionResponse> partialResponseHandler) {
                return new StreamingResponseHandlingImpl<CompletionResponse>(new Supplier<Multi<CompletionResponse>>(){

                    @Override
                    public Multi<CompletionResponse> get() {
                        return this$0.restApi.streamingCompletion(request, OpenAiRestApi.ApiMetadata.builder().azureApiKey(this$0.azureApiKey).openAiApiKey(this$0.openaiApiKey).apiVersion(this$0.apiVersion).organizationId(this$0.organizationId).build());
                    }
                }, partialResponseHandler);
            }
        };
    }

    public SyncOrAsyncOrStreaming<ChatCompletionResponse> chatCompletion(final ChatCompletionRequest request) {
        return new SyncOrAsyncOrStreaming<ChatCompletionResponse>(this){
            final /* synthetic */ QuarkusOpenAiClient this$0;
            {
                this.this$0 = this$0;
            }

            public ChatCompletionResponse execute() {
                return this.this$0.restApi.blockingChatCompletion(ChatCompletionRequest.builder().from(request).stream(null).build(), OpenAiRestApi.ApiMetadata.builder().azureApiKey(this.this$0.azureApiKey).azureAdToken(this.this$0.azureAdToken).openAiApiKey(this.this$0.openaiApiKey).apiVersion(this.this$0.apiVersion).organizationId(this.this$0.organizationId).build());
            }

            public AsyncResponseHandling onResponse(Consumer<ChatCompletionResponse> responseHandler) {
                return new AsyncResponseHandlingImpl<ChatCompletionResponse>(new Supplier<Uni<ChatCompletionResponse>>(){

                    @Override
                    public Uni<ChatCompletionResponse> get() {
                        return this$0.restApi.createChatCompletion(request, OpenAiRestApi.ApiMetadata.builder().azureApiKey(this$0.azureApiKey).openAiApiKey(this$0.openaiApiKey).apiVersion(this$0.apiVersion).organizationId(this$0.organizationId).build());
                    }
                }, responseHandler);
            }

            public StreamingResponseHandling onPartialResponse(Consumer<ChatCompletionResponse> partialResponseHandler) {
                return new StreamingResponseHandlingImpl<ChatCompletionResponse>(new Supplier<Multi<ChatCompletionResponse>>(){

                    @Override
                    public Multi<ChatCompletionResponse> get() {
                        return this$0.restApi.streamingChatCompletion(request, OpenAiRestApi.ApiMetadata.builder().azureApiKey(this$0.azureApiKey).openAiApiKey(this$0.openaiApiKey).apiVersion(this$0.apiVersion).organizationId(this$0.organizationId).build());
                    }
                }, partialResponseHandler);
            }
        };
    }

    public SyncOrAsync<EmbeddingResponse> embedding(final EmbeddingRequest request) {
        return new SyncOrAsync<EmbeddingResponse>(this){
            final /* synthetic */ QuarkusOpenAiClient this$0;
            {
                this.this$0 = this$0;
            }

            public EmbeddingResponse execute() {
                return this.this$0.restApi.blockingEmbedding(request, OpenAiRestApi.ApiMetadata.builder().azureApiKey(this.this$0.azureApiKey).azureAdToken(this.this$0.azureAdToken).openAiApiKey(this.this$0.openaiApiKey).apiVersion(this.this$0.apiVersion).organizationId(this.this$0.organizationId).build());
            }

            public AsyncResponseHandling onResponse(Consumer<EmbeddingResponse> responseHandler) {
                return new AsyncResponseHandlingImpl<EmbeddingResponse>(new Supplier<Uni<EmbeddingResponse>>(){

                    @Override
                    public Uni<EmbeddingResponse> get() {
                        return this$0.restApi.embedding(request, OpenAiRestApi.ApiMetadata.builder().azureApiKey(this$0.azureApiKey).openAiApiKey(this$0.openaiApiKey).apiVersion(this$0.apiVersion).organizationId(this$0.organizationId).build());
                    }
                }, responseHandler);
            }
        };
    }

    public SyncOrAsync<ModerationResponse> moderation(final ModerationRequest request) {
        return new SyncOrAsync<ModerationResponse>(this){
            final /* synthetic */ QuarkusOpenAiClient this$0;
            {
                this.this$0 = this$0;
            }

            public ModerationResponse execute() {
                return this.this$0.restApi.blockingModeration(request, OpenAiRestApi.ApiMetadata.builder().azureApiKey(this.this$0.azureApiKey).azureAdToken(this.this$0.azureAdToken).openAiApiKey(this.this$0.openaiApiKey).apiVersion(this.this$0.apiVersion).organizationId(this.this$0.organizationId).build());
            }

            public AsyncResponseHandling onResponse(Consumer<ModerationResponse> responseHandler) {
                return new AsyncResponseHandlingImpl<ModerationResponse>(new Supplier<Uni<ModerationResponse>>(){

                    @Override
                    public Uni<ModerationResponse> get() {
                        return this$0.restApi.moderation(request, OpenAiRestApi.ApiMetadata.builder().azureApiKey(this$0.azureApiKey).openAiApiKey(this$0.openaiApiKey).apiVersion(this$0.apiVersion).organizationId(this$0.organizationId).build());
                    }
                }, responseHandler);
            }
        };
    }

    public SyncOrAsync<GenerateImagesResponse> imagesGeneration(final GenerateImagesRequest generateImagesRequest) {
        return new SyncOrAsync<GenerateImagesResponse>(){
            final /* synthetic */ QuarkusOpenAiClient this$0;
            {
                this.this$0 = this$0;
            }

            public GenerateImagesResponse execute() {
                return this.this$0.restApi.blockingImagesGenerations(generateImagesRequest, OpenAiRestApi.ApiMetadata.builder().azureApiKey(this.this$0.azureApiKey).azureAdToken(this.this$0.azureAdToken).openAiApiKey(this.this$0.openaiApiKey).apiVersion(this.this$0.apiVersion).organizationId(this.this$0.organizationId).build());
            }

            public AsyncResponseHandling onResponse(Consumer<GenerateImagesResponse> responseHandler) {
                return new AsyncResponseHandlingImpl<GenerateImagesResponse>(new Supplier<Uni<GenerateImagesResponse>>(){

                    @Override
                    public Uni<GenerateImagesResponse> get() {
                        return this$0.restApi.imagesGenerations(generateImagesRequest, OpenAiRestApi.ApiMetadata.builder().azureApiKey(this$0.azureApiKey).openAiApiKey(this$0.openaiApiKey).apiVersion(this$0.apiVersion).organizationId(this$0.organizationId).build());
                    }
                }, responseHandler);
            }
        };
    }

    public static class Builder
    extends OpenAiClient.Builder<QuarkusOpenAiClient, Builder> {
        private String userAgent;
        private String azureAdToken;
        private String configName;
        private String tlsConfigurationName;
        private String openAiApiKey;
        private String azureApiKey;
        private Duration callTimeout = Duration.ofSeconds(60L);
        private Duration writeTimeout = Duration.ofSeconds(60L);
        private String apiVersion;
        public Proxy proxy;
        public boolean logStreamingResponses;

        public Duration getConnectTimeout() {
            return this.connectTimeout == null ? Duration.ofSeconds(60L) : this.connectTimeout;
        }

        public Duration getReadTimeout() {
            return this.readTimeout == null ? Duration.ofSeconds(60L) : this.readTimeout;
        }

        public Builder tlsConfigurationName(String tlsConfigurationName) {
            this.tlsConfigurationName = tlsConfigurationName;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder azureAdToken(String azureAdToken) {
            this.azureAdToken = azureAdToken;
            return this;
        }

        public Builder configName(String configName) {
            this.configName = configName;
            return this;
        }

        public Builder openAiApiKey(String openAiApiKey) {
            this.openAiApiKey = openAiApiKey;
            return this;
        }

        public Builder azureApiKey(String azureApiKey) {
            this.azureApiKey = azureApiKey;
            return this;
        }

        public Builder logStreamingResponses(boolean logStreamingResponses) {
            this.logStreamingResponses = logStreamingResponses;
            return this;
        }

        public QuarkusOpenAiClient build() {
            return new QuarkusOpenAiClient(this);
        }

        public Builder callTimeout(Duration callTimeout) {
            if (callTimeout == null) {
                throw new IllegalArgumentException("callTimeout cannot be null");
            }
            this.callTimeout = callTimeout;
            return this;
        }

        public Builder writeTimeout(Duration writeTimeout) {
            if (writeTimeout == null) {
                throw new IllegalArgumentException("writeTimeout cannot be null");
            }
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxy(Proxy.Type type, String ip, int port) {
            this.proxy = new Proxy(type, new InetSocketAddress(ip, port));
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)((Object)o);
            return this.logRequests == builder.logRequests && this.logResponses == builder.logResponses && this.logStreamingResponses == builder.logStreamingResponses && Objects.equals(this.baseUrl, builder.baseUrl) && Objects.equals(this.apiVersion, builder.apiVersion) && Objects.equals(this.openAiApiKey, builder.openAiApiKey) && Objects.equals(this.azureApiKey, builder.azureApiKey) && Objects.equals(this.organizationId, builder.organizationId) && Objects.equals(this.callTimeout, builder.callTimeout) && Objects.equals(this.connectTimeout, builder.connectTimeout) && Objects.equals(this.readTimeout, builder.readTimeout) && Objects.equals(this.writeTimeout, builder.writeTimeout) && Objects.equals(this.proxy, builder.proxy) && Objects.equals(this.azureAdToken, builder.azureAdToken) && Objects.equals(this.userAgent, builder.userAgent) && Objects.equals(this.configName, builder.configName);
        }

        public int hashCode() {
            return Objects.hash(this.baseUrl, this.apiVersion, this.openAiApiKey, this.azureApiKey, this.organizationId, this.callTimeout, this.connectTimeout, this.readTimeout, this.writeTimeout, this.proxy, this.logRequests, this.logResponses, this.logStreamingResponses, this.userAgent, this.azureAdToken, this.configName);
        }
    }

    private static class ResponseHandleImpl
    extends ResponseHandle {
        private final Cancellable cancellable;

        public ResponseHandleImpl(Cancellable cancellable) {
            this.cancellable = cancellable;
        }

        public void cancel() {
            this.cancellable.cancel();
        }
    }

    private static class NoopCompleteHandler
    implements Runnable {
        private static final NoopCompleteHandler INSTANCE = new NoopCompleteHandler();

        private NoopCompleteHandler() {
        }

        @Override
        public void run() {
        }
    }

    private static class NoopErrorHandler
    implements Consumer<Throwable> {
        private static final NoopErrorHandler INSTANCE = new NoopErrorHandler();

        private NoopErrorHandler() {
        }

        @Override
        public void accept(Throwable throwable) {
        }
    }

    private static class StreamingResponseHandlingImpl<RESPONSE>
    implements StreamingResponseHandling,
    StreamingCompletionHandling {
        private final AtomicReference<Runnable> completeHandlerRef = new AtomicReference<NoopCompleteHandler>(NoopCompleteHandler.INSTANCE);
        private final AtomicReference<Consumer<Throwable>> errorHandlerRef = new AtomicReference<NoopErrorHandler>(NoopErrorHandler.INSTANCE);
        private final StreamingResultErrorHandling<RESPONSE> resultHandling;

        public StreamingResponseHandlingImpl(Supplier<Multi<RESPONSE>> multiSupplier, Consumer<RESPONSE> partialResponseHandler) {
            this.resultHandling = new StreamingResultErrorHandling<RESPONSE>(multiSupplier, partialResponseHandler, this.completeHandlerRef, this.errorHandlerRef);
        }

        public StreamingCompletionHandling onComplete(Runnable streamingCompletionCallback) {
            this.completeHandlerRef.set(streamingCompletionCallback);
            return this;
        }

        public ErrorHandling onError(Consumer<Throwable> errorHandler) {
            this.errorHandlerRef.set(errorHandler);
            return this.resultHandling;
        }

        public ErrorHandling ignoreErrors() {
            this.errorHandlerRef.set(NoopErrorHandler.INSTANCE);
            return this.resultHandling;
        }

        private static class StreamingResultErrorHandling<RESPONSE>
        implements ErrorHandling {
            private final Supplier<Multi<RESPONSE>> multiSupplier;
            private final Consumer<RESPONSE> partialResponseHandler;
            private final AtomicReference<Runnable> completeHandlerRef;
            private final AtomicReference<Consumer<Throwable>> errorHandlerRef;

            public StreamingResultErrorHandling(Supplier<Multi<RESPONSE>> multiSupplier, Consumer<RESPONSE> partialResponseHandler, AtomicReference<Runnable> completeHandlerRef, AtomicReference<Consumer<Throwable>> errorHandlerRef) {
                this.multiSupplier = multiSupplier;
                this.partialResponseHandler = partialResponseHandler;
                this.completeHandlerRef = completeHandlerRef;
                this.errorHandlerRef = errorHandlerRef;
            }

            public ResponseHandle execute() {
                Cancellable cancellable = this.multiSupplier.get().subscribe().with(this.partialResponseHandler, this.errorHandlerRef.get(), this.completeHandlerRef.get());
                return new ResponseHandleImpl(cancellable);
            }
        }
    }

    private static class AsyncResponseHandlingImpl<RESPONSE>
    implements AsyncResponseHandling {
        private final AtomicReference<Consumer<Throwable>> errorHandlerRef = new AtomicReference<NoopErrorHandler>(NoopErrorHandler.INSTANCE);
        private final SingleResultHandling<RESPONSE> resultHandling;

        public AsyncResponseHandlingImpl(Supplier<Uni<RESPONSE>> uniSupplier, Consumer<RESPONSE> responseHandler) {
            this.resultHandling = new SingleResultHandling<RESPONSE>(uniSupplier, responseHandler, this.errorHandlerRef);
        }

        public ErrorHandling onError(Consumer<Throwable> errorHandler) {
            this.errorHandlerRef.set(errorHandler);
            return this.resultHandling;
        }

        public ErrorHandling ignoreErrors() {
            this.errorHandlerRef.set(NoopErrorHandler.INSTANCE);
            return this.resultHandling;
        }

        private static class SingleResultHandling<RESPONSE>
        implements ErrorHandling {
            private final Supplier<Uni<RESPONSE>> uniSupplier;
            private final Consumer<RESPONSE> responseHandler;
            private final AtomicReference<Consumer<Throwable>> errorHandlerRef;

            public SingleResultHandling(Supplier<Uni<RESPONSE>> uniSupplier, Consumer<RESPONSE> responseHandler, AtomicReference<Consumer<Throwable>> errorHandlerRef) {
                this.uniSupplier = uniSupplier;
                this.responseHandler = responseHandler;
                this.errorHandlerRef = errorHandlerRef;
            }

            public ResponseHandle execute() {
                Cancellable cancellable = this.uniSupplier.get().subscribe().with(this.responseHandler, this.errorHandlerRef.get());
                return new ResponseHandleImpl(cancellable);
            }
        }
    }

    public static class QuarkusOpenAiClientBuilderFactory
    implements OpenAiClientBuilderFactory {
        public Builder get() {
            Builder result = new Builder();
            result.configName(AdditionalPropertiesHack.getAndClearConfigName());
            result.tlsConfigurationName(AdditionalPropertiesHack.getAndClearTlsConfigurationName());
            return result;
        }
    }
}

