/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.agentic.deployment;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.service.IllegalConfigurationException;
import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.agentic.deployment.AgenticLangChain4jDotNames;
import io.quarkiverse.langchain4j.agentic.deployment.DetectedAiAgentBuildItem;
import io.quarkiverse.langchain4j.agentic.runtime.AgenticRecorder;
import io.quarkiverse.langchain4j.agentic.runtime.AiAgentCreateInfo;
import io.quarkiverse.langchain4j.deployment.AnnotationsImpliesAiServiceBuildItem;
import io.quarkiverse.langchain4j.deployment.DotNames;
import io.quarkiverse.langchain4j.deployment.FallbackToDummyUserMessageBuildItem;
import io.quarkiverse.langchain4j.deployment.PreventToolValidationErrorBuildItem;
import io.quarkiverse.langchain4j.deployment.RequestChatModelBeanBuildItem;
import io.quarkiverse.langchain4j.deployment.SkipOutputFormatInstructionsBuildItem;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class AgenticProcessor {
    @BuildStep
    void indexDependencies(BuildProducer<IndexDependencyBuildItem> producer) {
        producer.produce((BuildItem)new IndexDependencyBuildItem("dev.langchain4j", "langchain4j-agentic"));
    }

    @BuildStep
    void detectAgents(CombinedIndexBuildItem indexBuildItem, BuildProducer<DetectedAiAgentBuildItem> producer) {
        IndexView index = indexBuildItem.getIndex();
        HashMap<ClassInfo, List<MethodInfo>> ifaceToAgentMethodsMap = new HashMap<ClassInfo, List<MethodInfo>>();
        for (DotName dotName : AgenticLangChain4jDotNames.ALL_AGENT_ANNOTATIONS) {
            AgenticProcessor.collectAgentsWithMethodAnnotations(index, dotName, ifaceToAgentMethodsMap);
        }
        ifaceToAgentMethodsMap.forEach((classInfo, methods) -> {
            Optional<MethodInfo> chatModelSupplier = classInfo.methods().stream().filter(m -> Modifier.isStatic(m.flags()) && m.hasAnnotation(AgenticLangChain4jDotNames.CHAT_MODEL_SUPPLIER)).findFirst();
            List<MethodInfo> mcpToolBoxMethods = methods.stream().filter(mi -> mi.hasAnnotation(DotNames.MCP_TOOLBOX)).toList();
            producer.produce((BuildItem)new DetectedAiAgentBuildItem((ClassInfo)classInfo, (List<MethodInfo>)methods, chatModelSupplier.orElse(null), mcpToolBoxMethods));
        });
    }

    @BuildStep
    PreventToolValidationErrorBuildItem supportTools() {
        return new PreventToolValidationErrorBuildItem((Predicate)new Predicate<ClassInfo>(){

            @Override
            public boolean test(ClassInfo classInfo) {
                for (DotName dotName : AgenticLangChain4jDotNames.ALL_AGENT_ANNOTATIONS) {
                    if (!classInfo.hasAnnotation(dotName)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @BuildStep
    AnnotationsImpliesAiServiceBuildItem implyAiService() {
        return new AnnotationsImpliesAiServiceBuildItem(AgenticLangChain4jDotNames.ALL_AGENT_ANNOTATIONS);
    }

    @BuildStep
    SkipOutputFormatInstructionsBuildItem skipOutputInstructions() {
        final Set<DotName> skippedReturnTypes = Set.of(AgenticLangChain4jDotNames.AGENTIC_SCOPE, AgenticLangChain4jDotNames.RESULT_WITH_AGENTIC_SCOPE, DotName.OBJECT_NAME, io.quarkus.arc.processor.DotNames.LIST);
        return new SkipOutputFormatInstructionsBuildItem((Predicate)new Predicate<MethodInfo>(this){
            final /* synthetic */ AgenticProcessor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(MethodInfo methodInfo) {
                return skippedReturnTypes.contains(methodInfo.returnType().name());
            }
        });
    }

    @BuildStep
    FallbackToDummyUserMessageBuildItem fallbackToDummyUserMessage() {
        return new FallbackToDummyUserMessageBuildItem((Predicate)new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo methodInfo) {
                for (DotName dotName : AgenticLangChain4jDotNames.ALL_AGENT_ANNOTATIONS) {
                    if (!methodInfo.hasAnnotation(dotName)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void mcpToolBoxSupport(List<DetectedAiAgentBuildItem> detectedAgentBuildItems, AgenticRecorder recorder) {
        HashSet<String> agentsWithMcpToolBox = new HashSet<String>();
        for (DetectedAiAgentBuildItem bi : detectedAgentBuildItems) {
            if (bi.getMcpToolBoxMethods().isEmpty()) continue;
            if (bi.getMcpToolBoxMethods().size() != 1 && bi.getAgenticMethods().size() > 1) {
                throw new IllegalConfigurationException("Currently, @McpToolBox can only be used on an Agent if the agent has a single method. This restriction will be lifted in the future. Offending class is '" + String.valueOf(bi.getIface().name()) + "'");
            }
            agentsWithMcpToolBox.add(bi.getIface().name().toString());
        }
        recorder.setAgentsWithMcpToolBox(agentsWithMcpToolBox);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void cdiSupport(List<DetectedAiAgentBuildItem> detectedAiAgentBuildItems, AgenticRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, BuildProducer<RequestChatModelBeanBuildItem> requestChatModelBeanProducer) {
        HashSet<String> requestedChatModelNames = new HashSet<String>();
        for (DetectedAiAgentBuildItem detectedAiAgentBuildItem : detectedAiAgentBuildItems) {
            String chatModelName = "<default>";
            requestedChatModelNames.add(chatModelName);
            AiAgentCreateInfo.ChatModelInfo.FromAnnotation chatModelInfo = detectedAiAgentBuildItem.getChatModelSupplier() != null ? new AiAgentCreateInfo.ChatModelInfo.FromAnnotation() : new AiAgentCreateInfo.ChatModelInfo.FromBeanWithName(chatModelName);
            SyntheticBeanBuildItem.ExtendedBeanConfigurator beanConfigurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)detectedAiAgentBuildItem.getIface().name()).forceApplicationClass()).createWith(recorder.createAiAgent(new AiAgentCreateInfo(detectedAiAgentBuildItem.getIface().toString(), (AiAgentCreateInfo.ChatModelInfo)chatModelInfo))).setRuntimeInit().scope(ApplicationScoped.class);
            if (chatModelInfo instanceof AiAgentCreateInfo.ChatModelInfo.FromBeanWithName) {
                AiAgentCreateInfo.ChatModelInfo.FromBeanWithName f = (AiAgentCreateInfo.ChatModelInfo.FromBeanWithName)chatModelInfo;
                AnnotationInstance qualifier = NamedConfigUtil.isDefault((String)f.name()) ? AnnotationInstance.builder(Default.class).build() : AnnotationInstance.builder(ModelName.class).add("value", f.name()).build();
                beanConfigurator.addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(ChatModel.class)), new AnnotationInstance[]{qualifier});
            }
            beanConfigurator.addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)DotNames.TOOL_PROVIDER)}, null), new AnnotationInstance[0]);
            syntheticBeanProducer.produce((BuildItem)beanConfigurator.done());
        }
        requestedChatModelNames.forEach(name -> requestChatModelBeanProducer.produce((BuildItem)new RequestChatModelBeanBuildItem(name)));
    }

    @BuildStep
    void nativeSupport(List<DetectedAiAgentBuildItem> detectedAiAgentBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyProducer) {
        String[] agentClassNames = (String[])detectedAiAgentBuildItems.stream().map(bi -> bi.getIface().name().toString()).toArray(String[]::new);
        reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])agentClassNames).methods(true).fields(false).build());
        proxyProducer.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(agentClassNames));
    }

    private static void collectAgentsWithMethodAnnotations(IndexView index, DotName annotation, Map<ClassInfo, List<MethodInfo>> ifaceToAgentMethodsMap) {
        Collection annotations = index.getAnnotations(annotation);
        for (AnnotationInstance ai : annotations) {
            MethodInfo methodInfo;
            if (ai.target().kind() != AnnotationTarget.Kind.METHOD || !(methodInfo = ai.target().asMethod()).declaringClass().isInterface()) continue;
            ClassInfo iface = methodInfo.declaringClass();
            AgenticProcessor.addMethodToMap(methodInfo, iface, ifaceToAgentMethodsMap);
            index.getAllKnownSubinterfaces(iface.name()).forEach(i -> AgenticProcessor.addMethodToMap(methodInfo, i, ifaceToAgentMethodsMap));
        }
    }

    private static void addMethodToMap(MethodInfo methodInfo, ClassInfo iface, Map<ClassInfo, List<MethodInfo>> map) {
        map.computeIfAbsent(iface, k -> new ArrayList()).add(methodInfo);
    }
}

