/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.facadeiri;

import io.github.sparqlanything.facadeiri.antlr.FacadeIRIBaseListener;
import io.github.sparqlanything.facadeiri.antlr.FacadeIRIParser;
import io.github.sparqlanything.model.IRIArgument;
import java.nio.CharBuffer;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterListener
extends FacadeIRIBaseListener {
    private Properties properties = new Properties();
    public static final char ESCAPE = '\\';
    public static final char[] ESCAPED = new char[]{'=', ','};
    private static final Logger logger = LoggerFactory.getLogger(ParameterListener.class);

    @Override
    public void enterParameter(FacadeIRIParser.ParameterContext ctx) {
        logger.trace("URL {}", (Object)ctx.url());
        if (ctx.url() != null) {
            this.properties.setProperty(IRIArgument.LOCATION.toString(), ctx.url().getText());
        }
        if (ctx.keyValue() != null) {
            String key = this.unescape(ctx.keyValue().IDENTIFIER(0).getText());
            if (ctx.keyValue().LITERAL() != null) {
                this.properties.setProperty(key, this.unescape(ctx.keyValue().LITERAL().getText()));
            }
            if (ctx.keyValue().IDENTIFIER(1) != null) {
                this.properties.setProperty(key, this.unescape(ctx.keyValue().IDENTIFIER(1).getText()));
            }
        }
    }

    private String unescape(String s) {
        String result = s;
        for (char escaped : ESCAPED) {
            result = result.replace(CharBuffer.wrap(new char[]{'\\', escaped}), CharBuffer.wrap(new char[]{escaped}));
        }
        return result;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

