/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.facadeiri;

import io.github.sparqlanything.facadeiri.ParameterListener;
import io.github.sparqlanything.facadeiri.antlr.FacadeIRILexer;
import io.github.sparqlanything.facadeiri.antlr.FacadeIRIParser;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacadeIRIParser {
    private String tupleURL;
    public static final String SPARQL_ANYTHING_URI_SCHEMA = "x-sparql-anything:";
    private static final Pattern key = Pattern.compile("^[a-zA-Z0-9-]+");
    private static final Logger log = LoggerFactory.getLogger(FacadeIRIParser.class);

    public FacadeIRIParser(String tupleURL) {
        this.tupleURL = tupleURL;
    }

    public String getTupleURL() {
        return this.tupleURL;
    }

    public void setTupleURL(String tupleURL) {
        this.tupleURL = tupleURL;
    }

    public Properties getProperties() {
        FacadeIRILexer lexer = new FacadeIRILexer((CharStream)CharStreams.fromString((String)this.escape(this.tupleURL.substring(SPARQL_ANYTHING_URI_SCHEMA.length()))));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        io.github.sparqlanything.facadeiri.antlr.FacadeIRIParser parser = new io.github.sparqlanything.facadeiri.antlr.FacadeIRIParser((TokenStream)tokens);
        FacadeIRIParser.BasicURLContext tree = parser.basicURL();
        ParseTreeWalker walker = new ParseTreeWalker();
        ParameterListener listener = new ParameterListener();
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        return listener.getProperties();
    }

    private String escape(String s) {
        Matcher m = key.matcher(s);
        log.trace("Input escape {}", (Object)s);
        if (m.find() && m.end() < s.length() && s.charAt(m.end()) != '=') {
            log.trace("Unescape");
            return s;
        }
        boolean lookingForEqual = false;
        boolean lookingForComma = true;
        StringBuilder sb = new StringBuilder();
        sb.append(s.subSequence(0, m.end() + 1));
        for (int i = m.end() + 1; i < s.length(); ++i) {
            if (lookingForComma && s.charAt(i) == '=') {
                sb.append('\\');
                sb.append('=');
                continue;
            }
            if (lookingForComma && s.charAt(i) == ',' && s.charAt(i - 1) != '\\') {
                sb.append(s.charAt(i));
                lookingForEqual = true;
                lookingForComma = false;
                continue;
            }
            if (lookingForComma && s.charAt(i) != ',') {
                sb.append(s.charAt(i));
                continue;
            }
            if (lookingForEqual && s.charAt(i) == '=') {
                sb.append(s.charAt(i));
                lookingForComma = true;
                continue;
            }
            if (!lookingForEqual || s.charAt(i) == '=') continue;
            sb.append(s.charAt(i));
        }
        log.trace("Escaped {}", (Object)sb.toString());
        return sb.toString();
    }
}

