/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.model;

import io.github.sparqlanything.model.PluginInitializer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static OS platform;

    public static URL instantiateURL(String urlLocation) throws MalformedURLException {
        URL url;
        log.trace("URL Location {}", (Object)urlLocation);
        try {
            url = new URL(urlLocation);
        }
        catch (MalformedURLException u) {
            log.trace("Malformed url interpreting as file");
            url = new File(urlLocation).toURI().toURL();
        }
        log.trace("Result {}", (Object)url);
        return url;
    }

    public static void loadJARs(String[] paths) throws IOException {
        if (paths == null || paths.length == 0) {
            return;
        }
        ArrayList<String> classNames = new ArrayList<String>();
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = Utils.instantiateURL(paths[i]);
            JarInputStream jis = new JarInputStream(urls[i].openStream());
            classNames.addAll(Utils.getClassNamesFromJar(jis));
        }
        try (URLClassLoader child = new URLClassLoader(urls, Utils.class.getClassLoader());){
            for (String className : classNames) {
                try {
                    Class<?> k = child.loadClass(className);
                    if (!Arrays.stream(k.getInterfaces()).anyMatch(iFaceClass -> iFaceClass == PluginInitializer.class)) continue;
                    PluginInitializer p = (PluginInitializer)k.getConstructor(new Class[0]).newInstance(new Object[0]);
                    p.run();
                }
                catch (ClassNotFoundException | IllegalAccessException | IncompatibleClassChangeError | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
                    System.err.println("Cannot load class ".concat(className));
                }
            }
        }
    }

    private static ArrayList<String> getClassNamesFromJar(JarInputStream jarFile) throws IOException {
        JarEntry jar;
        ArrayList<String> classNames = new ArrayList<String>();
        while ((jar = jarFile.getNextJarEntry()) != null) {
            if (!jar.getName().endsWith(".class")) continue;
            String className = jar.getName().replaceAll("/", "\\.");
            String myClass = className.substring(0, className.lastIndexOf(46));
            classNames.add(myClass);
        }
        return classNames;
    }

    static {
        String operSys = System.getProperty("os.name").toLowerCase();
        if (operSys.contains("win")) {
            platform = OS.WINDOWS;
        } else if (operSys.contains("nix") || operSys.contains("nux") || operSys.contains("aix")) {
            platform = OS.LINUX;
        } else if (operSys.contains("mac")) {
            platform = OS.MAC;
        } else if (operSys.contains("sunos")) {
            platform = OS.SOLARIS;
        }
    }

    public static enum OS {
        WINDOWS,
        LINUX,
        MAC,
        SOLARIS;

    }
}

