/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.model;

import io.github.sparqlanything.model.TriplifierRegisterException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TriplifierRegister {
    private static final Logger log = LoggerFactory.getLogger(TriplifierRegister.class);
    private static TriplifierRegister instance;
    private final Map<String, String> mimeType = new HashMap<String, String>();
    private final Map<String, String> extension = new HashMap<String, String>();

    private TriplifierRegister() {
    }

    public static TriplifierRegister getInstance() {
        if (instance == null) {
            instance = new TriplifierRegister();
        }
        return instance;
    }

    public void registerTriplifier(String t, String[] extensions, String[] mimeTypes) throws TriplifierRegisterException {
        log.trace("Registering {}", (Object)t);
        for (String ext : extensions) {
            if (this.extension.containsKey(ext)) {
                throw new TriplifierRegisterException("A triplifier for " + ext + " extension has been already registered!");
            }
            log.trace("Registering triplifier for extension {} : {}", (Object)ext, (Object)t);
            this.extension.put(ext, t);
        }
        for (String mimeType : mimeTypes) {
            if (this.mimeType.containsKey(mimeType)) {
                throw new TriplifierRegisterException("A triplifier for " + mimeType + " mime has been already registered!");
            }
            log.trace("Registering triplifier for mime-type {} : {}", (Object)mimeType, (Object)t);
            this.mimeType.put(mimeType, t);
        }
    }

    public void removeTriplifier(String t) {
        HashSet<String> extToRemove = new HashSet<String>();
        for (String ext : this.extension.keySet()) {
            if (!this.extension.get(ext).equals(t)) continue;
            extToRemove.add(ext);
        }
        for (String ext : extToRemove) {
            this.extension.remove(ext);
        }
        HashSet<String> mimeToRemove = new HashSet<String>();
        for (String mimeType : this.mimeType.keySet()) {
            if (!this.mimeType.get(mimeType).equals(t)) continue;
            mimeToRemove.add(mimeType);
        }
        for (String mimeType : mimeToRemove) {
            this.mimeType.remove(mimeType);
        }
    }

    public String getTriplifierForMimeType(String f) {
        return this.mimeType.get(f);
    }

    public String getTriplifierForExtension(String f) {
        return this.extension.get(f);
    }

    public void printMediaTypes() {
        this.mimeType.keySet().forEach(System.out::println);
    }

    public Set<String> getRegisteredExtensions() {
        return this.extension.keySet();
    }

    public Set<String> getRegisteredMediaTypes() {
        return this.mimeType.keySet();
    }

    public Set<String> getTriplifiers() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.extension.values());
        result.addAll(this.mimeType.values());
        result.add("io.github.sparqlanything.zip.FolderTriplifier");
        result.add("io.github.sparqlanything.metadata.MetadataTriplifier");
        return result;
    }

    public Set<String> getTriplifierExtensions(String triplifier) {
        HashSet<String> result = new HashSet<String>();
        this.extension.forEach((extension, t) -> {
            if (t.equals(triplifier)) {
                result.add((String)extension);
            }
        });
        return result;
    }

    public Set<String> getTriplifierMimeType(String triplifier) {
        HashSet<String> result = new HashSet<String>();
        this.mimeType.forEach((mimeType, t) -> {
            if (t.equals(triplifier)) {
                result.add((String)mimeType);
            }
        });
        return result;
    }
}

