/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.model;

import com.google.common.escape.UnicodeEscaper;
import com.google.common.net.PercentEscaper;
import io.github.sparqlanything.model.FacadeXGraphBuilder;
import io.github.sparqlanything.model.HTTPHelper;
import io.github.sparqlanything.model.IRIArgument;
import io.github.sparqlanything.model.PropertyUtils;
import io.github.sparqlanything.model.ResourceManager;
import io.github.sparqlanything.model.TriplifierHTTPException;
import io.github.sparqlanything.model.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Triplifier {
    public static final String XYZ_NS = "http://sparql.xyz/facade-x/data/";
    public static final String METADATA_GRAPH_IRI = "http://sparql.xyz/facade-x/data/metadata";
    public static final String AUDIT_GRAPH_IRI = "http://sparql.xyz/facade-x/data/audit";
    public static final String FACADE_X_CONST_NAMESPACE_IRI = "http://sparql.xyz/facade-x/ns/";
    public static final String FACADE_X_TYPE_ROOT = "http://sparql.xyz/facade-x/ns/root";
    public static final String FACADE_X_SLOT_KEY = "http://sparql.xyz/facade-x/ns/slot-key";
    public static final String FACADE_X_TYPE_PROPERTIES = "http://sparql.xyz/facade-x/ns/properties";
    public static final String FACADE_X_CACHED_GRAPH = "http://sparql.xyz/facade-x/ns/cachedGraph";
    public static final String FACADE_X_CACHED_GRAPH_CREATION = "http://sparql.xyz/facade-x/ns/cachedGraphCreation";
    public static final String FACADE_X_SPARQL_ALGEBRA = "http://sparql.xyz/facade-x/ns/sparqlAlgebra";
    public static final Logger log = LoggerFactory.getLogger(Triplifier.class);
    public static final UnicodeEscaper basicEscaper = new PercentEscaper("_.-~", false);

    public static String getRootArgument(Properties properties) {
        String root = PropertyUtils.getStringProperty(properties, IRIArgument.ROOT, null);
        if (root != null && !root.trim().equals("")) {
            return root;
        }
        String location = Triplifier.getNormalisedLocation(properties);
        if (location != null) {
            return location + "#";
        }
        String content = PropertyUtils.getStringProperty(properties, IRIArgument.CONTENT, null);
        if (content != null) {
            return XYZ_NS + DigestUtils.md5Hex((String)content) + "#";
        }
        String command = PropertyUtils.getStringProperty(properties, IRIArgument.COMMAND, null);
        if (command != null) {
            return XYZ_NS + DigestUtils.md5Hex((String)command) + "#";
        }
        throw new RuntimeException("No location nor content nor command provided!");
    }

    public static String getNormalisedLocation(Properties properties) {
        try {
            URL location = Triplifier.getLocation(properties);
            if (location == null) {
                return null;
            }
            if (location.getProtocol().equals("file")) {
                return Path.of(location.toURI()).toUri().toString();
            }
            return location.toString();
        }
        catch (MalformedURLException e) {
            log.warn("Malformed location");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static URL getLocation(Properties properties) throws MalformedURLException {
        if (properties.containsKey(IRIArgument.LOCATION.toString())) {
            return Utils.instantiateURL(properties.getProperty(IRIArgument.LOCATION.toString()));
        }
        return null;
    }

    public static String toSafeURIString(String s) {
        return basicEscaper.escape(s);
    }

    public static InputStream getInputStream(Properties properties) throws IOException, TriplifierHTTPException {
        return Triplifier.getInputStream(properties, Triplifier.getCharsetArgument(properties));
    }

    public static InputStream getInputStream(Properties properties, Charset charset) throws IOException, TriplifierHTTPException {
        if (properties.containsKey(IRIArgument.COMMAND.toString())) {
            String command = properties.getProperty(IRIArgument.COMMAND.toString());
            Runtime rt = Runtime.getRuntime();
            CharSequence[] commands = Utils.platform != Utils.OS.WINDOWS ? new String[]{"bash", "-c", command} : command.split("(?x)   \\s          (?=          (?:          [^\"]*     \"         [^\"]*     \"       )*         [^\"]*     $        )          ");
            log.info("Running command: {}", (Object)String.join((CharSequence)" ", commands));
            Process proc = rt.exec((String[])commands);
            InputStream is = proc.getInputStream();
            InputStream es = proc.getErrorStream();
            log.info("Command stderr: " + IOUtils.toString((InputStream)es));
            return is;
        }
        if (properties.containsKey(IRIArgument.CONTENT.toString())) {
            return new ByteArrayInputStream(properties.get(IRIArgument.CONTENT.toString()).toString().getBytes());
        }
        if (!properties.containsKey(IRIArgument.FROM_ARCHIVE.toString())) {
            URL url = Triplifier.getLocation(properties);
            if (url.getProtocol().equals("file")) {
                log.debug("Getting input stream from file");
                return url.openStream();
            }
            if (url.getProtocol().equals("http") || url.getProtocol().equals("https")) {
                CloseableHttpResponse response = HTTPHelper.getInputStream(url, properties);
                if (!HTTPHelper.isSuccessful(response)) {
                    log.trace("Request unsuccesful: {}", (Object)response.getStatusLine().toString());
                    log.trace("Response: {}", (Object)response);
                    log.trace("Response body: {}", (Object)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset()));
                    throw new TriplifierHTTPException(url, (HttpResponse)response);
                }
                return response.getEntity().getContent();
            }
            log.debug("Other protocol: {}", (Object)url.getProtocol());
            return url.openStream();
        }
        URL urlArchive = Utils.instantiateURL(properties.getProperty(IRIArgument.FROM_ARCHIVE.toString()));
        try {
            return ResourceManager.getInstance().getInputStreamFromArchive(urlArchive, properties.getProperty(IRIArgument.LOCATION.toString()), charset);
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
    }

    public static Charset getCharsetArgument(Properties properties) {
        Charset charset = null;
        try {
            charset = Charset.forName(properties.getProperty(IRIArgument.CHARSET.toString(), "UTF-8"));
        }
        catch (Exception e) {
            log.warn("Unsupported charset format: '{}', using UTF-8.", (Object)properties.getProperty(IRIArgument.CHARSET.toString()));
            charset = StandardCharsets.UTF_8;
        }
        return charset;
    }

    public static String getResourceId(Properties properties) {
        Object resourceId = null;
        URL url = null;
        try {
            url = Triplifier.getLocation(properties);
        }
        catch (MalformedURLException e) {
            log.error("Malformed url", (Throwable)e);
        }
        if (url == null && properties.containsKey(IRIArgument.COMMAND.toString())) {
            log.trace("No location, use command: {}", (Object)properties.getProperty(IRIArgument.COMMAND.toString()));
            String id = Integer.toString(properties.getProperty(IRIArgument.CONTENT.toString(), "").hashCode());
            resourceId = "command:" + id;
        } else if (url == null && properties.containsKey(IRIArgument.CONTENT.toString())) {
            log.trace("No location, use content: {}", (Object)properties.getProperty(IRIArgument.CONTENT.toString()));
            String id = Integer.toString(properties.getProperty(IRIArgument.CONTENT.toString(), "").hashCode());
            resourceId = "content:" + id;
        } else if (url != null) {
            resourceId = url.toString();
        }
        return resourceId;
    }

    public void triplify(Properties var1, FacadeXGraphBuilder var2) throws IOException, TriplifierHTTPException;

    public Set<String> getMimeTypes();

    public Set<String> getExtensions();
}

