/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManager {
    public static final String tmpFolder = "tmp";
    private static final Logger logger = LoggerFactory.getLogger(ResourceManager.class);
    private static ResourceManager instance;

    private ResourceManager() {
        new File(tmpFolder).mkdir();
    }

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    public InputStream getInputStreamFromArchive(URL archiveLocation, String entryName, Charset charset) throws ArchiveException, IOException {
        logger.trace("Archive location {} entry {}", (Object)archiveLocation.toString(), (Object)entryName);
        String md5url = DigestUtils.md5Hex((String)archiveLocation.toString());
        String folder = "tmp/" + md5url;
        File fileToRead = new File(folder + "/" + entryName);
        if (!fileToRead.exists()) {
            logger.trace("Extracting content from {}", (Object)archiveLocation);
            File destinationDir = new File(folder);
            new File(folder).mkdir();
            ArchiveInputStream i = new ArchiveStreamFactory().createArchiveInputStream(FilenameUtils.getExtension((String)archiveLocation.toString()), archiveLocation.openStream(), charset.toString());
            ArchiveEntry entry = null;
            while ((entry = i.getNextEntry()) != null) {
                if (!i.canReadEntryData(entry)) continue;
                File file = new File(destinationDir, entry.getName());
                if (!file.toPath().normalize().startsWith(destinationDir.toPath())) {
                    throw new IOException("Bad zip entry");
                }
                if (entry.isDirectory()) {
                    if (file.isDirectory() || file.mkdirs()) continue;
                    throw new IOException("failed to create directory " + String.valueOf(file));
                }
                File parent = file.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("failed to create directory " + String.valueOf(parent));
                }
                try (OutputStream o = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                    IOUtils.copy((InputStream)i, (OutputStream)o);
                }
            }
        }
        return new FileInputStream(fileToRead);
    }
}

