/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.model;

import io.github.sparqlanything.model.IRIArgument;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PropertyUtils {
    public static boolean getBooleanProperty(Properties p, String key, boolean defaultValue) {
        if (p.containsKey(key)) {
            return Boolean.parseBoolean(p.getProperty(key));
        }
        return defaultValue;
    }

    public static boolean getBooleanProperty(Properties p, IRIArgument key, boolean defaultValue) {
        return PropertyUtils.getBooleanProperty(p, key.toString(), defaultValue);
    }

    public static boolean getBooleanProperty(Properties p, IRIArgument key) {
        return PropertyUtils.getBooleanProperty(p, key.toString(), Boolean.parseBoolean(key.getDefaultValue()));
    }

    public static String getStringProperty(Properties p, String key, String defaultValue) {
        return p.getProperty(key, defaultValue);
    }

    public static String getStringProperty(Properties p, IRIArgument key, String defaultValue) {
        return PropertyUtils.getStringProperty(p, key.toString(), defaultValue);
    }

    public static String getStringProperty(Properties p, IRIArgument key) {
        if (key.getDefaultValue() != null) {
            return PropertyUtils.getStringProperty(p, key, key.getDefaultValue());
        }
        return PropertyUtils.getStringProperty(p, key, null);
    }

    public static Integer getIntegerProperty(Properties p, String key, Integer defaultValue) {
        if (p.containsKey(key)) {
            return Integer.parseInt(p.getProperty(key));
        }
        return defaultValue;
    }

    public static Integer getIntegerProperty(Properties p, IRIArgument key, Integer defaultValue) {
        return PropertyUtils.getIntegerProperty(p, key.toString(), defaultValue);
    }

    public static Integer getIntegerProperty(Properties p, IRIArgument key) {
        if (key.getDefaultValue() != null) {
            return PropertyUtils.getIntegerProperty(p, key, (Integer)Integer.parseInt(key.getDefaultValue()));
        }
        return PropertyUtils.getIntegerProperty(p, key, null);
    }

    public static List<String> getPropertyValues(Properties properties, String prefix) {
        int i;
        String propName;
        ArrayList<String> values = new ArrayList<String>();
        if (properties.containsKey(prefix)) {
            values.add(properties.getProperty(prefix));
        }
        if (properties.containsKey(propName = prefix + "." + (i = 0))) {
            values.add(properties.getProperty(propName));
        }
        propName = prefix + "." + ++i;
        while (properties.containsKey(propName)) {
            values.add(properties.getProperty(propName));
            propName = prefix + "." + ++i;
        }
        return values;
    }

    public static List<String> getPropertyValues(Properties properties, IRIArgument prefix) {
        return PropertyUtils.getPropertyValues(properties, prefix.toString());
    }
}

