/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDiff;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprNone;
import org.apache.jena.sparql.expr.ExprTripleTerm;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_Distinct;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_Multi;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_OneOrMoreN;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_Shortest;
import org.apache.jena.sparql.path.P_ZeroOrMore1;
import org.apache.jena.sparql.path.P_ZeroOrMoreN;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.PathVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpComponentsAnalyser
implements OpVisitor {
    private final Logger log = LoggerFactory.getLogger(OpComponentsAnalyser.class);
    private static final Node unionGraph = NodeFactory.createURI((String)"urn:x-arq:UnionGraph");
    private final List<Object> opComponents = new ArrayList<Object>();

    public List<Object> getOpComponents() {
        return Collections.unmodifiableList(this.opComponents);
    }

    public void visit(OpBGP opBGP) {
        this.log.trace(" - OpBGP - ", (Object)opBGP);
        this.log.trace("{}:", (Object)opBGP.getPattern().getList().toString());
        this.opComponents.addAll(opBGP.getPattern().getList());
    }

    public void visit(OpQuadPattern opQuadPattern) {
        this.log.trace(" - OpQuadPattern - ", (Object)opQuadPattern);
        this.opComponents.addAll(opQuadPattern.getPattern().getList());
    }

    public void visit(OpQuadBlock opQuadBlock) {
        this.log.trace(" - OpQuadBlock - ", (Object)opQuadBlock);
        this.opComponents.addAll(opQuadBlock.getPattern().getList());
    }

    public void visit(OpTriple opTriple) {
        this.log.trace(" - OpBGP - ", (Object)opTriple);
        this.opComponents.add(opTriple.getTriple());
    }

    public void visit(OpQuad opQuad) {
        this.log.trace(" - OpQuad - ", (Object)opQuad);
        this.opComponents.add(opQuad.getQuad());
    }

    public void visit(OpPath opPath) {
        this.log.trace(" - OpPath - {}", (Object)opPath.toString());
        opPath.getTriplePath().getPath().visit(new PathVisitor(){

            public void visit(P_Seq pathSeq) {
                pathSeq.getLeft().visit((PathVisitor)this);
                pathSeq.getRight().visit((PathVisitor)this);
            }

            public void visit(P_Alt pathAlt) {
                pathAlt.getLeft().visit((PathVisitor)this);
                pathAlt.getRight().visit((PathVisitor)this);
            }

            public void visit(P_OneOrMoreN path) {
                path.getSubPath().visit((PathVisitor)this);
            }

            public void visit(P_OneOrMore1 path) {
                path.getSubPath().visit((PathVisitor)this);
            }

            public void visit(P_ZeroOrMoreN path) {
                path.getSubPath().visit((PathVisitor)this);
            }

            public void visit(P_ZeroOrMore1 path) {
                path.getSubPath().visit((PathVisitor)this);
            }

            public void visit(P_ZeroOrOne path) {
                path.getSubPath().visit((PathVisitor)this);
            }

            public void visit(P_Shortest pathShortest) {
                pathShortest.getSubPath().visit((PathVisitor)this);
            }

            public void visit(P_Multi pathMulti) {
                pathMulti.getSubPath().visit((PathVisitor)this);
            }

            public void visit(P_Distinct pathDistinct) {
                pathDistinct.getSubPath().visit((PathVisitor)this);
            }

            public void visit(P_FixedLength pFixedLength) {
                pFixedLength.getSubPath().visit((PathVisitor)this);
            }

            public void visit(P_Mod pathMod) {
                pathMod.getSubPath().visit((PathVisitor)this);
            }

            public void visit(P_Inverse inversePath) {
                inversePath.getSubPath().visit((PathVisitor)this);
            }

            public void visit(P_NegPropSet pathNotOneOf) {
            }

            public void visit(P_ReverseLink pathNode) {
            }

            public void visit(P_Link pathNode) {
                OpComponentsAnalyser.this.opComponents.add(Triple.create((Node)Node.ANY, (Node)pathNode.getNode(), (Node)Node.ANY));
            }
        });
    }

    public void visit(OpTable opTable) {
    }

    public void visit(OpNull opNull) {
    }

    public void visit(OpProcedure opProcedure) {
        opProcedure.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpPropFunc opPropFunc) {
        this.opComponents.add(opPropFunc);
        opPropFunc.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpFilter opFilter) {
        this.log.trace("Sub Op Filter - {}", (Object)opFilter.getSubOp().getClass().toString());
        opFilter.getExprs().getList().forEach(e -> {
            this.log.trace("Exp - {} - {}", (Object)e.toString(), (Object)e.getClass().toString());
            this.extractFromExpression((Expr)e);
        });
        opFilter.getSubOp().visit((OpVisitor)this);
    }

    private List<Object> extractFromExpression(Expr e) {
        ArrayList<Object> result = new ArrayList<Object>();
        final OpComponentsAnalyser oca = this;
        e.visit(new ExprVisitor(){

            public void visit(ExprNone exprNone) {
                OpComponentsAnalyser.this.log.trace("Expr - exprNone");
            }

            public void visit(ExprAggregator eAgg) {
                OpComponentsAnalyser.this.log.trace("Expr - eAgg");
                eAgg.visit((ExprVisitor)this);
            }

            public void visit(ExprVar nv) {
                OpComponentsAnalyser.this.log.trace("Expr - ExprVar");
            }

            public void visit(NodeValue nv) {
                OpComponentsAnalyser.this.log.trace("Expr - NodeValue");
                if (nv.getNode().isURI()) {
                    OpComponentsAnalyser.this.opComponents.add(Triple.create((Node)Node.ANY, (Node)nv.getNode(), (Node)Node.ANY));
                }
            }

            public void visit(ExprTripleTerm tripleTerm) {
                OpComponentsAnalyser.this.log.trace("Expr - tripleTerm");
                OpComponentsAnalyser.this.opComponents.add(tripleTerm.getTriple());
            }

            public void visit(ExprFunctionOp funcOp) {
                OpComponentsAnalyser.this.log.trace("Expr - funcOp");
                if (funcOp.isGraphPattern()) {
                    funcOp.getGraphPattern().visit((OpVisitor)oca);
                }
                funcOp.getArgs().forEach(e -> {
                    OpComponentsAnalyser.this.log.trace("Arg - {}", (Object)e.getClass().toString());
                    e.visit((ExprVisitor)this);
                });
            }

            public void visit(ExprFunctionN func) {
                OpComponentsAnalyser.this.log.trace("Expr - funcOp - N");
                if (func.isGraphPattern()) {
                    func.getGraphPattern().visit((OpVisitor)oca);
                }
                func.getArgs().forEach(e -> e.visit((ExprVisitor)this));
            }

            public void visit(ExprFunction3 func) {
                OpComponentsAnalyser.this.log.trace("Expr - funcOp - 3");
                if (func.isGraphPattern()) {
                    func.getGraphPattern().visit((OpVisitor)oca);
                }
                func.getArgs().forEach(e -> e.visit((ExprVisitor)this));
            }

            public void visit(ExprFunction2 func) {
                OpComponentsAnalyser.this.log.trace("Expr - funcOp - 2");
                if (func.isGraphPattern()) {
                    func.getGraphPattern().visit((OpVisitor)oca);
                }
                func.getArgs().forEach(e -> e.visit((ExprVisitor)this));
            }

            public void visit(ExprFunction1 func) {
                OpComponentsAnalyser.this.log.trace("Expr - funcOp - 1");
                if (func.isGraphPattern()) {
                    func.getGraphPattern().visit((OpVisitor)oca);
                }
                func.getArgs().forEach(e -> e.visit((ExprVisitor)this));
            }

            public void visit(ExprFunction0 func) {
                OpComponentsAnalyser.this.log.trace("Expr - funcOp - 0");
                if (func.isGraphPattern()) {
                    func.getGraphPattern().visit((OpVisitor)oca);
                }
                func.getArgs().forEach(e -> e.visit((ExprVisitor)this));
            }
        });
        return result;
    }

    public void visit(OpGraph opGraph) {
        this.log.trace(" - OpGraph - ", (Object)opGraph);
        opGraph.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpService opService) {
        opService.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpDatasetNames opDatasetNames) {
    }

    public void visit(OpLabel opLabel) {
        opLabel.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpAssign opAssign) {
        opAssign.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpExtend opExtend) {
        opExtend.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpJoin opJoin) {
        opJoin.getLeft().visit((OpVisitor)this);
        opJoin.getRight().visit((OpVisitor)this);
    }

    public void visit(OpLeftJoin opLeftJoin) {
        opLeftJoin.getLeft().visit((OpVisitor)this);
        opLeftJoin.getRight().visit((OpVisitor)this);
    }

    public void visit(OpUnion opUnion) {
        opUnion.getLeft().visit((OpVisitor)this);
        opUnion.getRight().visit((OpVisitor)this);
    }

    public void visit(OpDiff opDiff) {
        opDiff.getLeft().visit((OpVisitor)this);
        opDiff.getRight().visit((OpVisitor)this);
    }

    public void visit(OpMinus opMinus) {
        opMinus.getLeft().visit((OpVisitor)this);
        opMinus.getRight().visit((OpVisitor)this);
    }

    public void visit(OpLateral opLateral) {
        opLateral.getLeft().visit((OpVisitor)this);
        opLateral.getRight().visit((OpVisitor)this);
    }

    public void visit(OpConditional opConditional) {
        opConditional.getLeft().visit((OpVisitor)this);
        opConditional.getRight().visit((OpVisitor)this);
    }

    public void visit(OpSequence opSequence) {
        for (Op o : opSequence.getElements()) {
            o.visit((OpVisitor)this);
        }
    }

    public void visit(OpDisjunction opDisjunction) {
        for (Op o : opDisjunction.getElements()) {
            o.visit((OpVisitor)this);
        }
    }

    public void visit(OpList opList) {
        opList.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpOrder opOrder) {
        opOrder.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpProject opProject) {
        opProject.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpReduced opReduced) {
        opReduced.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpDistinct opDistinct) {
        opDistinct.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpSlice opSlice) {
        opSlice.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpGroup opGroup) {
        opGroup.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpTopN opTopN) {
        opTopN.getSubOp().visit((OpVisitor)this);
    }

    public boolean match(Node graph, Node subject, Node predicate, Node object) {
        if (this.opComponents.isEmpty()) {
            return true;
        }
        for (Object o : this.opComponents) {
            OpPropFunc op;
            Triple t;
            Quad q;
            if (!(o instanceof Quad ? this.matchQuad(q = (Quad)o, graph, subject, predicate, object) : (o instanceof Triple ? !((t = (Triple)o).getSubject().isConcrete() && !t.getSubject().matches(subject) || !this.predicateMatch(t.getPredicate(), predicate) || t.getObject().isConcrete() && !t.getObject().matches(object)) : !(!(o instanceof OpPropFunc) || (op = (OpPropFunc)o).getSubjectArgs().getArg().isConcrete() && !op.getSubjectArgs().getArg().matches(subject) || !this.predicateMatch(op.getProperty(), predicate) || op.getObjectArgs().getArg().isConcrete() && !op.getObjectArgs().getArg().matches(object))))) continue;
            return true;
        }
        return false;
    }

    protected boolean matchQuad(Quad q, Node graph, Node subject, Node predicate, Node object) {
        return !(q.getGraph().isConcrete() && !q.getGraph().matches(graph) && !q.getGraph().matches(unionGraph) || q.getSubject().isConcrete() && !q.getSubject().matches(subject) || !this.predicateMatch(q.getPredicate(), predicate) || q.getObject().isConcrete() && !q.getObject().matches(object));
    }

    private boolean predicateMatch(Node queryPredicate, Node dataPredicate) {
        if (queryPredicate.isConcrete() && queryPredicate.getURI().equals("http://sparql.xyz/facade-x/ns/anySlot")) {
            return dataPredicate.getURI().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_");
        }
        return !queryPredicate.isConcrete() || queryPredicate.matches(dataPredicate);
    }
}

