/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.model;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPHelper {
    private static final Logger log = LoggerFactory.getLogger(HTTPHelper.class);
    public static final String HTTPCLIENT_PREFIX = "http.client.";
    public static final String HTTPHEADER_PREFIX = "http.header.";
    public static final String HTTPQUERY_PREFIX = "http.query.";
    public static final String HTTPFORM_PREFIX = "http.form.";
    public static final String HTTPMETHOD = "http.method";
    public static final String HTTPPAYLOAD = "http.payload";
    public static final String HTTPPROTOCOL = "http.protocol";
    public static final String HTTPPAUTHUSER = "http.auth.user";
    public static final String HTTPPAUTHPASSWORD = "http.auth.password";
    public static final String HTTPFOLLOWREDIRECT = "http.redirect";
    public static final String[] RELEVANT_PROPERTIES = new String[]{"http.client.", "http.header.", "http.query.", "http.form.", "http.method", "http.payload", "http.protocol", "http.redirect"};

    public static boolean isProperty(String prefix, String key) {
        return key.startsWith(prefix);
    }

    public static String getProperty(String prefix, Object property) {
        return ((String)property).substring(prefix.length());
    }

    public static Properties relevantProperties(Properties properties) {
        Properties relevant = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            for (String property : RELEVANT_PROPERTIES) {
                if (!((String)entry.getKey()).equals(property) && (!property.endsWith(".") || !((String)entry.getKey()).startsWith(property))) continue;
                relevant.put(entry.getKey(), entry.getValue());
            }
        }
        return relevant;
    }

    public static HttpClientBuilder setupClientBuilder(URL url, Properties properties) {
        HttpClientBuilder builder = HttpClients.custom();
        if (!properties.containsKey("http.client.useSystemProperties") || Boolean.parseBoolean((String)properties.get("http.client.useSystemProperties"))) {
            builder.useSystemProperties();
        }
        Method[] methods = builder.getClass().getMethods();
        for (Object key : properties.keySet()) {
            if (!HTTPHelper.isProperty(HTTPCLIENT_PREFIX, (String)key)) continue;
            String methodName = HTTPHelper.getProperty(HTTPCLIENT_PREFIX, key);
            String[] values = ((String)properties.get(key)).split(",");
            for (Method method : methods) {
                try {
                    if (!method.getName().equals(methodName)) continue;
                    if (methodName.equals("setProxy")) {
                        log.info("Setting proxy: {}:{}", (Object)values[0], (Object)values[1]);
                        builder.setProxy(new HttpHost(values[0], Integer.parseInt(values[1])));
                        continue;
                    }
                    if (method.getParameterCount() == 0) {
                        boolean v = Boolean.parseBoolean((String)properties.get(key));
                        if (!v) continue;
                        method.invoke((Object)builder, new Object[0]);
                        continue;
                    }
                    if (method.getParameterCount() == 1 && values.length == 1) {
                        Class<?> parType = method.getParameterTypes()[0];
                        method.invoke((Object)builder, parType.cast(properties.get(key)));
                        continue;
                    }
                    if (method.getParameterCount() != 2 || values.length != 2) continue;
                    Class<?> parType1 = method.getParameterTypes()[0];
                    Class<?> parType2 = method.getParameterTypes()[1];
                    method.invoke((Object)builder, parType1.cast(values[0]), parType1.cast(values[1]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.error("Cannot run method for property configuration: {} -> {}", key, properties.get(key));
                    log.error("Exception details:", (Throwable)e);
                }
            }
        }
        Boolean followRedirect = true;
        if (properties.containsKey(HTTPFOLLOWREDIRECT)) {
            followRedirect = Boolean.parseBoolean((String)properties.get(HTTPFOLLOWREDIRECT));
        }
        log.debug("Following redirect responses: {}", (Object)followRedirect);
        if (followRedirect.booleanValue()) {
            builder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        }
        if (properties.containsKey(HTTPPAUTHUSER) && properties.containsKey(HTTPPAUTHPASSWORD)) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)new UsernamePasswordCredentials((String)properties.get(HTTPPAUTHUSER), (String)properties.get(HTTPPAUTHPASSWORD)));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    public static HttpUriRequest buildRequest(URL url, Properties properties) {
        void var11_22;
        String uri;
        Object p;
        String method = "GET";
        if (properties.containsKey(HTTPMETHOD)) {
            method = ((String)properties.get(HTTPMETHOD)).toUpperCase();
        }
        String version = "HTTP/1.1";
        if (properties.containsKey(HTTPPROTOCOL)) {
            version = ((String)properties.get(HTTPPROTOCOL)).toUpperCase();
        }
        if (version.equals("HTTP/1.1")) {
            protocol = HttpVersion.HTTP_1_1;
        } else if (version.equals("HTTP/1.0")) {
            protocol = HttpVersion.HTTP_1_0;
        } else if (version.equals("HTTP/0.9")) {
            protocol = HttpVersion.HTTP_0_9;
        } else {
            log.error("Invalid protocol: {}, using 1.1", (Object)version);
            protocol = HttpVersion.HTTP_1_1;
        }
        ArrayList<BasicNameValuePair> query = new ArrayList<BasicNameValuePair>();
        ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        for (Object key : properties.keySet()) {
            if (HTTPHelper.isProperty(HTTPHEADER_PREFIX, (String)key)) {
                headers.add(new BasicHeader(HTTPHelper.getProperty(HTTPHEADER_PREFIX, (String)key), (String)properties.get(key)));
                continue;
            }
            if (HTTPHelper.isProperty(HTTPQUERY_PREFIX, (String)key)) {
                p = HTTPHelper.getProperty(HTTPQUERY_PREFIX, (String)key);
                if (((String)p).matches("\\.[0-9]+$")) {
                    p = ((String)p).substring(0, ((String)p).indexOf(46) + 1);
                }
                query.add(new BasicNameValuePair((String)p, (String)properties.get(key)));
                continue;
            }
            if (!HTTPHelper.isProperty(HTTPFORM_PREFIX, (String)key)) continue;
            p = HTTPHelper.getProperty(HTTPFORM_PREFIX, (String)key);
            if (((String)p).matches("\\.[0-9]+$")) {
                p = ((String)p).substring(0, ((String)p).indexOf(46) + 1);
            }
            form.add(new BasicNameValuePair((String)p, (String)properties.get(key)));
        }
        try {
            uri = new URIBuilder(url.toString()).addParameters(query).build().toString();
        }
        catch (URISyntaxException e) {
            log.error("Exception when building URI with parameters");
            log.error("Details", (Throwable)e);
            log.warn("Skipping query string parameters");
            uri = url.toString();
        }
        p = method;
        int n = -1;
        switch (((String)p).hashCode()) {
            case 70454: {
                if (!((String)p).equals("GET")) break;
                boolean bl = false;
                break;
            }
            case 2461856: {
                if (!((String)p).equals("POST")) break;
                boolean bl = true;
                break;
            }
            case 79599: {
                if (!((String)p).equals("PUT")) break;
                int n2 = 2;
                break;
            }
            case 2012838315: {
                if (!((String)p).equals("DELETE")) break;
                int n3 = 3;
                break;
            }
            case -531492226: {
                if (!((String)p).equals("OPTIONS")) break;
                int n4 = 4;
                break;
            }
            case 2213344: {
                if (!((String)p).equals("HEAD")) break;
                int n5 = 5;
                break;
            }
            case 80083237: {
                if (!((String)p).equals("TRACE")) break;
                int n6 = 6;
                break;
            }
            case 75900968: {
                if (!((String)p).equals("PATCH")) break;
                int n7 = 7;
            }
        }
        HttpGet request = switch (var11_22) {
            case 0 -> new HttpGet(uri);
            case 1 -> new HttpPost(uri);
            case 2 -> new HttpPut(uri);
            case 3 -> new HttpDelete(uri);
            case 4 -> new HttpOptions(uri);
            case 5 -> new HttpHead(uri);
            case 6 -> new HttpTrace(uri);
            case 7 -> new HttpPatch(uri);
            default -> {
                log.error("Method not supported: {}", (Object)method);
                throw new IllegalArgumentException("Unsupported method: " + method);
            }
        };
        for (Header header : headers) {
            request.addHeader(header);
        }
        if (properties.containsKey(HTTPPAYLOAD)) {
            if (!form.isEmpty()) {
                log.warn("Cannot send 'form' and 'payload' at the same time! Content from 'payload' will be used and content from 'form' will be ignored");
            }
            String payload = (String)properties.get(HTTPPAYLOAD);
            BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
            basicHttpEntity.setContent(IOUtils.toInputStream((String)payload, (Charset)StandardCharsets.UTF_8));
            if (request instanceof HttpPost) {
                HttpPost post = (HttpPost)request;
                post.setEntity((HttpEntity)basicHttpEntity);
            } else if (request instanceof HttpPut) {
                HttpPut put = (HttpPut)request;
                put.setEntity((HttpEntity)basicHttpEntity);
            }
        } else if (request instanceof HttpPost && !form.isEmpty()) {
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(form);
                ((HttpPost)request).setEntity((HttpEntity)entity);
                request.setHeader("Content-type", "application/x-www-form-urlencoded");
            }
            catch (UnsupportedEncodingException e) {
                log.error("Problem when encoding form data", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return request;
    }

    public static final boolean isSuccessful(CloseableHttpResponse response) {
        return response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() <= 299;
    }

    public static final boolean isNotFound(CloseableHttpResponse response) {
        return response.getStatusLine().getStatusCode() == 404;
    }

    public static final boolean isRedirect(CloseableHttpResponse response) {
        return response.getStatusLine().getStatusCode() >= 300 && response.getStatusLine().getStatusCode() <= 399;
    }

    public static final boolean isClientError(CloseableHttpResponse response) {
        return response.getStatusLine().getStatusCode() >= 400 && response.getStatusLine().getStatusCode() <= 499;
    }

    public static final boolean isServerError(CloseableHttpResponse response) {
        return response.getStatusLine().getStatusCode() >= 500 && response.getStatusLine().getStatusCode() <= 599;
    }

    public static final CloseableHttpResponse getInputStream(URL url, Properties properties) throws IOException {
        log.debug("Downloading via HTTP Client");
        HttpClientBuilder builder = HTTPHelper.setupClientBuilder(url, properties);
        CloseableHttpClient client = builder.build();
        HttpUriRequest request = HTTPHelper.buildRequest(url, properties);
        if (log.isDebugEnabled()) {
            log.debug("* Request line: {}", (Object)request.getRequestLine());
            for (Header h : request.getAllHeaders()) {
                log.debug("> {}: {}", (Object)h.getName(), (Object)h.getValue());
            }
        }
        CloseableHttpResponse response = client.execute(request);
        log.debug("* Status line: {}", (Object)response.getStatusLine());
        for (Header h : response.getAllHeaders()) {
            log.debug("< {}: {}", (Object)h.getName(), (Object)h.getValue());
        }
        log.debug("Downloaded {} :: {}", (Object)url, (Object)response.getStatusLine().getStatusCode());
        return response;
    }

    public static boolean checkHostIsReachable(String url) {
        Object host = null;
        try {
            return HTTPHelper.checkHostIsReachable(new URL(url));
        }
        catch (MalformedURLException e) {
            log.debug("URL is malformed: {}", (Object)url);
            return false;
        }
    }

    public static boolean checkHostIsReachable(URL url) {
        String host = url.getHost();
        try {
            InetAddress.getByName(host);
            return true;
        }
        catch (UnknownHostException uhe) {
            log.debug("Host is not reachable: {}", (Object)host);
            return false;
        }
    }
}

