/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.model;

import io.github.sparqlanything.model.BaseFacadeXBuilder;
import io.github.sparqlanything.model.FacadeXGraphBuilder;
import io.github.sparqlanything.model.IRIArgument;
import io.github.sparqlanything.model.PropertyUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb1.TDB1Factory;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.tdb2.TDB2Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseFacadeXGraphBuilder
extends BaseFacadeXBuilder
implements FacadeXGraphBuilder {
    protected static final Logger log = LoggerFactory.getLogger(BaseFacadeXGraphBuilder.class);
    protected DatasetGraph datasetGraph;

    public BaseFacadeXGraphBuilder(Properties properties) {
        super(properties);
        this.initialiseDatasetGraph(properties);
        this.datasetGraph.begin(TxnType.WRITE);
    }

    private void initialiseDatasetGraph(Properties properties) {
        String ondiskPath = PropertyUtils.getStringProperty(properties, IRIArgument.ONDISK);
        if (ondiskPath != null) {
            log.trace("Using TDB2");
            boolean ondisk_reuse = PropertyUtils.getBooleanProperty(properties, IRIArgument.ONDISK_REUSE);
            File ondiskFile = new File(ondiskPath);
            log.debug("Ondisk reuse {}", (Object)ondisk_reuse);
            if (!ondisk_reuse && ondiskFile.isDirectory() && ondiskFile.exists()) {
                log.trace("Deleting directory: {}", (Object)ondiskFile.getAbsolutePath());
                try {
                    FileUtils.deleteDirectory((File)ondiskFile);
                }
                catch (IOException e) {
                    if (TDB1Factory.inUseLocation((String)ondiskPath)) {
                        DatasetGraph dg = TDB2Factory.connectDataset((String)ondiskPath).asDatasetGraph();
                        dg.end();
                        Txn.executeWrite((Transactional)dg, () -> ((DatasetGraph)dg).clear());
                        log.warn("Clearing TBD instead of deleting the TDB folder.");
                    }
                    throw new RuntimeException(e);
                }
            }
            this.datasetGraph = TDB2Factory.connectDataset((String)ondiskPath).asDatasetGraph();
            if (this.datasetGraph.isInTransaction()) {
                this.datasetGraph.end();
            }
        } else {
            log.debug("Using in memory DatasetGraph");
            this.datasetGraph = DatasetGraphFactory.create();
        }
    }

    @Override
    public boolean add(Node graph, Node subject, Node predicate, Node object) {
        if (this.p_null_string != null && object.isLiteral() && object.getLiteral().getLexicalForm().equals(this.p_null_string)) {
            return false;
        }
        Triple t = Triple.create((Node)subject, (Node)predicate, (Node)object);
        if (this.datasetGraph.getGraph(graph).contains(t)) {
            return false;
        }
        this.datasetGraph.getGraph(graph).add(t);
        return true;
    }

    public Model getModel() {
        return ModelFactory.createModelForGraph((Graph)this.getDatasetGraph().getUnionGraph());
    }

    @Override
    public DatasetGraph getDatasetGraph() {
        if (!DatabaseMgr.isTDB2((DatasetGraph)this.datasetGraph)) {
            this.datasetGraph.addGraph(NodeFactory.createURI((String)"urn:x-arq:DefaultGraph"), this.datasetGraph.getUnionGraph());
        }
        if (this.p_generate_predicate_labels) {
            this.addPredicateLabelTriples(this.datasetGraph.getDefaultGraph());
        }
        return this.datasetGraph;
    }
}

