/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.model;

import io.github.sparqlanything.model.FacadeXComponentHandler;
import io.github.sparqlanything.model.FacadeXNodeBuilder;
import io.github.sparqlanything.model.FacadeXQuadHandler;
import io.github.sparqlanything.model.IRIArgument;
import io.github.sparqlanything.model.PropertyUtils;
import io.github.sparqlanything.model.Triplifier;
import java.net.URI;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public abstract class BaseFacadeXBuilder
implements FacadeXNodeBuilder,
FacadeXQuadHandler,
FacadeXComponentHandler {
    protected static final Set<String> predicateKeys = new HashSet<String>();
    protected final Properties properties;
    protected final boolean p_blank_nodes;
    protected final String p_namespace;
    protected final String p_root;
    protected final boolean p_trim_strings;
    protected final String p_null_string;
    protected final boolean p_use_rdfs_member;
    protected final boolean p_reify_slot_statements;
    protected final boolean p_generate_predicate_labels;

    public BaseFacadeXBuilder(Properties properties) {
        this.properties = properties;
        this.p_blank_nodes = PropertyUtils.getBooleanProperty(properties, IRIArgument.BLANK_NODES);
        this.p_namespace = PropertyUtils.getStringProperty(properties, IRIArgument.NAMESPACE);
        this.p_root = Triplifier.getRootArgument(properties);
        this.p_trim_strings = PropertyUtils.getBooleanProperty(properties, IRIArgument.TRIM_STRINGS);
        this.p_null_string = PropertyUtils.getStringProperty(properties, IRIArgument.NULL_STRING);
        this.p_use_rdfs_member = PropertyUtils.getBooleanProperty(properties, IRIArgument.USE_RDFS_MEMBER);
        this.p_reify_slot_statements = PropertyUtils.getBooleanProperty(properties, IRIArgument.ANNOTATE_TRIPLES_WITH_SLOT_KEYS);
        this.p_generate_predicate_labels = PropertyUtils.getBooleanProperty(properties, IRIArgument.GENERATE_PREDICATE_LABELS);
    }

    protected String keepLabel(String key) {
        if (this.p_generate_predicate_labels) {
            predicateKeys.add(key);
        }
        return key;
    }

    protected void addPredicateLabelTriples(Graph graph) {
        if (this.p_generate_predicate_labels) {
            for (String key : predicateKeys) {
                graph.add(this.key2predicate(key), RDFS.label.asNode(), NodeFactory.createLiteralString((String)key));
            }
        }
    }

    @Override
    public boolean addContainer(String dataSourceId, String containerId, String slotKey, String childContainerId) {
        return this.add(this.dataSourceId2node(dataSourceId), this.container2node(containerId, dataSourceId), this.key2predicate(this.keepLabel(slotKey)), this.container2node(childContainerId, dataSourceId));
    }

    @Override
    public boolean addContainer(String dataSourceId, String containerId, URI customKey, String childContainerId) {
        return this.add(this.dataSourceId2node(dataSourceId), this.container2node(containerId, dataSourceId), NodeFactory.createURI((String)customKey.toString()), this.container2node(childContainerId, dataSourceId));
    }

    @Override
    public boolean addContainer(String dataSourceId, String containerId, Integer slotKey, String childContainerId) {
        return this.addSlotStatement(dataSourceId, containerId, slotKey, childContainerId, true);
    }

    @Override
    public boolean addType(String dataSourceId, String containerId, String typeId) {
        return this.add(this.dataSourceId2node(dataSourceId), this.container2node(containerId, dataSourceId), RDF.type.asNode(), this.key2predicate(this.keepLabel(typeId)));
    }

    @Override
    public boolean addType(String dataSourceId, String containerId, URI type) {
        return this.add(this.dataSourceId2node(dataSourceId), this.container2node(containerId, dataSourceId), RDF.type.asNode(), NodeFactory.createURI((String)type.toString()));
    }

    @Override
    public boolean addValue(String dataSourceId, String containerId, String slotKey, Object value) {
        return this.add(this.dataSourceId2node(dataSourceId), this.container2node(containerId, dataSourceId), this.key2predicate(this.keepLabel(slotKey)), this.value2node(value));
    }

    @Override
    public boolean addValue(String dataSourceId, String containerId, URI customKey, Object value) {
        return this.add(this.dataSourceId2node(dataSourceId), this.container2node(containerId, dataSourceId), NodeFactory.createURI((String)customKey.toString()), this.value2node(value));
    }

    @Override
    public boolean addValue(String dataSourceId, String containerId, Integer slotKey, Object value) {
        return this.addSlotStatement(dataSourceId, containerId, slotKey, value, false);
    }

    @Override
    public boolean addRoot(String dataSourceId) {
        return this.add(this.dataSourceId2node(dataSourceId), this.container2node("", dataSourceId), RDF.type.asNode(), NodeFactory.createURI((String)"http://sparql.xyz/facade-x/ns/root"));
    }

    private boolean addSlotStatement(String dataSourceId, String containerId, Integer slotKey, Object object, boolean isObjectContainer) {
        Node o;
        Node g = this.dataSourceId2node(dataSourceId);
        Node s = this.container2node(containerId, dataSourceId);
        Node p = this.p_use_rdfs_member ? RDFS.member.asNode() : RDF.li((int)slotKey).asNode();
        Node node = o = isObjectContainer ? this.container2node(object.toString(), dataSourceId) : this.value2node(object);
        if (this.p_reify_slot_statements) {
            this.add(g, NodeFactory.createTripleNode((Node)s, (Node)p, (Node)o), NodeFactory.createURI((String)"http://sparql.xyz/facade-x/ns/slot-key"), NodeFactory.createLiteral((String)slotKey.toString(), (RDFDatatype)XSDDatatype.XSDinteger));
        }
        return this.add(g, s, p, o);
    }

    public Node container2node(String containerId, String dataSourceId) {
        if (this.p_blank_nodes) {
            return this.container2BlankNode(containerId);
        }
        return this.container2URI(containerId, dataSourceId);
    }

    @Override
    public String getRootURI(String dataSourceId) {
        return this.p_root.concat(dataSourceId);
    }

    @Override
    public String getNamespace() {
        return this.p_namespace;
    }

    @Override
    public Node value2node(Object value) {
        if (this.p_trim_strings && value instanceof String) {
            value = ((String)value).trim();
        }
        return FacadeXNodeBuilder.super.value2node(value);
    }
}

