/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.metadata;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.google.common.collect.Sets;
import io.github.sparqlanything.model.FacadeXGraphBuilder;
import io.github.sparqlanything.model.Triplifier;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

@io.github.sparqlanything.model.annotations.Triplifier
public class MetadataTriplifier
implements Triplifier {
    public void triplify(Properties properties, FacadeXGraphBuilder builder) throws IOException {
        URL url = Triplifier.getLocation((Properties)properties);
        if (url == null) {
            return;
        }
        String dataSourceId = "";
        String root = "";
        File f = new File(FilenameUtils.getName((String)url.getFile()));
        FileUtils.copyURLToFile((URL)url, (File)f);
        this.readBasicAttributes(f.toPath(), dataSourceId, root, builder);
        try {
            this.readMetadata(f, dataSourceId, root, builder);
        }
        catch (ImageProcessingException | IOException e) {
            log.error(e.getMessage());
        }
        f.delete();
    }

    private void readBasicAttributes(Path p, String dataSourceId, String root, FacadeXGraphBuilder builder) throws IOException {
        BasicFileAttributes attr = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
        builder.addValue(dataSourceId, root, "size", (Object)attr.size());
    }

    private void readMetadata(File f, String dataSourceId, String root, FacadeXGraphBuilder builder) throws IOException, ImageProcessingException {
        Metadata metadata = ImageMetadataReader.readMetadata((File)f);
        for (Directory directory : metadata.getDirectories()) {
            for (Tag tag : directory.getTags()) {
                builder.addValue(dataSourceId, root, tag.getTagName(), (Object)tag.getDescription());
            }
        }
    }

    public Set<String> getMimeTypes() {
        return Sets.newHashSet();
    }

    public Set<String> getExtensions() {
        return Sets.newHashSet();
    }
}

