/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine.functions.reflection;

import io.github.sparqlanything.engine.functions.reflection.Converters;
import io.github.sparqlanything.engine.functions.reflection.IncompatibleObjectException;
import io.github.sparqlanything.engine.functions.reflection.NoConverterException;
import io.github.sparqlanything.engine.functions.reflection.NodeValueConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.FunctionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionFunctionFactory {
    public static final Logger logger = LoggerFactory.getLogger(ReflectionFunctionFactory.class);
    private static ReflectionFunctionFactory instance = null;
    private final Map<Class<?>, NodeValueConverter<?, ?>> converters = new HashMap();
    private final Map<Class<? extends NodeValue>, Set<NodeValueConverter<?, ?>>> nodeValueConverters = new HashMap();

    public ReflectionFunctionFactory() {
        this.register(new Converters.CharConverter());
        this.converters.put(Character.TYPE, new Converters.CharConverter());
        this.register(new Converters.StringConverter());
        this.converters.put(CharSequence.class, new Converters.StringConverter());
        this.converters.put(String.class, new Converters.StringConverter());
        this.register(new Converters.LongConverter());
        this.converters.put(Long.TYPE, new Converters.LongConverter());
        this.register(new Converters.DoubleConverter());
        this.converters.put(Double.TYPE, new Converters.DoubleConverter());
        this.register(new Converters.IntegerConverter());
        this.converters.put(Integer.TYPE, new Converters.IntegerConverter());
        this.register(new Converters.BooleanConverter());
        this.converters.put(Boolean.TYPE, new Converters.BooleanConverter());
        this.register(new Converters.FloatConverter());
        this.converters.put(Float.TYPE, new Converters.FloatConverter());
    }

    public final void register(NodeValueConverter converter) {
        this.converters.put(converter.getType(), converter);
        if (!this.nodeValueConverters.containsKey(converter.getNodeValueType())) {
            this.nodeValueConverters.put(converter.getNodeValueType(), new HashSet());
        }
        this.nodeValueConverters.get(converter.getNodeValueType()).add(converter);
    }

    public static ReflectionFunctionFactory get() {
        if (instance == null) {
            instance = new ReflectionFunctionFactory();
        }
        return instance;
    }

    public NodeValueConverter<?, ?> getConverter(Class<?> clazz) throws NoConverterException {
        if (!this.converters.containsKey(clazz)) {
            throw new NoConverterException(clazz);
        }
        return this.converters.get(clazz);
    }

    public FunctionFactory makeFunction(Class<?> type, String methodName) {
        Method[] methods = type.getMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : methods) {
            if (!m.getName().equals(methodName)) continue;
            list.add(m);
        }
        return this.makeFunction(list.toArray(new Method[list.size()]));
    }

    public FunctionFactory makeFunction(Method ... methods) {
        return this.makeFunction(false, methods);
    }

    public FunctionFactory makeFunction(boolean functor, Method ... methods) {
        String methodName = methods[0].getName();
        ReflectionFunction function = new ReflectionFunction(methodName, methods);
        function.isFunctor(functor);
        return s -> function;
    }

    public class ReflectionFunction
    extends FunctionBase {
        private final Map<Integer, List<Method>> methods = new HashMap<Integer, List<Method>>();
        private final String name;
        private boolean functor = false;

        public ReflectionFunction(String name, Method ... methodList) {
            this.name = name;
            for (Method method : methodList) {
                int len = method.getParameterTypes().length;
                if (!this.methods.containsKey(len)) {
                    this.methods.put(len, new ArrayList());
                }
                this.methods.get(len).add(method);
            }
        }

        public NodeValue exec(List<NodeValue> args) {
            Method method = this.findMethod(args);
            try {
                Object o;
                NodeValueConverter<?, ?> returnTypeConverter = ReflectionFunctionFactory.this.getConverter(method.getReturnType());
                if (!Modifier.isStatic(method.getModifiers())) {
                    if (this.functor) {
                        Object[] arguments = this.createArguments(args, method.getParameterTypes());
                        o = method.invoke(method.getDeclaringClass().getConstructor(new Class[0]).newInstance(new Object[0]), arguments);
                    } else {
                        NodeValueConverter<?, ?> invokingOn = ReflectionFunctionFactory.this.getConverter(method.getDeclaringClass());
                        Object[] arguments = this.createArguments(args.subList(1, args.size()), method.getParameterTypes());
                        o = method.invoke(invokingOn.asType(args.get(0)), arguments);
                    }
                } else {
                    Object[] arguments = this.createArguments(args, method.getParameterTypes());
                    o = method.invoke(null, arguments);
                }
                return returnTypeConverter.objectAsNodeValue(o);
            }
            catch (IncompatibleObjectException | NoConverterException | IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        private Method findMethod(List<NodeValue> args) {
            HashSet<Integer> methodsArgs = new HashSet<Integer>();
            for (Map.Entry<Integer, List<Method>> ms : this.methods.entrySet()) {
                for (Method m : ms.getValue()) {
                    if (Modifier.isStatic(m.getModifiers())) {
                        methodsArgs.add(m.getParameterCount());
                        if (!this.compatible(args, m)) continue;
                        return m;
                    }
                    if (this.functor) {
                        methodsArgs.add(m.getParameterCount());
                        if (!this.compatible(args, m)) continue;
                        return m;
                    }
                    methodsArgs.add(m.getParameterCount() + 1);
                    ArrayList<NodeValue> args2 = new ArrayList<NodeValue>(args);
                    args2.remove(0);
                    if (!this.compatible(args2, m)) continue;
                    return m;
                }
            }
            throw new QueryBuildException("Function '" + this.name + "' takes any of the following number of arguments: " + String.valueOf(methodsArgs) + ", " + args.size() + " given instead.");
        }

        private Object[] createArguments(List<NodeValue> arguments, Class<?>[] parameterTypes) throws NoConverterException {
            Object[] args = new Object[arguments.size()];
            for (int i = 0; i < arguments.size(); ++i) {
                args[i] = ReflectionFunctionFactory.this.getConverter(parameterTypes[i]).asType(arguments.get(i));
            }
            return args;
        }

        private boolean compatible(List<NodeValue> args, Method m) {
            if (args.size() == m.getParameterCount()) {
                for (int a = 0; a < m.getParameterCount(); ++a) {
                    Class<?> par = m.getParameterTypes()[a];
                    if (ReflectionFunctionFactory.this.converters.containsKey(par) && ReflectionFunctionFactory.this.converters.get(par).compatibleWith(args.get(a))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void checkBuild(String uri, ExprList args) {
        }

        public void isFunctor(boolean functor) {
            this.functor = functor;
        }
    }
}

