/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine.functions.reflection;

import io.github.sparqlanything.engine.functions.reflection.NodeValueConverter;
import java.util.Calendar;
import java.util.Date;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueBoolean;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDecimal;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDouble;
import org.apache.jena.sparql.expr.nodevalue.NodeValueFloat;
import org.apache.jena.sparql.expr.nodevalue.NodeValueInteger;
import org.apache.jena.sparql.expr.nodevalue.NodeValueString;

public class Converters {

    public static class DateConverter
    implements NodeValueConverter<Date, NodeValue> {
        @Override
        public Class<Date> getType() {
            return Date.class;
        }

        @Override
        public Class<NodeValue> getNodeValueType() {
            return NodeValue.class;
        }

        @Override
        public Date asType(NodeValue nodeValue) {
            return nodeValue.getDateTime().toGregorianCalendar().getTime();
        }

        @Override
        public NodeValue asNodeValue(Date object) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(object);
            return NodeValue.makeDate((Calendar)cal);
        }

        @Override
        public boolean compatibleWith(NodeValue nodeValue) {
            return nodeValue.getDateTime() != null;
        }
    }

    public static class LongConverter
    implements NodeValueConverter<Long, NodeValueDecimal> {
        @Override
        public Class<Long> getType() {
            return Long.class;
        }

        @Override
        public Class<NodeValueDecimal> getNodeValueType() {
            return NodeValueDecimal.class;
        }

        @Override
        public Long asType(NodeValue nodeValue) {
            return nodeValue.getDecimal().longValue();
        }

        @Override
        public NodeValueDecimal asNodeValue(Long object) {
            return (NodeValueDecimal)NodeValue.makeDecimal((long)object);
        }
    }

    public static class DoubleConverter
    implements NodeValueConverter<Double, NodeValueDouble> {
        @Override
        public Class<Double> getType() {
            return Double.class;
        }

        @Override
        public Class<NodeValueDouble> getNodeValueType() {
            return NodeValueDouble.class;
        }

        @Override
        public Double asType(NodeValue nodeValue) {
            return nodeValue.getDouble();
        }

        @Override
        public NodeValueDouble asNodeValue(Double object) {
            return (NodeValueDouble)NodeValue.makeDouble((double)object);
        }
    }

    public static class FloatConverter
    implements NodeValueConverter<Float, NodeValueFloat> {
        @Override
        public Class<Float> getType() {
            return Float.class;
        }

        @Override
        public Class<NodeValueFloat> getNodeValueType() {
            return NodeValueFloat.class;
        }

        @Override
        public Float asType(NodeValue nodeValue) {
            return Float.valueOf(nodeValue.getFloat());
        }

        @Override
        public NodeValueFloat asNodeValue(Float object) {
            return (NodeValueFloat)NodeValue.makeFloat((float)object.floatValue());
        }
    }

    public static class BooleanConverter
    implements NodeValueConverter<Boolean, NodeValueBoolean> {
        @Override
        public Class<Boolean> getType() {
            return Boolean.class;
        }

        @Override
        public Class<NodeValueBoolean> getNodeValueType() {
            return NodeValueBoolean.class;
        }

        @Override
        public Boolean asType(NodeValue nodeValue) {
            return nodeValue.getBoolean();
        }

        @Override
        public NodeValueBoolean asNodeValue(Boolean object) {
            return (NodeValueBoolean)NodeValue.makeBoolean((boolean)object);
        }
    }

    public static class IntegerConverter
    implements NodeValueConverter<Integer, NodeValueInteger> {
        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public Class<NodeValueInteger> getNodeValueType() {
            return NodeValueInteger.class;
        }

        @Override
        public Integer asType(NodeValue nodeValue) {
            return nodeValue.getInteger().intValue();
        }

        @Override
        public NodeValueInteger asNodeValue(Integer object) {
            return (NodeValueInteger)NodeValue.makeInteger((long)object.intValue());
        }
    }

    public static class StringConverter
    implements NodeValueConverter<String, NodeValueString> {
        @Override
        public Class<String> getType() {
            return String.class;
        }

        @Override
        public Class<NodeValueString> getNodeValueType() {
            return NodeValueString.class;
        }

        @Override
        public String asType(NodeValue nodeValue) {
            if (nodeValue.isLiteral() && nodeValue.isString()) {
                return nodeValue.getString();
            }
            return nodeValue.asString();
        }

        @Override
        public NodeValueString asNodeValue(String object) {
            return (NodeValueString)NodeValue.makeString((String)object);
        }
    }

    public static class CharConverter
    implements NodeValueConverter<Character, NodeValueString> {
        @Override
        public Class<Character> getType() {
            return Character.class;
        }

        @Override
        public Class<NodeValueString> getNodeValueType() {
            return NodeValueString.class;
        }

        @Override
        public Character asType(NodeValue nodeValue) {
            if (nodeValue.isLiteral() && nodeValue.isString()) {
                return Character.valueOf(nodeValue.getString().charAt(0));
            }
            return Character.valueOf(nodeValue.asString().charAt(0));
        }

        @Override
        public NodeValueString asNodeValue(Character object) {
            return (NodeValueString)NodeValue.makeNodeString((String)object.toString());
        }

        @Override
        public boolean compatibleWith(NodeValue nodeValue) {
            return nodeValue.getClass().equals(this.getNodeValueType()) && nodeValue.getString().length() == 1;
        }
    }
}

