/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine.functions;

import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.sparql.expr.ExprEvalTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Literal
extends FunctionBase2 {
    private static Logger L = LoggerFactory.getLogger(Literal.class);

    public NodeValue exec(NodeValue v1, NodeValue v2) {
        if (v2.isIRI()) {
            return NodeValue.makeNode((String)v1.asString(), (RDFDatatype)new BaseDatatype(v2.getNode().getURI()));
        }
        if (v2.isString() && !v2.getString().isEmpty()) {
            return NodeValue.makeLangString((String)v1.asString(), (String)v2.getString());
        }
        L.error("Invalid value for lang or datatype: {}", (Object)v2);
        throw new ExprEvalTypeException("Invalid value. Expected (string,iri) or (string,string). Given: " + String.valueOf(v2));
    }
}

