/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine.functions;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.vocabulary.RDF;

public interface FXFunction {
    default public boolean isContainerMembershipProperty(NodeValue ... nodeValues) {
        for (NodeValue nodeValue : nodeValues) {
            if (nodeValue.isIRI() && nodeValue.asNode().getURI().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) continue;
            return false;
        }
        return true;
    }

    default public boolean isSlotConsistent(int number) {
        return number > 0;
    }

    default public int getInt(NodeValue nodeValue) {
        return Integer.parseInt(nodeValue.asNode().getURI().substring(44));
    }

    default public NodeValue asContainerMembershipProperty(int number) {
        if (this.isSlotConsistent(number)) {
            return NodeValue.makeNode((Node)RDF.li((int)number).asNode());
        }
        throw new ExprEvalException("Illegal container membership property with index " + number);
    }
}

