/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine.functions;

import io.github.sparqlanything.engine.functions.FXFunction;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;

public class Entity
extends FunctionBase
implements FXFunction {
    public NodeValue exec(List<NodeValue> list) {
        StringBuilder sb = new StringBuilder();
        for (NodeValue node : list) {
            if (node.isString()) {
                sb.append(node.getString());
                continue;
            }
            if (node.isInteger()) {
                sb.append(node.getInteger().intValue());
                continue;
            }
            if (node.isLiteral()) {
                sb.append(node.asString());
                continue;
            }
            if (node.isBlank()) {
                sb.append(node.getNode().getBlankNodeLabel());
                continue;
            }
            if (node.isIRI()) {
                if (this.isContainerMembershipProperty(new NodeValue[]{node})) {
                    sb.append(this.getInt(node));
                    continue;
                }
                String uri = node.asNode().getURI();
                sb.append(uri);
                continue;
            }
            throw new RuntimeException("Unsupported node value: " + String.valueOf(node));
        }
        return NodeValue.makeNode((Node)NodeFactory.createURI((String)sb.toString()));
    }

    public void checkBuild(String s, ExprList exprList) {
    }
}

