/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine;

import io.github.sparqlanything.engine.FacadeXExecutionContext;
import io.github.sparqlanything.model.IRIArgument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.table.TableUnit;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterDefaulting;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    static boolean isPropertyOp(OpGraph opTripleNext) {
        return opTripleNext.getNode().getURI().equals("http://sparql.xyz/facade-x/ns/properties");
    }

    static boolean isPropertyOp(Node node) {
        return node.isURI() && node.getURI().equals("http://sparql.xyz/facade-x/ns/properties");
    }

    public static String queryIteratorToString(QueryIterator q) {
        StringBuilder sb = new StringBuilder();
        while (q.hasNext()) {
            Binding binding = (Binding)q.next();
            sb.append(Utils.bindingToString(binding));
        }
        return sb.toString();
    }

    public static String printDatasetGraph(DatasetGraph dg) {
        StringBuilder sb = new StringBuilder();
        dg.find().forEachRemaining(q -> sb.append(q.toString()).append("\n"));
        return sb.toString();
    }

    public static String bindingToString(Binding binding) {
        StringBuilder sb = new StringBuilder();
        Iterator vars = binding.vars();
        while (vars.hasNext()) {
            Var var = (Var)vars.next();
            sb.append(String.format("%s -> %s\n", var.getName(), binding.get(var)));
        }
        return sb.toString();
    }

    static boolean isFacadeXMagicPropertyNode(Node node) {
        return node.isURI() && node.getURI().equals("http://sparql.xyz/facade-x/ns/anySlot");
    }

    static QueryIterator postpone(final Op op, QueryIterator input, ExecutionContext execCxt) {
        return new QueryIterRepeatApply(input, execCxt){

            protected QueryIterator nextStage(Binding binding) {
                Op op2 = QC.substitute((Op)op, (Binding)binding);
                QueryIterSingleton thisStep = QueryIterSingleton.create((Binding)binding, (ExecutionContext)this.getExecContext());
                QueryIterator cIter = QC.execute((Op)op2, (QueryIterator)thisStep, (ExecutionContext)super.getExecContext());
                cIter = new QueryIterDefaulting(cIter, binding, this.getExecContext());
                return cIter;
            }
        };
    }

    static List<Triple> getFacadeXMagicPropertyTriples(BasicPattern e) {
        ArrayList<Triple> result = new ArrayList<Triple>();
        e.forEach(t -> {
            if (Utils.isFacadeXMagicPropertyNode(t.getPredicate())) {
                result.add((Triple)t);
            }
        });
        return result;
    }

    static OpBGP extractFakePattern(OpBGP bgp) {
        BasicPattern pattern = new BasicPattern();
        for (Triple t : bgp.getPattern().getList()) {
            if (!t.getSubject().isURI() || !t.getSubject().getURI().equals("http://sparql.xyz/facade-x/ns/properties") || !t.getObject().isVariable()) continue;
            Var s = Var.alloc((String)("s" + System.currentTimeMillis()));
            Var p = Var.alloc((String)("p" + System.currentTimeMillis()));
            pattern.add(Triple.create((Node)s, (Node)p, (Node)t.getObject()));
        }
        return new OpBGP(pattern);
    }

    static OpBGP excludeMagicPropertyTriples(OpBGP bgp) {
        BasicPattern result = new BasicPattern();
        for (Triple t : bgp.getPattern().getList()) {
            if (Utils.isFacadeXMagicPropertyNode(t.getPredicate())) continue;
            result.add(t);
        }
        return new OpBGP(result);
    }

    public static boolean isFacadeXServiceNode(OpService serviceNode) {
        return serviceNode.getService().isURI() && serviceNode.getService().getURI().startsWith("x-sparql-anything:");
    }

    static OpPropFunc getOpPropFuncAnySlot(Triple t) {
        return new OpPropFunc(NodeFactory.createURI((String)"http://sparql.xyz/facade-x/ns/anySlot"), new PropFuncArg(t.getSubject()), new PropFuncArg(t.getObject()), (Op)OpTable.create((Table)new TableUnit()));
    }

    static OpBGP excludeFXProperties(OpBGP bgp) {
        BasicPattern result = new BasicPattern();
        for (Triple t : bgp.getPattern().getList()) {
            if (t.getSubject().isURI() && t.getSubject().getURI().equals("http://sparql.xyz/facade-x/ns/properties")) continue;
            result.add(t);
        }
        return new OpBGP(result);
    }

    static void ensureReadingTxn(DatasetGraph dg) {
        if (!dg.isInTransaction()) {
            logger.debug("begin read txn");
            dg.begin(TxnType.READ);
        }
    }

    public static FacadeXExecutionContext getFacadeXExecutionContext(ExecutionContext execCxt, Properties p, DatasetGraph dg) {
        return new FacadeXExecutionContext(Utils.getNewExecutionContext(execCxt, p, dg));
    }

    public static ExecutionContext getNewExecutionContext(ExecutionContext execCxt, Properties p, DatasetGraph dg) {
        if (p.containsKey(IRIArgument.ONDISK.toString())) {
            return new ExecutionContext(execCxt.getContext(), dg.getUnionGraph(), dg, execCxt.getExecutor());
        }
        return new FacadeXExecutionContext(new ExecutionContext(execCxt.getContext(), dg.getDefaultGraph(), dg, execCxt.getExecutor()));
    }
}

