/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine;

import io.github.sparqlanything.engine.FacadeXExecutionContext;
import io.github.sparqlanything.engine.PropertyExtractor;
import io.github.sparqlanything.engine.Utils;
import io.github.sparqlanything.model.BaseFacadeXGraphBuilder;
import io.github.sparqlanything.model.CloseableIterable;
import io.github.sparqlanything.model.FacadeXGraphBuilder;
import io.github.sparqlanything.model.Slice;
import io.github.sparqlanything.model.Slicer;
import io.github.sparqlanything.model.TripleFilteringFacadeXGraphBuilder;
import io.github.sparqlanything.model.Triplifier;
import io.github.sparqlanything.model.TriplifierHTTPException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.main.QC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryIterSlicer
extends QueryIter {
    private static final Logger logger = LoggerFactory.getLogger(QueryIterSlicer.class);
    final List<Binding> elements;
    private final Iterator<Slice> iterator;
    private final ExecutionContext execCxt;
    private final String resourceId;
    private final Op op;
    private final Slicer slicer;
    private final QueryIterator input;
    private QueryIterator current = null;
    private final Properties p;
    private final CloseableIterable<Slice> it;

    public QueryIterSlicer(ExecutionContext execCxt, QueryIterator input, Triplifier t, Properties properties, Op op) throws TriplifierHTTPException, IOException {
        super(execCxt);
        this.slicer = (Slicer)t;
        this.p = properties;
        this.it = this.slicer.slice(this.p);
        this.input = input;
        this.elements = new ArrayList<Binding>();
        while (input.hasNext()) {
            this.elements.add(input.nextBinding());
        }
        this.iterator = this.it.iterator();
        this.execCxt = execCxt;
        this.resourceId = Triplifier.getResourceId((Properties)this.p);
        this.op = op instanceof OpService ? ((OpService)op).getSubOp() : op;
    }

    protected boolean hasNextBinding() {
        logger.trace("hasNextBinding? ");
        logger.debug("current: {}", this.current != null ? Boolean.valueOf(this.current.hasNext()) : "null");
        while (this.current == null || !this.current.hasNext()) {
            if (this.iterator.hasNext()) {
                BaseFacadeXGraphBuilder builder;
                Slice slice = this.iterator.next();
                logger.debug("Executing on slice: {}", (Object)slice.iteration());
                Integer strategy = PropertyExtractor.detectStrategy(this.p, this.execCxt);
                if (strategy == 1) {
                    logger.trace("Executing: {} [strategy={}]", (Object)this.p, (Object)strategy);
                    builder = new TripleFilteringFacadeXGraphBuilder(this.resourceId, this.op, this.p);
                } else {
                    logger.trace("Executing: {} [strategy={}]", (Object)this.p, (Object)strategy);
                    builder = new BaseFacadeXGraphBuilder(this.p);
                }
                this.slicer.triplify(slice, this.p, (FacadeXGraphBuilder)builder);
                DatasetGraph dg = builder.getDatasetGraph();
                dg.commit();
                dg.end();
                Utils.ensureReadingTxn(dg);
                logger.debug("Executing on next slice: {} ({})", (Object)slice.iteration(), (Object)dg.size());
                FacadeXExecutionContext ec = Utils.getFacadeXExecutionContext(this.execCxt, this.p, dg);
                logger.trace("Op {}", (Object)this.op);
                logger.trace("OpName {}", (Object)this.op.getName());
                QueryIterator cloned = QueryIterPlainWrapper.create(this.elements.iterator());
                this.current = QC.execute((Op)this.op, (QueryIterator)cloned, (ExecutionContext)ec);
                logger.debug("Set current. hasNext? {}", (Object)this.current.hasNext());
                if (!this.current.hasNext()) continue;
                logger.trace("Break.");
                break;
            }
            logger.trace("Slices finished");
            this.input.cancel();
            ExecutionContext exc = new ExecutionContext(DatasetGraphFactory.create());
            QC.execute((Op)this.op, (QueryIterator)QueryIterNullIterator.create((ExecutionContext)exc), (ExecutionContext)exc);
            try {
                this.it.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return false;
        }
        logger.trace("hasNextBinding? {}", (Object)this.current.hasNext());
        return this.current.hasNext();
    }

    protected Binding moveToNextBinding() {
        logger.trace("moveToNextBinding");
        return this.current.nextBinding();
    }

    protected void closeIterator() {
        this.current.close();
    }

    protected void requestCancel() {
        this.current.cancel();
    }
}

