/*
 * Decompiled with CFR 0.152.
 */
package io.github.sparqlanything.engine;

import io.github.sparqlanything.engine.FXSymbol;
import io.github.sparqlanything.engine.FacadeXOpExecutor;
import io.github.sparqlanything.engine.UnboundVariableException;
import io.github.sparqlanything.engine.functions.IsFacadeXExtension;
import io.github.sparqlanything.model.IRIArgument;
import io.github.sparqlanything.model.Triplifier;
import io.github.sparqlanything.model.TriplifierRegister;
import io.github.sparqlanything.zip.FolderTriplifier;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyExtractor {
    private static final Logger logger = LoggerFactory.getLogger(PropertyExtractor.class);

    PropertyExtractor() {
    }

    static int detectStrategy(Properties p, ExecutionContext execCxt) {
        Integer strategy = null;
        String localStrategy = p.getProperty(IRIArgument.STRATEGY.toString());
        Integer globalStrategy = (Integer)execCxt.getContext().get(FacadeXOpExecutor.strategy);
        if (localStrategy != null) {
            if (globalStrategy != null) {
                logger.warn("Local strategy {} overriding global strategy {}", (Object)localStrategy, (Object)globalStrategy);
            }
            strategy = Integer.parseInt(localStrategy);
        } else {
            strategy = globalStrategy != null ? globalStrategy : Integer.valueOf(1);
        }
        return strategy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Triplifier getTriplifier(Properties p, TriplifierRegister triplifierRegister) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        if (!(p.containsKey(IRIArgument.LOCATION.toString()) || p.containsKey(IRIArgument.CONTENT.toString()) || p.containsKey(IRIArgument.COMMAND.toString()))) {
            logger.error("Neither location nor content provided");
            return null;
        }
        if (p.containsKey(IRIArgument.TRIPLIFIER.toString())) {
            logger.trace("Triplifier enforced");
            return (Triplifier)Class.forName(p.getProperty(IRIArgument.TRIPLIFIER.toString())).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (p.containsKey(IRIArgument.MEDIA_TYPE.toString())) {
            logger.trace("MimeType enforced");
            return (Triplifier)Class.forName(triplifierRegister.getTriplifierForMimeType(p.getProperty(IRIArgument.MEDIA_TYPE.toString()))).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (p.containsKey(IRIArgument.LOCATION.toString())) {
            String urlLocation = p.getProperty(IRIArgument.LOCATION.toString());
            File f = new File(p.get(IRIArgument.LOCATION.toString()).toString().replace("file://", ""));
            logger.trace("Use location {}, exists on local FS? {}, is directory? {}", new Object[]{f.getAbsolutePath(), f.exists(), f.isDirectory()});
            if (f.exists() && f.isDirectory()) {
                logger.trace("Return folder triplifier");
                return new FolderTriplifier();
            }
            if (!IsFacadeXExtension.isFacadeXExtension(p.get(IRIArgument.LOCATION.toString()).toString())) return null;
            logger.trace("Guessing triplifier using file extension ");
            String tt = triplifierRegister.getTriplifierForExtension(FilenameUtils.getExtension((String)urlLocation));
            logger.trace("Guessed extension: {} :: {} ", (Object)FilenameUtils.getExtension((String)urlLocation), (Object)tt);
            return (Triplifier)Class.forName(tt).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        logger.trace("No location provided, using the Text triplifier");
        return (Triplifier)Class.forName("io.github.sparqlanything.text.TextTriplifier").getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    static void extractPropertiesFromBGP(Properties properties, OpBGP bgp) throws UnboundVariableException {
        for (Triple t : bgp.getPattern().getList()) {
            if (!t.getSubject().isURI() || !t.getSubject().getURI().equals("http://sparql.xyz/facade-x/ns/properties")) continue;
            if (t.getObject().isURI()) {
                properties.put(t.getPredicate().getURI().replace("http://sparql.xyz/facade-x/ns/", ""), t.getObject().getURI());
                continue;
            }
            if (t.getObject().isLiteral()) {
                properties.put(t.getPredicate().getURI().replace("http://sparql.xyz/facade-x/ns/", ""), t.getObject().getLiteral().getValue().toString());
                continue;
            }
            if (!t.getObject().isVariable()) continue;
            throw new UnboundVariableException(t.getObject().getName(), bgp);
        }
    }

    public static void extractPropertiesFromExecutionContext(ExecutionContext execCxt, Properties p) {
        execCxt.getContext().keys().forEach(symbol -> {
            if (symbol instanceof FXSymbol) {
                p.setProperty(symbol.getSymbol(), (String)execCxt.getContext().get(symbol));
            }
        });
    }
}

